/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.EvolutionState;
import ec.Individual;
import ec.gep.GEPFitnessFunction;
import ec.gep.GEPIndividual;
import ec.gep.GEPProblem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.lang.reflect.Method;
import java.util.Vector;

public class GEPDefaultUserProg
extends GEPProblem
implements SimpleProblemForm {
    String fitnessFunction = "";
    double[] ffArgs;
    boolean ffExtraArgs = false;
    int ffMaxArgs = 1;
    boolean ffUseTrainingSet = true;
    public static final String P_FITNESS_FUNCTION = "fitness-function";
    public static final String P_FITNESS_FUNCTION_ARG = "fitness-function-arg";
    public static final String P_FITNESS_FUNCTION_IDEAL_PERCENT_THRESHOLD = "fitness-function-ideal-percent-threshold";
    Method fitnessMethod = null;
    Method fitnessMaxMethod = null;
    double idealValuePercentThreshold;
    public static final double idealValuePercentThresholdDefault = 99.999999;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        String string = evolutionState.parameters.getStringWithDefault(parameter.push(P_FITNESS_FUNCTION), parameter.push(P_FITNESS_FUNCTION), "");
        String string2 = "";
        if (string.equals("")) {
            evolutionState.output.fatal("Must specify the fitness-function parameter when using the default user program (GEPDefaultUserProg).", parameter.push(P_FITNESS_FUNCTION));
        }
        string2 = String.valueOf(string) + "maxFitness";
        string = String.valueOf(string) + "fitness";
        try {
            this.fitnessMethod = GEPFitnessFunction.class.getMethod(string, Boolean.TYPE, GEPIndividual.class, double[].class);
            this.ffExtraArgs = true;
        }
        catch (Exception exception) {
            try {
                this.fitnessMethod = GEPFitnessFunction.class.getMethod(string, Boolean.TYPE, GEPIndividual.class);
                this.ffExtraArgs = false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                evolutionState.output.fatal("GEPDEfaultUserProg:No fitness-function '" + string + "' was found.\n" + noSuchMethodException);
            }
        }
        try {
            this.fitnessMaxMethod = GEPFitnessFunction.class.getMethod(string2, GEPIndividual.class);
            this.ffMaxArgs = 1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                this.fitnessMaxMethod = GEPFitnessFunction.class.getMethod(string2, Boolean.TYPE, GEPIndividual.class);
                this.ffMaxArgs = 2;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                evolutionState.output.fatal("GEPDEfaultUserProg:No max fitness-function '" + string2 + "' was found.\n" + noSuchMethodException2);
            }
        }
        if (this.ffExtraArgs) {
            Vector<Double> vector = new Vector<Double>();
            int n = 0;
            String string3 = P_FITNESS_FUNCTION_ARG + n;
            while (evolutionState.parameters.exists(parameter.push(string3))) {
                Double d = new Double(evolutionState.parameters.getDoubleWithDefault(parameter.push(string3), parameter.push(string3), 0.0));
                vector.add(d);
                string3 = P_FITNESS_FUNCTION_ARG + ++n;
            }
            this.ffArgs = new double[vector.size()];
            int n2 = 0;
            while (n2 < this.ffArgs.length) {
                this.ffArgs[n2] = (Double)vector.get(n2);
                ++n2;
            }
        }
        this.idealValuePercentThreshold = evolutionState.parameters.getDoubleWithDefault(parameter.push(P_FITNESS_FUNCTION_IDEAL_PERCENT_THRESHOLD), parameter.push(P_FITNESS_FUNCTION_IDEAL_PERCENT_THRESHOLD), 99.999999);
        if (this.idealValuePercentThreshold <= 0.0 || this.idealValuePercentThreshold > 100.0) {
            evolutionState.output.warning("GEPDEfaultUserProg: setup found parameter fitness-function-ideal-percent-threshold to be less than zero or greater than 100; defaulting to 99.999999");
            this.idealValuePercentThreshold = 99.999999;
        }
    }

    public void evaluate(EvolutionState evolutionState, Individual individual, int n, int n2) {
        if (!individual.evaluated) {
            double d = 0.0;
            double d2 = 0.0;
            try {
                Double d3 = this.ffExtraArgs ? (Double)this.fitnessMethod.invoke(null, this.ffUseTrainingSet, (GEPIndividual)individual, this.ffArgs) : (Double)this.fitnessMethod.invoke(null, this.ffUseTrainingSet, (GEPIndividual)individual);
                d = d3;
                Double d4 = this.ffMaxArgs == 1 ? (Double)this.fitnessMaxMethod.invoke(null, (GEPIndividual)individual) : (Double)this.fitnessMaxMethod.invoke(null, this.ffUseTrainingSet, (GEPIndividual)individual);
                d2 = d4;
            }
            catch (Exception exception) {
                evolutionState.output.fatal("GEPDefaultUserProg: Error executing fitness function or fitness max value function\n" + exception);
            }
            SimpleFitness simpleFitness = (SimpleFitness)individual.fitness;
            simpleFitness.setFitness(evolutionState, (float)d, d >= d2 * this.idealValuePercentThreshold);
            individual.evaluated = true;
        }
    }
}

