/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import java.io.Serializable;

public class GEPDependentVariable
implements Serializable {
    public static GEPDependentVariable trainingData = new GEPDependentVariable();
    public static GEPDependentVariable testingData = new GEPDependentVariable();
    public double[][] values = null;
    static String symbol = "dependentVariable";
    public double[] dependentVariableMean = null;
    public double[] dependentVariableSumOfAbsoluteError = null;
    public double[] dependentVariableSumOfSquaredAbsoluteError = null;
    public double[] dependentVariableSumOfRelativeError = null;
    public double[] dependentVariableSumOfSquaredRelativeError = null;
    public double[] dependentVariableVariance = null;

    public void setup(int n) {
        this.values = new double[n][];
        this.dependentVariableMean = new double[n];
        this.dependentVariableSumOfAbsoluteError = new double[n];
        this.dependentVariableSumOfSquaredAbsoluteError = new double[n];
        this.dependentVariableSumOfRelativeError = new double[n];
        this.dependentVariableSumOfSquaredRelativeError = new double[n];
        this.dependentVariableVariance = new double[n];
    }

    public void setValues(double[] dArray) {
        this.setValues(dArray, 0);
    }

    public void setValues(double[] dArray, int n) {
        this.values[n] = new double[dArray.length];
        System.arraycopy(dArray, 0, this.values[n], 0, dArray.length);
        this.calculateDependentVariableStats(n);
    }

    public void calculateDependentVariableStats(int n) {
        if (this.values[n] == null) {
            return;
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.values[n].length) {
            d += this.values[n][n2];
            ++n2;
        }
        this.dependentVariableMean[n] = d / (double)this.values[n].length;
        this.dependentVariableSumOfAbsoluteError[n] = 0.0;
        this.dependentVariableSumOfSquaredAbsoluteError[n] = 0.0;
        this.dependentVariableSumOfRelativeError[n] = 0.0;
        this.dependentVariableSumOfSquaredRelativeError[n] = 0.0;
        n2 = 0;
        while (n2 < this.values[n].length) {
            double d2 = this.values[n][n2] - this.dependentVariableMean[n];
            int n3 = n;
            this.dependentVariableSumOfAbsoluteError[n3] = this.dependentVariableSumOfAbsoluteError[n3] + Math.abs(d2);
            int n4 = n;
            this.dependentVariableSumOfSquaredAbsoluteError[n4] = this.dependentVariableSumOfSquaredAbsoluteError[n4] + d2 * d2;
            double d3 = d2 / this.dependentVariableMean[n];
            int n5 = n;
            this.dependentVariableSumOfRelativeError[n5] = this.dependentVariableSumOfRelativeError[n5] + Math.abs(d3);
            int n6 = n;
            this.dependentVariableSumOfSquaredRelativeError[n6] = this.dependentVariableSumOfSquaredRelativeError[n6] + d3 * d3;
            ++n2;
        }
        this.dependentVariableVariance[n] = this.dependentVariableSumOfSquaredAbsoluteError[n] / (double)this.values[n].length;
    }

    public double[] getDependentVariableValues(int n) {
        return this.values[n];
    }

    public double[] getDependentVariableValues() {
        return this.values[0];
    }

    public double getDependentVariableMean(int n) {
        return this.dependentVariableMean[n];
    }

    public double getDependentVariableMean() {
        return this.dependentVariableMean[0];
    }

    public double getDependentVariableSumOfAbsoluteError() {
        return this.dependentVariableSumOfAbsoluteError[0];
    }

    public double getDependentVariableSumOfAbsoluteError(int n) {
        return this.dependentVariableSumOfAbsoluteError[n];
    }

    public double getDependentVariableSumOfSquaredAbsoluteError(int n) {
        return this.dependentVariableSumOfSquaredAbsoluteError[n];
    }

    public double getDependentVariableSumOfSquaredAbsoluteError() {
        return this.dependentVariableSumOfSquaredAbsoluteError[0];
    }

    public double getDependentVariableSumOfRelativeError(int n) {
        return this.dependentVariableSumOfRelativeError[n];
    }

    public double getDependentVariableSumOfRelativeError() {
        return this.dependentVariableSumOfRelativeError[0];
    }

    public double getDependentVariableSumOfSquaredRelativeError(int n) {
        return this.dependentVariableSumOfSquaredRelativeError[n];
    }

    public double getDependentVariableSumOfSquaredRelativeError() {
        return this.dependentVariableSumOfSquaredRelativeError[0];
    }

    public double getDependentVariableVariance(int n) {
        return this.dependentVariableVariance[n];
    }

    public double getDependentVariableVariance() {
        return this.dependentVariableVariance[0];
    }
}

