/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.gep.GEPConstantTerminalSymbol;
import ec.gep.GEPFunctionSymbol;
import ec.gep.GEPSymbol;
import ec.gep.GEPTerminalSymbol;
import java.io.Serializable;
import java.util.HashMap;

public class GEPExpressionTreeNode
implements Serializable,
Cloneable {
    public GEPExpressionTreeNode[] parameters;
    double[] evaluatedParameters = null;
    public GEPSymbol symbol;
    public int numParameters = 0;
    public boolean isConstantNode = false;
    public double constantValue;

    public GEPExpressionTreeNode(GEPSymbol gEPSymbol) {
        this.symbol = gEPSymbol;
        if (gEPSymbol.arity == 0) {
            return;
        }
        this.parameters = new GEPExpressionTreeNode[gEPSymbol.arity];
        this.evaluatedParameters = new double[gEPSymbol.arity];
    }

    public GEPExpressionTreeNode(GEPSymbol gEPSymbol, double d) {
        this(gEPSymbol);
        this.isConstantNode = true;
        this.constantValue = d;
    }

    public void addParameter(GEPExpressionTreeNode gEPExpressionTreeNode) {
        this.parameters[this.numParameters++] = gEPExpressionTreeNode;
    }

    public double eval(boolean bl, int n) {
        if (this.isConstantNode) {
            return this.constantValue;
        }
        if (this.symbol instanceof GEPTerminalSymbol) {
            return ((GEPTerminalSymbol)this.symbol).eval(bl, n);
        }
        int n2 = 0;
        while (n2 < this.numParameters) {
            this.evaluatedParameters[n2] = this.parameters[n2].eval(bl, n);
            if (Double.isInfinite(this.evaluatedParameters[n2]) || Double.isNaN(this.evaluatedParameters[n2])) {
                return Double.NaN;
            }
            ++n2;
        }
        return ((GEPFunctionSymbol)this.symbol).eval(this.evaluatedParameters);
    }

    public Object clone() {
        if (this.isConstantNode) {
            return new GEPExpressionTreeNode(this.symbol, this.constantValue);
        }
        GEPExpressionTreeNode gEPExpressionTreeNode = new GEPExpressionTreeNode(this.symbol);
        gEPExpressionTreeNode.numParameters = this.numParameters;
        int n = 0;
        while (n < this.numParameters) {
            gEPExpressionTreeNode.parameters[n] = (GEPExpressionTreeNode)this.parameters[n].clone();
            ++n;
        }
        return gEPExpressionTreeNode;
    }

    public int numberOfNodes() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numParameters) {
            n += this.parameters[n2].numberOfNodes();
            ++n2;
        }
        return 1 + n;
    }

    public void variableUseageCounts(int[] nArray) {
        if (this.symbol instanceof GEPTerminalSymbol && !(this.symbol instanceof GEPConstantTerminalSymbol)) {
            GEPTerminalSymbol gEPTerminalSymbol = (GEPTerminalSymbol)this.symbol;
            int n = gEPTerminalSymbol.id - gEPTerminalSymbol.symbolSet.getBaseTerminalSymbolId();
            nArray[n] = nArray[n] + 1;
        }
        int n = 0;
        while (n < this.numParameters) {
            this.parameters[n].variableUseageCounts(nArray);
            ++n;
        }
    }

    public void functionUseageCounts(HashMap hashMap) {
        if (this.symbol instanceof GEPFunctionSymbol) {
            GEPFunctionSymbol gEPFunctionSymbol = (GEPFunctionSymbol)this.symbol;
            Integer n = (Integer)hashMap.get(gEPFunctionSymbol.symbol);
            if (n == null) {
                hashMap.put(gEPFunctionSymbol.symbol, 1);
            } else {
                hashMap.put(gEPFunctionSymbol.symbol, n + 1);
            }
        }
        int n = 0;
        while (n < this.numParameters) {
            this.parameters[n].functionUseageCounts(hashMap);
            ++n;
        }
    }
}

