/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import com.csvreader.CsvReader;
import ec.EvolutionState;
import ec.gep.GEPDefaults;
import ec.gep.GEPDependentVariable;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.util.Parameter;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class GEPFitnessFunction {
    static double RELATIVE_ERROR_ZERO_FACTOR = 1.0E-9;
    static double PARSIMONY_PRESSURE_FACTOR = 5000.0;
    static double AEWSRrange = 1.0;
    static double REWSRrange = 1.0;
    private static double ZERO = 1.0E-6;
    private static int WEIGHTED_EUCLIDEAN_DISTANCE_INDEX = 0;
    private static int NUMBER_OF_COMMON_VARIABLES_INDEX = 1;
    private static int NORMALIZED_WEIGHTED_EUCLIDEAN_DISTANCE_INDEX = 2;
    private static double[][] originalDisimMatrix;
    private static double sumOfTheLowerTriangle;

    static {
        sumOfTheLowerTriangle = 0.0;
    }

    public static void setup(EvolutionState evolutionState) {
        int n;
        Parameter parameter = GEPDefaults.base().push("fitness").push("dissimilarity-matrix");
        String string = evolutionState.parameters.getStringWithDefault(parameter, parameter, "");
        if (string.equals("")) {
            return;
        }
        CsvReader csvReader = null;
        try {
            csvReader = new CsvReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("WARNING: The dissimilarity matrix data file could not be found");
            return;
        }
        csvReader.setDelimiter(',');
        try {
            csvReader.readRecord();
            int n2 = Integer.parseInt(csvReader.get(0));
            originalDisimMatrix = new double[n2][];
            GEPFitnessFunction.originalDisimMatrix[0] = new double[1];
            csvReader.readRecord();
            GEPFitnessFunction.originalDisimMatrix[0][0] = Double.parseDouble(csvReader.get(0));
            n = 1;
            while (n < n2) {
                GEPFitnessFunction.originalDisimMatrix[n] = new double[n];
                csvReader.readRecord();
                int n3 = 0;
                while (n3 < n) {
                    GEPFitnessFunction.originalDisimMatrix[n][n3] = Double.parseDouble(csvReader.get(n3));
                    ++n3;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("Problem reading the dissimilarity matrix" + iOException);
        }
        int n4 = 1;
        while (n4 < originalDisimMatrix.length) {
            n = 0;
            while (n < originalDisimMatrix[n4].length) {
                sumOfTheLowerTriangle += originalDisimMatrix[n4][n];
                ++n;
            }
            ++n4;
        }
    }

    public static double RAErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d2 = gEPDependentVariable.getDependentVariableSumOfAbsoluteError(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = dArray[n2];
            double d4 = gEPIndividual.eval(n, bl, n2);
            double d5 = d4 - d3;
            d += Math.abs(d5);
            ++n2;
        }
        if (d2 == 0.0) {
            d2 = RELATIVE_ERROR_ZERO_FACTOR;
            System.err.println("Warning: sum of error for dependent variable is 0 in RAE fitness calculation. Adjusting to avoid division by zero.");
        }
        return d / d2;
    }

    public static double RAEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.RAErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double RAEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double rRAErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d2 = gEPDependentVariable.getDependentVariableSumOfRelativeError(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = dArray[n2];
            double d4 = gEPIndividual.eval(n, bl, n2);
            if (d3 == 0.0) {
                d3 = RELATIVE_ERROR_ZERO_FACTOR;
                d4 += RELATIVE_ERROR_ZERO_FACTOR;
                System.err.println("Warning: expected result (test value) is 0 in rRAE fitness calculation. Adjusting to avoid division by zero.");
            }
            double d5 = (d4 - d3) / d3;
            d += Math.abs(d5);
            ++n2;
        }
        if (d2 == 0.0) {
            d2 = RELATIVE_ERROR_ZERO_FACTOR;
            System.err.println("Warning: sum of error for dependent variable is 0 in rRAE fitness calculation. Adjusting to avoid division by zero.");
        }
        return d / d2;
    }

    public static double rRAEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.rRAErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double rRAEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double MAErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d2 = dArray[n2];
            double d3 = gEPIndividual.eval(n, bl, n2);
            double d4 = d3 - d2;
            d += Math.abs(d4);
            ++n2;
        }
        return d / (double)dArray.length;
    }

    public static double MAEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.MAErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double MAEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double rMAErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d2 = dArray[n2];
            double d3 = gEPIndividual.eval(n, bl, n2);
            if (d2 == 0.0) {
                d2 = RELATIVE_ERROR_ZERO_FACTOR;
                d3 += RELATIVE_ERROR_ZERO_FACTOR;
                System.err.println("Warning: expected result (test value) is 0 in rMAE fitness calculation. Adjusting to avoid division by zero.");
            }
            double d4 = (d3 - d2) / d2;
            d += Math.abs(d4);
            ++n2;
        }
        return d / (double)dArray.length;
    }

    public static double rMAEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.rMAErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double rMAEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double MSErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d2 = dArray[n2];
            double d3 = gEPIndividual.eval(n, bl, n2);
            double d4 = d3 - d2;
            d += d4 * d4;
            ++n2;
        }
        return d / (double)dArray.length;
    }

    public static double MSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.MSErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double MSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double rMSErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d2 = dArray[n2];
            double d3 = gEPIndividual.eval(n, bl, n2);
            if (d2 == 0.0) {
                d2 = RELATIVE_ERROR_ZERO_FACTOR;
                d3 += RELATIVE_ERROR_ZERO_FACTOR;
                System.err.println("Warning: expected result (test value) is 0 in rMSE fitness calculation. Adjusting to avoid division by zero.");
            }
            double d4 = (d3 - d2) / d2;
            d += d4 * d4;
            ++n2;
        }
        return d / (double)dArray.length;
    }

    public static double rMSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.rMSErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double rMSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double RMSErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d2 = dArray[n2];
            double d3 = gEPIndividual.eval(n, bl, n2);
            if (Double.isInfinite(d3) || Double.isNaN(d3)) {
                return Double.NaN;
            }
            double d4 = d3 - d2;
            d += d4 * d4;
            ++n2;
        }
        return Math.sqrt(d / (double)dArray.length);
    }

    public static double RMSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.RMSErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double RMSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double rRMSErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d2 = dArray[n2];
            double d3 = gEPIndividual.eval(n, bl, n2);
            if (d2 == 0.0) {
                d2 = RELATIVE_ERROR_ZERO_FACTOR;
                d3 += RELATIVE_ERROR_ZERO_FACTOR;
                System.err.println("Warning: expected result (test value) is 0 in rRMSE fitness calculation. Adjusting to avoid division by zero.");
            }
            double d4 = (d3 - d2) / d2;
            d += d4 * d4;
            ++n2;
        }
        return Math.sqrt(d / (double)dArray.length);
    }

    public static double rRMSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.rRMSErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double rRMSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double RSErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d2 = gEPDependentVariable.getDependentVariableSumOfSquaredAbsoluteError(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = dArray[n2];
            double d4 = gEPIndividual.eval(n, bl, n2);
            double d5 = d4 - d3;
            d += d5 * d5;
            ++n2;
        }
        if (d2 == 0.0) {
            d2 = RELATIVE_ERROR_ZERO_FACTOR;
            System.err.println("Warning: sum of squared error for dependent variable is 0 in RSE fitness calculation. Adjusting to avoid division by zero.");
        }
        return d / d2;
    }

    public static double RSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.RSErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double RSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double rRSErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d2 = gEPDependentVariable.getDependentVariableSumOfSquaredRelativeError(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = dArray[n2];
            double d4 = gEPIndividual.eval(n, bl, n2);
            if (d3 == 0.0) {
                d3 = RELATIVE_ERROR_ZERO_FACTOR;
                d4 += RELATIVE_ERROR_ZERO_FACTOR;
                System.err.println("Warning: expected result (test value) is 0 in rRSE fitness calculation. Adjusting to avoid division by zero.");
            }
            double d5 = (d4 - d3) / d3;
            d += d5 * d5;
            ++n2;
        }
        if (d2 == 0.0) {
            d2 = RELATIVE_ERROR_ZERO_FACTOR;
            System.err.println("Warning: sum of squared relative error for dependent variable is 0 in rRSE fitness calculation. Adjusting to avoid division by zero.");
        }
        return d / d2;
    }

    public static double rRSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.rRSErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double rRSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double RRSErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d2 = gEPDependentVariable.getDependentVariableSumOfSquaredAbsoluteError(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = dArray[n2];
            double d4 = gEPIndividual.eval(n, bl, n2);
            double d5 = d4 - d3;
            d += d5 * d5;
            ++n2;
        }
        if (d2 == 0.0) {
            d2 = RELATIVE_ERROR_ZERO_FACTOR;
            System.err.println("Warning: sum of squared error for dependent variable is 0 in RRSE fitness calculation. Adjusting to avoid division by zero.");
        }
        return Math.sqrt(d / d2);
    }

    public static double RRSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.RRSErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double RRSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double rRRSErawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        double d = 0.0;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d2 = gEPDependentVariable.getDependentVariableSumOfSquaredRelativeError(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = dArray[n2];
            double d4 = gEPIndividual.eval(n, bl, n2);
            if (d3 == 0.0) {
                d3 = RELATIVE_ERROR_ZERO_FACTOR;
                d4 += RELATIVE_ERROR_ZERO_FACTOR;
                System.err.println("Warning: expected result (test value) is 0 in rRRSE fitness calculation. Adjusting to avoid division by zero.");
            }
            double d5 = (d4 - d3) / d3;
            d += d5 * d5;
            ++n2;
        }
        if (d2 == 0.0) {
            d2 = RELATIVE_ERROR_ZERO_FACTOR;
            System.err.println("Warning: sum of squared relative error for dependent variable is 0 in rRRSE fitness calculation. Adjusting to avoid division by zero.");
        }
        return Math.sqrt(d / d2);
    }

    public static double rRRSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.rRRSErawFitness(bl, gEPIndividual, 0);
        return 1000.0 / (1.0 + d);
    }

    public static double rRRSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double CCrawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d = gEPDependentVariable.getDependentVariableVariance(n);
        double d2 = gEPDependentVariable.getDependentVariableMean(n);
        double d3 = Math.sqrt(d);
        double d4 = 0.0;
        double[] dArray2 = new double[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray2[n2] = gEPIndividual.eval(n, bl, n2);
            d4 += dArray2[n2];
            ++n2;
        }
        double d5 = d4 / (double)dArray.length;
        double d6 = 0.0;
        double d7 = 0.0;
        int n3 = 0;
        while (n3 < dArray.length) {
            double d8 = dArray[n3];
            double d9 = dArray2[n3];
            double d10 = d9 - d5;
            d6 += (d8 - d2) * d10;
            d7 += d10 * d10;
            ++n3;
        }
        double d11 = d6 / (double)dArray.length;
        double d12 = Math.sqrt(d7 / (double)dArray.length);
        double d13 = d11 / (d3 * d12);
        return Math.min(1.0, Math.max(d13, -1.0));
    }

    public static double CCfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.CCrawFitness(bl, gEPIndividual, 0);
        return 500.0 * (d + 1.0);
    }

    public static double CCmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double RSrawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            double d6 = gEPIndividual.eval(n, bl, n3);
            d += d6;
            d3 += d6 * d6;
            double d7 = dArray[n3];
            d5 += d7;
            d4 += d7 * d7;
            d2 += d6 * d7;
            ++n3;
        }
        double d8 = (double)dArray.length * d2 - d5 * d;
        double d9 = Math.sqrt(((double)n2 * d4 - d5 * d5) * ((double)n2 * d3 - d * d));
        if (d9 == 0.0) {
            d9 = RELATIVE_ERROR_ZERO_FACTOR;
            System.err.println("Warning: denominator is 0 in RS (R-Squared) fitness calculation. Adjusting to avoid division by zero.");
        }
        return d8 / d9;
    }

    public static double RSfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.RSrawFitness(bl, gEPIndividual, 0);
        return 1000.0 * d * d;
    }

    public static double RSmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double AHrawFitness(boolean bl, GEPIndividual gEPIndividual, int n, double d) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d2 = 0.0;
        int n2 = dArray.length;
        if (d < 0.0) {
            d = -d;
            System.err.println("Warning: precision (" + d + ") < 0 in call to AHfitness, setting to -precision.");
        }
        int n3 = 0;
        while (n3 < n2) {
            double d3;
            double d4 = gEPIndividual.eval(n, bl, n3);
            if (Math.abs(d4 - (d3 = dArray[n3])) <= d) {
                d2 += 1.0;
            }
            ++n3;
        }
        return d2;
    }

    public static double AHfitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        if (dArray.length != 1) {
            System.err.println("Warning: 2nd arg to AHfitness method expected to have 1 double value (precision) but has " + dArray.length);
        }
        double d = GEPFitnessFunction.AHrawFitness(bl, gEPIndividual, 0, dArray[0]);
        return d;
    }

    public static double AHmaxFitness(boolean bl, GEPIndividual gEPIndividual) {
        return bl ? GEPDependentVariable.trainingData.getDependentVariableValues().length : GEPDependentVariable.testingData.getDependentVariableValues().length;
    }

    public static double RHrawFitness(boolean bl, GEPIndividual gEPIndividual, int n, double d) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d2 = 0.0;
        int n2 = dArray.length;
        if (d < 0.0) {
            d = -d;
            System.err.println("Warning: precision (" + d + ") < 0 in call to RHfitness, setting to -precision.");
        }
        int n3 = 0;
        while (n3 < n2) {
            double d3 = gEPIndividual.eval(n, bl, n3);
            double d4 = dArray[n3];
            if (d4 == 0.0) {
                d4 = RELATIVE_ERROR_ZERO_FACTOR;
                d3 += RELATIVE_ERROR_ZERO_FACTOR;
                System.err.println("Warning: expected result = 0 in calculation of RHfitness, adjusting to avoid division by zero.");
            }
            if (Math.abs((d3 - d4) / d4 * 100.0) <= d) {
                d2 += 1.0;
            }
            ++n3;
        }
        return d2;
    }

    public static double RHfitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        if (dArray.length != 1) {
            System.err.println("Warning: 2nd arg to RHfitness method expected to have 1 double value (precision) but has " + dArray.length);
        }
        double d = GEPFitnessFunction.RHrawFitness(bl, gEPIndividual, 0, dArray[0]);
        return d;
    }

    public static double RHmaxFitness(boolean bl, GEPIndividual gEPIndividual) {
        return bl ? GEPDependentVariable.trainingData.getDependentVariableValues().length : GEPDependentVariable.testingData.getDependentVariableValues().length;
    }

    public static double AEWSRrawFitness(boolean bl, GEPIndividual gEPIndividual, int n, double d, double d2) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = dArray.length;
        if (d2 < 0.0) {
            d2 = -d2;
            System.err.println("Warning: precision (" + d2 + ") < 0 in call to AEWSR fitness, setting to -precision.");
        }
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d4;
            double d5 = gEPIndividual.eval(n, bl, n3);
            double d6 = Math.abs(d5 - (d4 = dArray[n3]));
            if (d6 <= d2) {
                d6 = 0.0;
            }
            d3 += d - d6;
            ++n3;
        }
        return d3;
    }

    public static double AEWSRfitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        if (dArray.length != 2) {
            System.err.println("Warning: 2nd arg to AEWSRfitness method expected to have 2 double values (range and precision) but has " + dArray.length);
        }
        AEWSRrange = dArray[0];
        double d = dArray[1];
        double d2 = GEPFitnessFunction.AEWSRrawFitness(bl, gEPIndividual, 0, AEWSRrange, d);
        return d2;
    }

    public static double AEWSRmaxFitness(boolean bl, GEPIndividual gEPIndividual) {
        int n = bl ? GEPDependentVariable.trainingData.getDependentVariableValues().length : GEPDependentVariable.testingData.getDependentVariableValues().length;
        return (double)n * AEWSRrange;
    }

    public static double AEWSRmaxFitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        int n = bl ? GEPDependentVariable.trainingData.getDependentVariableValues().length : GEPDependentVariable.testingData.getDependentVariableValues().length;
        return (double)n * dArray[0];
    }

    public static double REWSRrawFitness(boolean bl, GEPIndividual gEPIndividual, int n, double d, double d2) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = dArray.length;
        if (d2 < 0.0) {
            d2 = -d2;
            System.err.println("Warning: precision (" + d2 + ") < 0 in call to REWSR fitness, setting to -precision.");
        }
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d4;
            double d5 = gEPIndividual.eval(n, bl, n3);
            double d6 = dArray[n3];
            if (d6 == 0.0) {
                d6 = RELATIVE_ERROR_ZERO_FACTOR;
                d5 += RELATIVE_ERROR_ZERO_FACTOR;
                System.err.println("Warning: expected result = 0 in calculation of REWSRfitness, adjusting to avoid division by zero.");
            }
            if ((d4 = Math.abs((d5 - d6) / d6 * 100.0)) <= d2) {
                d4 = 0.0;
            }
            d3 += d - d4;
            ++n3;
        }
        return d3;
    }

    public static double REWSRfitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        if (dArray.length != 2) {
            System.err.println("Warning: 2nd arg to REWSRfitness method expected to have 2 double values (range and precision) but has " + dArray.length);
        }
        REWSRrange = dArray[0];
        double d = dArray[1];
        double d2 = GEPFitnessFunction.REWSRrawFitness(bl, gEPIndividual, 0, REWSRrange, d);
        return d2;
    }

    public static double REWSRmaxFitness(boolean bl, GEPIndividual gEPIndividual) {
        int n = bl ? GEPDependentVariable.trainingData.getDependentVariableValues().length : GEPDependentVariable.testingData.getDependentVariableValues().length;
        return (double)n * REWSRrange;
    }

    public static double NHrawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        double d = 0.0;
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            double d2;
            double d3 = gEPIndividual.eval(n, bl, n3);
            if (d3 == (d2 = dArray[n3])) {
                d += 1.0;
            }
            ++n3;
        }
        return d;
    }

    public static double NHfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.NHrawFitness(bl, gEPIndividual, 0);
        return d;
    }

    public static double NHmaxFitness(boolean bl, GEPIndividual gEPIndividual) {
        return bl ? GEPDependentVariable.trainingData.getDependentVariableValues().length : GEPDependentVariable.testingData.getDependentVariableValues().length;
    }

    public static double NHWPrawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        int[] nArray = GEPFitnessFunction.getConfusionMatrixValues(bl, gEPIndividual, n);
        int n2 = nArray[0];
        int n3 = nArray[3];
        if (n2 == 0 || n3 == 0) {
            return 0.0;
        }
        return n2 + n3;
    }

    public static double NHWPfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.NHWPrawFitness(bl, gEPIndividual, 0);
        return d;
    }

    public static double NHWPmaxFitness(boolean bl, GEPIndividual gEPIndividual) {
        return bl ? GEPDependentVariable.trainingData.getDependentVariableValues().length : GEPDependentVariable.testingData.getDependentVariableValues().length;
    }

    public static double ACCrawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = dArray.length;
        int[] nArray = GEPFitnessFunction.getConfusionMatrixValues(bl, gEPIndividual, n);
        int n3 = nArray[0];
        int n4 = nArray[3];
        return (double)(n3 + n4) / (double)n2;
    }

    public static double ACCfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.ACCrawFitness(bl, gEPIndividual, 0);
        return 1000.0 * d;
    }

    public static double ACCmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double SACCfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.ACCrawFitness(bl, gEPIndividual, 0);
        return 1000.0 * d * d;
    }

    public static double SACCmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double SSrawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        int[] nArray = GEPFitnessFunction.getConfusionMatrixValues(bl, gEPIndividual, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = n2 + n3;
        int n7 = n5 + n4;
        if (n6 == 0 || n7 == 0) {
            return 0.0;
        }
        double d = (double)n2 / (double)n6;
        double d2 = (double)n5 / (double)n7;
        return d * d2;
    }

    public static double SSfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.SSrawFitness(bl, gEPIndividual, 0);
        return 1000.0 * d;
    }

    public static double SSmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double PPVNPVrawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        int[] nArray = GEPFitnessFunction.getConfusionMatrixValues(bl, gEPIndividual, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = n2 + n4;
        int n7 = n5 + n3;
        if (n6 == 0 || n7 == 0) {
            return 0.0;
        }
        double d = (double)n2 / (double)n6;
        double d2 = (double)n5 / (double)n7;
        return d * d2;
    }

    public static double PPVNPVfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.PPVNPVrawFitness(bl, gEPIndividual, 0);
        return 1000.0 * d;
    }

    public static double PPVNPVmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double SSPNrawFitness(boolean bl, GEPIndividual gEPIndividual, int n) {
        int[] nArray = GEPFitnessFunction.getConfusionMatrixValues(bl, gEPIndividual, n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = n2 + n3;
        int n7 = n5 + n4;
        if (n6 == 0 || n7 == 0) {
            return 0.0;
        }
        int n8 = n2 + n4;
        int n9 = n5 + n3;
        if (n8 == 0 || n9 == 0) {
            return 0.0;
        }
        double d = (double)n2 / (double)n8;
        double d2 = (double)n5 / (double)n9;
        double d3 = (double)n2 / (double)n6;
        double d4 = (double)n5 / (double)n7;
        return d3 * d4 * d * d2;
    }

    public static double SSPNfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = GEPFitnessFunction.SSPNrawFitness(bl, gEPIndividual, 0);
        return 1000.0 * d;
    }

    public static double SSPNmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double WCorrRMSEfitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        return GEPFitnessFunction.WCorrRMSEfitness(bl, gEPIndividual, 0, dArray);
    }

    public static double WCorrRMSEfitness(boolean bl, GEPIndividual gEPIndividual, int n, double[] dArray) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray2 = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = dArray2.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d13 = dArray2[n3];
            double d14 = gEPIndividual.eval(n, bl, n3);
            double d15 = d14 - d13;
            d2 += d15 * d15;
            d5 += d14;
            d6 += d14 * d14;
            d8 += d13;
            d9 += d13 * d13;
            d7 += d14 * d13;
            ++n3;
        }
        d3 = d2 / (double)n2;
        d4 = Math.sqrt(d3);
        double d16 = 1000.0 / (1.0 + d4);
        d10 = d6 - d5 * d5 / (double)n2;
        d11 = d9 - d8 * d8 / (double)n2;
        d12 = d7 - d5 * d8 / (double)n2;
        double d17 = d12 / Math.sqrt(d10 * d11);
        double d18 = (d17 + 1.0) * 500.0;
        if (dArray.length != 2) {
            System.err.println("Warning: 2nd arg to WCorrRMSEfitness method expected to have 2 double values (correlation weight and RMSE weight) but has " + dArray.length);
        }
        double d19 = dArray[0];
        double d20 = dArray[1];
        d = (d20 * d16 + d19 * d18) / (d20 + d19);
        return d;
    }

    public static double WCorrRMSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double parsimonyFitness(GEPIndividual gEPIndividual, double d) {
        return GEPFitnessFunction.parsimonyFitness(gEPIndividual, d, PARSIMONY_PRESSURE_FACTOR);
    }

    public static double parsimonyFitness(GEPIndividual gEPIndividual, double d, double d2) {
        GEPSpecies gEPSpecies = (GEPSpecies)gEPIndividual.species;
        int n = gEPSpecies.numberOfGenes;
        int n2 = gEPSpecies.geneSize;
        int n3 = n * n2;
        int n4 = (int)gEPIndividual.size();
        return d * (1.0 + (double)(n3 - n4) / ((double)(n3 - n) * d2));
    }

    public static int[] getConfusionMatrixValues(boolean bl, GEPIndividual gEPIndividual) {
        return GEPFitnessFunction.getConfusionMatrixValues(bl, gEPIndividual, 0);
    }

    public static int[] getConfusionMatrixValues(boolean bl, GEPIndividual gEPIndividual, int n) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues(n);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = dArray.length;
        int n7 = 0;
        while (n7 < n6) {
            double d = gEPIndividual.eval(n, bl, n7);
            if (Double.isNaN(d)) {
                return new int[4];
            }
            double d2 = dArray[n7];
            if (d == 1.0) {
                if (d2 == 1.0) {
                    ++n2;
                } else {
                    ++n4;
                }
            } else if (d2 == 0.0) {
                ++n3;
            } else {
                ++n5;
            }
            ++n7;
        }
        int[] nArray = new int[]{n2, n5, n4, n3};
        return nArray;
    }

    public static int[][] MCSCE1contingencyTable(boolean bl, GEPIndividual gEPIndividual, double d, double d2) {
        int n;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        double[] dArray = gEPDependentVariable.getDependentVariableValues();
        int n2 = dArray.length;
        int n3 = ((GEPSpecies)gEPIndividual.species).numberOfChromosomes;
        int[][] nArray = new int[n3][n3 + 1];
        double[][] dArray2 = new double[n2][n3];
        if (d < d2) {
            System.err.println("Error: MCSCE1 -- first threshold value must be less than the second.");
        }
        int n4 = 0;
        while (n4 < n3) {
            double[] dArray3 = gEPDependentVariable.getDependentVariableValues(n4);
            n = 0;
            while (n < n2) {
                dArray2[n][n4] = dArray3[n];
                ++n;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            int n5;
            double d3;
            n = 0;
            int n6 = 0;
            double d4 = d3 = gEPIndividual.eval(n6, bl, n4);
            double d5 = dArray2[n4][n];
            if (Double.isNaN(d3)) {
                n5 = 0;
                while (n5 < n3) {
                    nArray[n5][n5] = 0;
                    ++n5;
                }
                return nArray;
            }
            n5 = 1;
            while (n5 < n3) {
                double d6 = dArray2[n4][n5];
                if (d6 > d5) {
                    d5 = d6;
                    n = n5;
                }
                if (Double.isNaN(d6 = gEPIndividual.eval(n5, bl, n4))) {
                    int n7 = 0;
                    while (n7 < n3) {
                        nArray[n7][n7] = 0;
                        ++n7;
                    }
                    return nArray;
                }
                if (d6 > d3) {
                    d4 = d3;
                    int n8 = n6;
                    d3 = d6;
                    n6 = n5;
                }
                ++n5;
            }
            if (d3 >= d && d4 <= d2 && d3 != d4) {
                int[] nArray2 = nArray[n];
                int n9 = n6;
                nArray2[n9] = nArray2[n9] + 1;
            } else {
                int[] nArray3 = nArray[n];
                int n10 = n3;
                nArray3[n10] = nArray3[n10] + 1;
            }
            ++n4;
        }
        return nArray;
    }

    public static double MCSCE1rawFitness(boolean bl, GEPIndividual gEPIndividual, double d, double d2) {
        int[][] nArray = GEPFitnessFunction.MCSCE1contingencyTable(bl, gEPIndividual, d, d2);
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        int n = gEPDependentVariable.getDependentVariableValues().length;
        int n2 = ((GEPSpecies)gEPIndividual.species).numberOfChromosomes;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += nArray[n4][n4];
            ++n4;
        }
        double d3 = (double)(n - n3) / (double)n;
        return d3;
    }

    public static double MCSCE1fitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        double d = dArray[0];
        double d2 = dArray.length < 2 ? d : dArray[1];
        double d3 = GEPFitnessFunction.MCSCE1rawFitness(bl, gEPIndividual, d, d2);
        return 1000.0 * (1.0 - d3);
    }

    public static double MCSCE1maxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static int[][] MCSCE2contingencyTable(boolean bl, GEPIndividual gEPIndividual, double d) {
        int n;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        int n2 = gEPDependentVariable.getDependentVariableValues().length;
        int n3 = ((GEPSpecies)gEPIndividual.species).numberOfChromosomes;
        int n4 = n3 + 1;
        int[][] nArray = new int[n3][n4];
        double[][] dArray = new double[n2][n3];
        int n5 = 0;
        while (n5 < n3) {
            double[] dArray2 = gEPDependentVariable.getDependentVariableValues(n5);
            n = 0;
            while (n < n2) {
                dArray[n][n5] = dArray2[n];
                ++n;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n2) {
            int n6;
            n = 0;
            int n7 = 0;
            double d2 = gEPIndividual.eval(n7, bl, n5);
            double d3 = dArray[n5][n];
            if (Double.isNaN(d2)) {
                n6 = 0;
                while (n6 < n3) {
                    nArray[n6][n6] = 0;
                    ++n6;
                }
                return nArray;
            }
            n6 = 1;
            while (n6 < n3) {
                double d4 = dArray[n5][n6];
                if (d4 > d3) {
                    d3 = d4;
                    n = n6;
                }
                if (Double.isNaN(d4 = gEPIndividual.eval(n6, bl, n5))) {
                    int n8 = 0;
                    while (n8 < n3) {
                        nArray[n8][n8] = 0;
                        ++n8;
                    }
                    return nArray;
                }
                if (d4 > d2 + d) {
                    d2 = d4;
                    n7 = n6;
                } else {
                    if (d4 >= d2 - d) {
                        n7 = n3;
                    }
                    if (d4 > d2) {
                        d2 = d4;
                    }
                }
                ++n6;
            }
            int[] nArray2 = nArray[n];
            int n9 = n7;
            nArray2[n9] = nArray2[n9] + 1;
            ++n5;
        }
        return nArray;
    }

    public static double MCSCE2rawFitness(boolean bl, GEPIndividual gEPIndividual, double d) {
        int[][] nArray = GEPFitnessFunction.MCSCE2contingencyTable(bl, gEPIndividual, d);
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        int n = gEPDependentVariable.getDependentVariableValues().length;
        int n2 = ((GEPSpecies)gEPIndividual.species).numberOfChromosomes;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += nArray[n4][n4];
            ++n4;
        }
        double d2 = (double)(n - n3) / (double)n;
        return d2;
    }

    public static double MCSCE2fitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        double d = dArray[0];
        double d2 = GEPFitnessFunction.MCSCE2rawFitness(bl, gEPIndividual, d);
        return 1000.0 * (1.0 - d2);
    }

    public static double MCSCE2maxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static int[][] MCSCE3contingencyTable(boolean bl, GEPIndividual gEPIndividual, double d, double d2) {
        double d3;
        int n;
        double d4;
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        int n2 = gEPDependentVariable.getDependentVariableValues().length;
        int n3 = ((GEPSpecies)gEPIndividual.species).numberOfChromosomes;
        int[][] nArray = new int[n3][n3 + 1];
        double[][] dArray = new double[n2][n3];
        double[][] dArray2 = new double[n2][n3];
        if (d2 > 1.0 || d2 < 0.0 || d > 1.0 || d < 0.0 || d < d2) {
            System.err.println("Error: MCSCE3 -- threshold values must be between 0.0 and 1.0 and first must be less than the second.");
        }
        double d5 = d4 = gEPIndividual.eval(0, bl, 0);
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                dArray2[n4][n] = d3 = gEPIndividual.eval(n, bl, n4);
                if (Double.isNaN(d3)) {
                    int n5 = 0;
                    while (n5 < n3) {
                        nArray[n5][n5] = 0;
                        ++n5;
                    }
                    return nArray;
                }
                if (d3 < d5) {
                    d5 = d3;
                }
                if (d3 > d4) {
                    d4 = d3;
                }
                ++n;
            }
            ++n4;
        }
        double d6 = d4 - d5;
        n4 = 0;
        while (n4 < n3) {
            double[] dArray3 = gEPDependentVariable.getDependentVariableValues(n4);
            n = 0;
            while (n < n2) {
                dArray[n][n4] = dArray3[n];
                ++n;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            int n6;
            double d7;
            n = 0;
            int n7 = 0;
            double d8 = d7 = dArray2[n4][n7];
            double d9 = dArray[n4][n];
            if (Double.isNaN(d7)) {
                n6 = 0;
                while (n6 < n3) {
                    nArray[n6][n6] = 0;
                    ++n6;
                }
                return nArray;
            }
            n6 = 1;
            while (n6 < n3) {
                d3 = dArray[n4][n6];
                if (d3 > d9) {
                    d9 = d3;
                    n = n6;
                }
                if ((d3 = dArray2[n4][n6]) > d7) {
                    d8 = d7;
                    int n8 = n7;
                    d7 = d3;
                    n7 = n6;
                }
                ++n6;
            }
            d7 = (d7 - d5) / d6;
            d8 = (d8 - d5) / d6;
            if (d7 >= d && d8 <= d2 && d7 != d8) {
                int[] nArray2 = nArray[n];
                int n9 = n7;
                nArray2[n9] = nArray2[n9] + 1;
            } else {
                int[] nArray3 = nArray[n];
                int n10 = n3;
                nArray3[n10] = nArray3[n10] + 1;
            }
            ++n4;
        }
        return nArray;
    }

    public static double MCSCE3rawFitness(boolean bl, GEPIndividual gEPIndividual, double d, double d2) {
        int[][] nArray = GEPFitnessFunction.MCSCE3contingencyTable(bl, gEPIndividual, d, d2);
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        int n = gEPDependentVariable.getDependentVariableValues().length;
        int n2 = ((GEPSpecies)gEPIndividual.species).numberOfChromosomes;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += nArray[n4][n4];
            ++n4;
        }
        double d3 = (double)(n - n3) / (double)n;
        return d3;
    }

    public static double MCSCE3fitness(boolean bl, GEPIndividual gEPIndividual, double[] dArray) {
        double d = dArray[0];
        double d2 = dArray.length < 2 ? d : dArray[1];
        double d3 = GEPFitnessFunction.MCSCE3rawFitness(bl, gEPIndividual, d, d2);
        return 1000.0 * (1.0 - d3);
    }

    public static double MCSCE3maxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    public static double MCMSEfitness(boolean bl, GEPIndividual gEPIndividual) {
        double d = 0.0;
        int n = ((GEPSpecies)gEPIndividual.species).numberOfChromosomes;
        int n2 = 0;
        while (n2 < n) {
            d += GEPFitnessFunction.MSErawFitness(bl, gEPIndividual, n2);
            ++n2;
        }
        return 1000.0 / (1.0 + (d /= (double)n));
    }

    public static double MCMSEmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }

    private static double get_sim_disim_value_from_simDisimMatrix(double[][] dArray, int n, int n2) {
        if (n < n2) {
            return dArray[n2][n];
        }
        if (n > n2) {
            return dArray[n][n2];
        }
        return dArray[0][0];
    }

    private static void euclidean_distanceW(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, int n2, double[] dArray5) {
        int n3 = dArray.length;
        int n4 = dArray2.length;
        if (dArray5 == null) {
            throw new IllegalArgumentException("euclidean_distanceW(): returnValues = null (but should be allocated)");
        }
        if (dArray5.length != 3) {
            throw new IllegalArgumentException("euclidean_distanceW(): returnValues.length() = " + dArray5.length + "  (but should be 3)");
        }
        dArray5[GEPFitnessFunction.WEIGHTED_EUCLIDEAN_DISTANCE_INDEX] = 0.0;
        dArray5[GEPFitnessFunction.NUMBER_OF_COMMON_VARIABLES_INDEX] = 0.0;
        dArray5[GEPFitnessFunction.NORMALIZED_WEIGHTED_EUCLIDEAN_DISTANCE_INDEX] = 0.0;
        if (n3 != n4) {
            throw new IllegalArgumentException("euclidean_distanceW(): numVarsX = " + n3 + "  numVarsY = " + n4);
        }
        if (dArray4 != null) {
            int n5 = 0;
            while (n5 < n3) {
                if (dArray[n5] != dArray4[0] && dArray2[n5] != dArray4[0]) {
                    int n6 = WEIGHTED_EUCLIDEAN_DISTANCE_INDEX;
                    dArray5[n6] = dArray5[n6] + dArray3[n5] * (dArray[n5] - dArray2[n5]) * (dArray[n5] - dArray2[n5]);
                    int n7 = NUMBER_OF_COMMON_VARIABLES_INDEX;
                    dArray5[n7] = dArray5[n7] + 1.0;
                }
                ++n5;
            }
        } else {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = WEIGHTED_EUCLIDEAN_DISTANCE_INDEX;
                dArray5[n9] = dArray5[n9] + dArray3[n8] * (dArray[n8] - dArray2[n8]) * (dArray[n8] - dArray2[n8]);
                ++n8;
            }
        }
        dArray5[GEPFitnessFunction.NUMBER_OF_COMMON_VARIABLES_INDEX] = n3;
        if (dArray5[NUMBER_OF_COMMON_VARIABLES_INDEX] <= 0.0) {
            return;
        }
        if (n == 1) {
            int n10 = WEIGHTED_EUCLIDEAN_DISTANCE_INDEX;
            dArray5[n10] = dArray5[n10] / dArray5[NUMBER_OF_COMMON_VARIABLES_INDEX];
            if (n2 == 1) {
                int n11 = WEIGHTED_EUCLIDEAN_DISTANCE_INDEX;
                dArray5[n11] = dArray5[n11] * (double)n3;
            }
        } else if (n2 == 1) {
            dArray5[GEPFitnessFunction.WEIGHTED_EUCLIDEAN_DISTANCE_INDEX] = dArray5[WEIGHTED_EUCLIDEAN_DISTANCE_INDEX] / dArray5[NUMBER_OF_COMMON_VARIABLES_INDEX] * (double)n3;
        }
        dArray5[GEPFitnessFunction.WEIGHTED_EUCLIDEAN_DISTANCE_INDEX] = Math.sqrt(dArray5[WEIGHTED_EUCLIDEAN_DISTANCE_INDEX]);
    }

    private static double sammon_error(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        double d = -1.0;
        int n = dArray.length;
        double[] dArray4 = new double[dArray[0].length];
        int n2 = 0;
        while (n2 < dArray[0].length) {
            dArray4[n2] = 1.0;
            ++n2;
        }
        if (originalDisimMatrix.length != n) {
            throw new IllegalArgumentException("number of rows in originalDisimMatrix and dataMatrixInTheNewSpace should be the same.");
        }
        double d2 = 0.0;
        n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2 + 1;
            while (n3 < n) {
                GEPFitnessFunction.euclidean_distanceW(dArray[n2], dArray[n3], dArray4, dArray2, 0, 0, dArray3);
                double d3 = GEPFitnessFunction.get_sim_disim_value_from_simDisimMatrix(originalDisimMatrix, n2, n3);
                if (d3 < ZERO) {
                    d3 = ZERO;
                }
                if ((dArray2 == null || d3 != dArray2[0]) && dArray3[NUMBER_OF_COMMON_VARIABLES_INDEX] > 0.0) {
                    double d4 = dArray3[WEIGHTED_EUCLIDEAN_DISTANCE_INDEX];
                    double d5 = d3 - d4;
                    d2 += d5 * d5 / d3;
                }
                ++n3;
            }
            ++n2;
        }
        d = d2 / sumOfTheLowerTriangle;
        return d;
    }

    public static double SEWDfitness(boolean bl, GEPIndividual gEPIndividual) {
        GEPDependentVariable gEPDependentVariable = bl ? GEPDependentVariable.trainingData : GEPDependentVariable.testingData;
        int n = gEPDependentVariable.getDependentVariableValues().length;
        int n2 = ((GEPSpecies)gEPIndividual.species).numberOfChromosomes;
        double[][] dArray = new double[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4] = gEPIndividual.eval(n4, bl, n3);
                ++n4;
            }
            ++n3;
        }
        double[] dArray2 = new double[]{-999.0};
        double d = GEPFitnessFunction.sammon_error(dArray, dArray2);
        return 1000.0 / (1.0 + d);
    }

    public static double SEWDmaxFitness(GEPIndividual gEPIndividual) {
        return 1000.0;
    }
}

