/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.EvolutionState;
import ec.Individual;
import ec.gep.GEPChromosome;
import ec.gep.GEPDefaults;
import ec.gep.GEPSpecies;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import jscl.math.Expression;

public class GEPIndividual
extends Individual {
    public static final String P_INDIVIDUAL = "individual";
    public static final int CHECK_BOUNDARY = 8;
    public static final String P_SIMPLIFY_EXPRESSIONS = "simplify-expressions";
    public GEPChromosome[] chromosomes = null;
    public boolean chromosomesParsed = false;
    static boolean simplifyExpressions = true;
    private static double threshold = 0.5;
    private static boolean thresholdON = false;

    public static void setThreshold(double d) {
        threshold = d;
        thresholdON = true;
    }

    public static double getThreshold() {
        return threshold;
    }

    public static void setThresholdOFF() {
        thresholdON = false;
    }

    public static void setThresholdON() {
        thresholdON = true;
    }

    public static boolean isThresholdON() {
        return thresholdON;
    }

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_INDIVIDUAL);
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        GEPIndividual gEPIndividual = (GEPIndividual)object;
        if (this.chromosomes == null && gEPIndividual.chromosomes != null) {
            return false;
        }
        if (gEPIndividual.chromosomes == null && this.chromosomes != null) {
            return false;
        }
        if (this.chromosomes == null && gEPIndividual.chromosomes == null) {
            return true;
        }
        if (this.chromosomes.length != gEPIndividual.chromosomes.length) {
            return false;
        }
        int n = 0;
        while (n < this.chromosomes.length) {
            if (!this.chromosomes[n].equals(gEPIndividual.chromosomes[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        n = n << 1 | n >>> 31;
        int n2 = 0;
        while (n2 < this.chromosomes.length) {
            n = (n << 1 | n >>> 31) ^ this.chromosomes[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = this.defaultBase();
        this.evaluated = false;
        this.chromosomesParsed = false;
        if (!(this.species instanceof GEPSpecies)) {
            evolutionState.output.fatal("GEPIndividual must be associated with a GEPSpecies", parameter, parameter2);
        }
        GEPSpecies gEPSpecies = (GEPSpecies)this.species;
        simplifyExpressions = evolutionState.parameters.getBoolean(parameter.push(P_SIMPLIFY_EXPRESSIONS), parameter.push(P_SIMPLIFY_EXPRESSIONS), true);
        this.chromosomes = new GEPChromosome[gEPSpecies.numberOfChromosomes];
        int n = 0;
        while (n < gEPSpecies.numberOfChromosomes) {
            this.chromosomes[n] = new GEPChromosome();
            this.chromosomes[n].setup(evolutionState, parameter, gEPSpecies);
            ++n;
        }
    }

    public void reset(EvolutionState evolutionState, int n) {
        int n2 = 0;
        while (n2 < this.chromosomes.length) {
            this.chromosomes[n2].reset(evolutionState, n);
            ++n2;
        }
        this.evaluated = false;
        this.chromosomesParsed = false;
    }

    public String genotypeToStringForHumans() {
        String string = "Linking function: " + ((GEPSpecies)this.species).linkingFunctionName + "\n";
        string = String.valueOf(string) + "\nGEP-MODEL\n";
        string = String.valueOf(string) + "KARVA\n" + this.genotypeToStringForHumansKarva();
        String string2 = this.genotypeToStringForHumansMathExpression();
        string = String.valueOf(string) + "MATH\n" + string2;
        if (simplifyExpressions) {
            String string3 = this.genotypeToStringForHumansMathSimplifiedExpression();
            string = String.valueOf(string) + "\nMATH (SIMPLIFIED)\n" + string3;
        }
        string = String.valueOf(string) + "\n";
        return string;
    }

    public String genotypeToStringForHumansKarva() {
        try {
            int n = this.chromosomes.length;
            String string = "";
            if (n > 1) {
                string = "Number of chromosomes: " + n + "\n\n";
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2 + 1;
                if (n > 1) {
                    string = String.valueOf(string) + "Chromosome " + n3 + ":\n";
                }
                string = String.valueOf(string) + this.chromosomes[n2].genotypeToStringForHumansKarva() + "\n";
                ++n2;
            }
            return string;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return "";
        }
    }

    public String genotypeToStringForHumansMathExpression() {
        int n = this.chromosomes.length;
        String string = "";
        if (n > 1) {
            string = "Number of chromosomes: " + n + "\n\n";
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            if (n > 1) {
                string = String.valueOf(string) + "Chromosome " + n3 + ":\n";
            }
            string = String.valueOf(string) + this.chromosomes[n2].genotypeToStringForHumansMathExpression() + "\n";
            ++n2;
        }
        return string;
    }

    public String genotypeToStringForHumansMathSimplifiedExpression() {
        int n = this.chromosomes.length;
        String string = "";
        String string2 = "";
        if (n > 1) {
            string = "Number of chromosomes: " + n + "\n\n";
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            if (n > 1) {
                string = String.valueOf(string) + "Chromosome " + n3 + ":\n";
            }
            try {
                if (simplifyExpressions) {
                    string2 = Expression.valueOf((String)this.chromosomes[n2].genotypeToStringForHumansMathExpression()).simplify().toString();
                }
            }
            catch (Exception exception) {
                string = String.valueOf(string) + "\nMATH (SIMPLIFIED)\nUnable to simplify the math expression ... jscl.meditor simplify failed";
            }
            string = String.valueOf(string) + string2 + "\n";
            ++n2;
        }
        return string;
    }

    public String genotypeToString() {
        int n = this.chromosomes.length;
        String string = Code.encode(n);
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + this.chromosomes[n2].genotypeToString();
            ++n2;
        }
        return string;
    }

    protected void parseGenotype(EvolutionState evolutionState, LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        DecodeReturn decodeReturn = new DecodeReturn(string);
        Code.decode(decodeReturn);
        int n = (int)decodeReturn.l;
        this.chromosomes = new GEPChromosome[n];
        int n2 = 0;
        while (n2 < n) {
            this.chromosomes[n2] = new GEPChromosome();
            this.chromosomes[n2].parseGenotype(evolutionState, lineNumberReader);
            ++n2;
        }
        this.chromosomesParsed = false;
        this.evaluated = false;
    }

    public void writeGenotype(EvolutionState evolutionState, DataOutput dataOutput) throws IOException {
        int n = this.chromosomes.length;
        dataOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.chromosomes[n2].writeGenotype(evolutionState, dataOutput);
            ++n2;
        }
    }

    public void readGenotype(EvolutionState evolutionState, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.chromosomes[n2].readGenotype(evolutionState, dataInput);
            ++n2;
        }
    }

    public Object clone() {
        GEPIndividual gEPIndividual = (GEPIndividual)super.clone();
        gEPIndividual.chromosomes = new GEPChromosome[this.chromosomes.length];
        int n = 0;
        while (n < this.chromosomes.length) {
            gEPIndividual.chromosomes[n] = (GEPChromosome)this.chromosomes[n].clone();
            gEPIndividual.chromosomes[n].myGEPIndividual = gEPIndividual;
            ++n;
        }
        gEPIndividual.chromosomesParsed = this.chromosomesParsed;
        return gEPIndividual;
    }

    public double eval(boolean bl, int n) {
        return this.chromosomes[0].eval(bl, n);
    }

    public double eval(int n, boolean bl, int n2) {
        return this.chromosomes[n].eval(bl, n2);
    }

    public long size() {
        long l = 0L;
        int n = 0;
        while (n < this.chromosomes.length) {
            l += this.chromosomes[n].size();
            ++n;
        }
        return l;
    }
}

