/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.gep.GEPChromosome;
import ec.gep.GEPDependentVariable;
import ec.gep.GEPFitnessFunction;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.gep.GEPSymbol;
import ec.gep.GEPSymbolSet;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparatorL;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jscl.math.Expression;
import jscl.text.ParseException;

public class GEPSimpleStatisticsMultipleChromosomes
extends Statistics
implements SteadyStateStatisticsForm {
    public static final String P_STATISTICS_FILE = "file";
    public static final String P_COMPUTED_VALUES_FILE = "file-computed-values";
    public static final String P_DETAIL_TO_LOG = "detail-to-log";
    public static final String P_NO_COMPUTED = "no-computed";
    public static final String P_NUMBER_OF_BEST_TO_LOG = "number-of-best-to-log";
    public static final String P_COMPRESS = "gzip";
    public int statisticslog = 0;
    public int computedlog;
    public boolean noComputedDisplay = false;
    public String detailToLog = "change";
    public int numberOfBestToLog = 1;
    public Individual[] best_of_run = null;
    public int[] best_of_run_generation = null;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        File file = evolutionState.parameters.getFile(parameter.push(P_STATISTICS_FILE), null);
        if (file != null) {
            try {
                this.statisticslog = evolutionState.output.addLog(file, 2999, false, !evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false), evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred while trying to create the log " + file + ":\n" + iOException);
            }
        }
        this.noComputedDisplay = evolutionState.parameters.getBoolean(parameter.push(P_NO_COMPUTED), parameter.push(P_NO_COMPUTED), false);
        File file2 = evolutionState.parameters.getFile(parameter.push(P_COMPUTED_VALUES_FILE), null);
        if (file2 != null) {
            try {
                this.computedlog = evolutionState.output.addLog(file2, 2999, false, !evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false), evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred while trying to create the log " + file2 + ":\n" + iOException);
            }
        } else {
            this.computedlog = this.statisticslog;
        }
        this.detailToLog = evolutionState.parameters.getStringWithDefault(parameter.push(P_DETAIL_TO_LOG), null, "change");
        if (!(this.detailToLog.equals("change") || this.detailToLog.equals("final") || this.detailToLog.equals("all"))) {
            evolutionState.output.warning("Expecting detail-to-log to be one of 'change', 'final' or 'all' not '" + this.detailToLog + "'. Setting to 'change'.");
            this.detailToLog = "change";
        }
        this.numberOfBestToLog = evolutionState.parameters.getIntWithDefault(parameter.push(P_NUMBER_OF_BEST_TO_LOG), parameter.push(P_NUMBER_OF_BEST_TO_LOG), 1);
        if (this.numberOfBestToLog < 1) {
            this.numberOfBestToLog = 1;
        }
    }

    public void postInitializationStatistics(EvolutionState evolutionState) {
        super.postInitializationStatistics(evolutionState);
        this.best_of_run = new Individual[evolutionState.population.subpops.length];
        this.best_of_run_generation = new int[evolutionState.population.subpops.length];
        GEPSpecies gEPSpecies = (GEPSpecies)evolutionState.population.subpops[0].species;
        int[] nArray = evolutionState.seeds;
        String string = String.valueOf(nArray[0]);
        int n = 1;
        while (n < nArray.length) {
            string = String.valueOf(string) + ", " + String.valueOf(nArray[n]);
            ++n;
        }
        evolutionState.output.println("GENERAL PARAMETERS", 3000, this.statisticslog);
        String string2 = "";
        String[] stringArray = evolutionState.runtimeArguments;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                string2 = String.valueOf(stringArray[n2]) + " ";
                ++n2;
            }
        }
        evolutionState.output.println("Arguments used in this run: " + string2, 3000, this.statisticslog);
        evolutionState.output.println("Maximum number of generations in this run: " + evolutionState.numGenerations, 3000, this.statisticslog);
        evolutionState.output.println("Size of population in this run: " + evolutionState.population.subpops[0].individuals.length, 3000, this.statisticslog);
        evolutionState.output.println("Number of Chromosomes per individual: " + gEPSpecies.numberOfChromosomes, 3000, this.statisticslog);
        evolutionState.output.println("Number of genes per chromosome: " + gEPSpecies.numberOfGenes, 3000, this.statisticslog);
        evolutionState.output.println("Size of gene head: " + gEPSpecies.headSize, 3000, this.statisticslog);
        evolutionState.output.println("Seed(s) used in this job: " + string, 3000, this.statisticslog);
        evolutionState.output.println("Problem type: " + gEPSpecies.problemTypeName, 3000, this.statisticslog);
        if (gEPSpecies.problemType == 1) {
            evolutionState.output.println("Classification rounding threshold: " + GEPIndividual.getThreshold(), 3000, this.statisticslog);
        }
        Parameter parameter = new Parameter("eval.problem.fitness-function");
        String string3 = evolutionState.parameters.getStringWithDefault(parameter, parameter, "SPECIFIED IN USER PROGRAM");
        evolutionState.output.println("Fitness function: " + string3, 3000, this.statisticslog);
        if (!string3.equals("SPECIFIED IN USER PROGRAM")) {
            double d;
            parameter = new Parameter("eval.problem.fitness-function-arg0");
            if (evolutionState.parameters.exists(parameter)) {
                d = evolutionState.parameters.getDoubleWithDefault(parameter, parameter, 0.0);
                evolutionState.output.println("Fitness function param 1: " + d, 3000, this.statisticslog);
            }
            if (evolutionState.parameters.exists(parameter = new Parameter("eval.problem.fitness-function-arg1"))) {
                d = evolutionState.parameters.getDoubleWithDefault(parameter, parameter, 0.0);
                evolutionState.output.println("Fitness function param 2: " + d, 3000, this.statisticslog);
            }
        }
        evolutionState.output.println("", 3000, this.statisticslog);
    }

    public void postEvaluationStatistics(EvolutionState evolutionState) {
        super.postEvaluationStatistics(evolutionState);
        Individual[] individualArray = new Individual[evolutionState.population.subpops.length];
        int n = 0;
        while (n < evolutionState.population.subpops.length) {
            individualArray[n] = evolutionState.population.subpops[n].individuals[0];
            int n2 = 1;
            while (n2 < evolutionState.population.subpops[n].individuals.length) {
                if (evolutionState.population.subpops[n].individuals[n2].fitness.betterThan(individualArray[n].fitness)) {
                    individualArray[n] = evolutionState.population.subpops[n].individuals[n2];
                }
                ++n2;
            }
            n2 = 0;
            if (this.best_of_run[n] == null || individualArray[n].fitness.betterThan(this.best_of_run[n].fitness)) {
                this.best_of_run[n] = (Individual)individualArray[n].clone();
                this.best_of_run_generation[n] = evolutionState.generation;
                n2 = 1;
            }
            if (this.detailToLog.equals("all") || this.detailToLog.equals("change") && n2 != 0) {
                evolutionState.output.println("BEST INDIVIDUAL OF GENERATION", 3000, this.statisticslog);
                evolutionState.output.println("Generation: " + evolutionState.generation, 3000, this.statisticslog);
                individualArray[n].printIndividualForHumans(evolutionState, this.statisticslog, 3000);
            }
            ++n;
        }
    }

    public void finalStatistics(EvolutionState evolutionState, int n) {
        super.finalStatistics(evolutionState, n);
        int n2 = 0;
        while (n2 < evolutionState.population.subpops.length) {
            int n3;
            Individual[] individualArray;
            int n4 = evolutionState.population.subpops[n2].individuals.length;
            if (this.numberOfBestToLog > n4) {
                this.numberOfBestToLog = n4;
            }
            GEPIndividual[] gEPIndividualArray = new GEPIndividual[this.numberOfBestToLog];
            if (this.numberOfBestToLog == 1) {
                gEPIndividualArray[0] = (GEPIndividual)this.best_of_run[n2];
            } else {
                int[] nArray = new int[n4];
                int n5 = 0;
                while (n5 < n4) {
                    nArray[n5] = n5;
                    ++n5;
                }
                QuickSort.qsort(nArray, (SortComparatorL)new BestGEPIndividualComparator(evolutionState.population.subpops[n2].individuals));
                individualArray = evolutionState.population.subpops[n2].individuals;
                n3 = 0;
                while (n3 < this.numberOfBestToLog) {
                    gEPIndividualArray[n3] = (GEPIndividual)individualArray[nArray[n4 - 1 - n3]];
                    ++n3;
                }
            }
            int n6 = 0;
            while (n6 < gEPIndividualArray.length) {
                int n7;
                Object object;
                int n8;
                individualArray = gEPIndividualArray[n6];
                if (n6 == 0) {
                    evolutionState.output.println("\nBEST INDIVIDUAL 1", 3000, this.statisticslog);
                    evolutionState.output.println("Found at Generation: " + this.best_of_run_generation[n2], 3000, this.statisticslog);
                } else {
                    evolutionState.output.println("\n\nBEST INDIVIDUAL " + (n6 + 1), 3000, this.statisticslog);
                }
                evolutionState.output.println("Raw Fitness: " + (1000.0 / (double)individualArray.fitness.fitness() - 1.0), 3000, this.statisticslog);
                individualArray.printIndividualForHumans(evolutionState, this.statisticslog, 3000);
                n3 = individualArray.chromosomes.length;
                evolutionState.output.println("MODEL COMPOSITION", 3000, this.statisticslog);
                int n9 = 0;
                while (n9 < n3) {
                    Object object2;
                    Object object3;
                    n8 = n9 + 1;
                    if (n9 > 0) {
                        evolutionState.output.println("", 3000, this.statisticslog);
                    }
                    if (n3 > 1) {
                        evolutionState.output.println("Chromosome " + n8 + ":", 3000, this.statisticslog);
                    }
                    object = individualArray.chromosomes[n9];
                    evolutionState.output.println("Size of program: " + ((GEPChromosome)object).size(), 3000, this.statisticslog);
                    int[] nArray = ((GEPChromosome)object).variableUseageCounts();
                    n7 = 0;
                    int n10 = 0;
                    while (n10 < nArray.length) {
                        if (nArray[n10] > 0) {
                            ++n7;
                        }
                        ++n10;
                    }
                    evolutionState.output.print("Variables used(variable count) " + n7 + ": ", 3000, this.statisticslog);
                    GEPSymbolSet gEPSymbolSet = ((GEPSpecies)evolutionState.population.subpops[n2].species).symbolSet;
                    boolean bl = true;
                    int n11 = 0;
                    while (n11 < nArray.length) {
                        if (nArray[n11] > 0) {
                            if (!bl) {
                                evolutionState.output.print(", ", 3000, this.statisticslog);
                            }
                            object3 = gEPSymbolSet.symbols[gEPSymbolSet.terminals[n11]].symbol;
                            evolutionState.output.print(String.valueOf(object3) + " " + nArray[n11], 3000, this.statisticslog);
                            bl = false;
                        }
                        ++n11;
                    }
                    HashMap hashMap = ((GEPChromosome)object).functionUseageCounts();
                    object3 = hashMap.entrySet();
                    evolutionState.output.print("\nFunctions used(function count) " + object3.size() + ": ", 3000, this.statisticslog);
                    bl = true;
                    Object object4 = object3.iterator();
                    while (object4.hasNext()) {
                        if (!bl) {
                            evolutionState.output.print(", ", 3000, this.statisticslog);
                        }
                        bl = false;
                        object2 = (Map.Entry)object4.next();
                        String string = (String)object2.getKey();
                        String string2 = ((Integer)object2.getValue()).toString();
                        evolutionState.output.print(String.valueOf(string) + " " + string2, 3000, this.statisticslog);
                    }
                    if (GEPIndividual.simplifyExpressions) {
                        object4 = ((GEPChromosome)object).genotypeToStringForHumansMathExpression();
                        object2 = "";
                        try {
                            object2 = Expression.valueOf((String)object4).simplify().toString();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        this.displaySimplifiedMathExpressionVariableFunctionCounts(evolutionState, gEPSymbolSet, "MATH", (String)object2);
                    }
                    ++n9;
                }
                GEPSpecies gEPSpecies = (GEPSpecies)evolutionState.population.subpops[0].species;
                evolutionState.output.println("\n\nMODEL QUALITY MEASURES (TRAINING)", 3000, this.statisticslog);
                this.displayStatistics(evolutionState, gEPSpecies, (GEPIndividual)individualArray, true);
                if (GEPDependentVariable.testingData.getDependentVariableValues(0) != null) {
                    n8 = 0;
                    while (n8 < gEPSpecies.numberOfChromosomes) {
                        object = GEPDependentVariable.testingData.getDependentVariableValues(n8);
                        int n12 = 0;
                        if (object != null) {
                            evolutionState.output.println("\nMODEL QUALITY MEASURES (TEST)", 3000, this.statisticslog);
                            n7 = 0;
                            while (n7 < ((Object)object).length) {
                                double d = individualArray.eval(n8, false, n7);
                                if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Double.isNaN(d)) {
                                    ++n12;
                                }
                                ++n7;
                            }
                        }
                        evolutionState.output.println("Number of Calculation Errors: " + n12 + " out of " + ((Object)object).length + " test sets", 3000, this.statisticslog);
                        ++n8;
                    }
                    this.displayStatistics(evolutionState, gEPSpecies, (GEPIndividual)individualArray, false);
                }
                if (!this.noComputedDisplay) {
                    if (this.computedlog != this.statisticslog && this.numberOfBestToLog > 1) {
                        evolutionState.output.println("# Best Result " + (n6 + 1), 3000, this.computedlog);
                    }
                    double[] dArray = GEPDependentVariable.trainingData.getDependentVariableValues(0);
                    int n13 = 0;
                    while (n13 < dArray.length) {
                        int n14 = 0;
                        while (n14 < n3) {
                            double d = individualArray.eval(n14, true, n13);
                            evolutionState.output.print(Double.toString(d), 3000, this.computedlog);
                            if (n14 == n3 - 1) {
                                evolutionState.output.println("", 3000, this.computedlog);
                            } else {
                                evolutionState.output.print(", ", 3000, this.computedlog);
                            }
                            ++n14;
                        }
                        ++n13;
                    }
                }
                ++n6;
            }
            ++n2;
        }
    }

    void displayStatistics(EvolutionState evolutionState, GEPSpecies gEPSpecies, GEPIndividual gEPIndividual, boolean bl) {
        Parameter parameter = new Parameter("eval.problem.fitness-function");
        String string = evolutionState.parameters.getStringWithDefault(parameter, parameter, "SPECIFIED IN USER PROGRAM");
        if (gEPSpecies.problemType == 1 || gEPSpecies.problemType == 2) {
            evolutionState.output.println("Confusion Matrix: ", 3000, this.statisticslog);
            evolutionState.output.println("                Predicted Value\n               |  Yes  |  No   \n               |----------------", 3000, this.statisticslog);
            int[] nArray = GEPFitnessFunction.getConfusionMatrixValues(bl, gEPIndividual, 0);
            evolutionState.output.println("           Yes |" + String.format("%1$6d", nArray[0]) + " |" + String.format("%1$6d", nArray[1]), 3000, this.statisticslog);
            evolutionState.output.println("Actual Value   |----------------", 3000, this.statisticslog);
            evolutionState.output.println("           No  |" + String.format("%1$6d", nArray[2]) + " |" + String.format("%1$6d", nArray[3]), 3000, this.statisticslog);
            evolutionState.output.println("               |----------------", 3000, this.statisticslog);
        } else if (gEPSpecies.problemType == 0 && string.length() >= 5 && string.substring(0, 5).equals("MCSCE")) {
            Method method;
            parameter = new Parameter("eval.problem.fitness-function-arg0");
            double d = evolutionState.parameters.getDoubleWithDefault(parameter, parameter, 0.0);
            parameter = new Parameter("eval.problem.fitness-function-arg1");
            double d2 = evolutionState.parameters.getDoubleWithDefault(parameter, parameter, d);
            String string2 = String.valueOf(string) + "contingencyTable";
            int[][] nArray = null;
            try {
                method = GEPFitnessFunction.class.getMethod(string2, GEPIndividual.class, Double.TYPE);
                nArray = (int[][])method.invoke(null, gEPIndividual, d);
            }
            catch (Exception exception) {
                try {
                    method = GEPFitnessFunction.class.getMethod(string2, GEPIndividual.class, Double.TYPE, Double.TYPE);
                    nArray = (int[][])method.invoke(null, gEPIndividual, d, d2);
                }
                catch (Exception exception2) {
                    evolutionState.output.fatal("GEPSimpleStatisticsMultipleChromosomes:No contingency table method '" + string2 + "' was NOT found or execution of the method failed.\n" + exception2);
                }
            }
            evolutionState.output.println("Confusion Matrix: ", 3000, this.statisticslog);
            evolutionState.output.println("              Predicted Value", 3000, this.statisticslog);
            evolutionState.output.print("          |", 3000, this.statisticslog);
            String string3 = "";
            int n = 0;
            while (n < 10 * (gEPSpecies.numberOfChromosomes + 1) - 1) {
                string3 = String.valueOf(string3) + "-";
                ++n;
            }
            n = 0;
            while (n < gEPSpecies.numberOfChromosomes) {
                evolutionState.output.print(" class " + n + " |", 3000, this.statisticslog);
                ++n;
            }
            evolutionState.output.println(" UNCLASS |", 3000, this.statisticslog);
            evolutionState.output.println("----------|" + string3 + "|", 3000, this.statisticslog);
            n = 0;
            while (n < gEPSpecies.numberOfChromosomes) {
                evolutionState.output.print(" class " + n + "  |", 3000, this.statisticslog);
                int n2 = 0;
                while (n2 <= gEPSpecies.numberOfChromosomes) {
                    evolutionState.output.print(String.valueOf(String.format("%1$7d", nArray[n][n2])) + "  |", 3000, this.statisticslog);
                    ++n2;
                }
                evolutionState.output.println("\n          |" + string3 + "|", 3000, this.statisticslog);
                ++n;
            }
        } else {
            int n = 0;
            while (n < gEPSpecies.numberOfChromosomes) {
                evolutionState.output.println("Statistics: ", 3000, this.statisticslog);
                evolutionState.output.println("MSE:  " + GEPFitnessFunction.MSErawFitness(bl, gEPIndividual, n) + "    \tRAE:  " + GEPFitnessFunction.RAErawFitness(bl, gEPIndividual, n) + "    \tRSE:  " + GEPFitnessFunction.RSErawFitness(bl, gEPIndividual, n), 3000, this.statisticslog);
                evolutionState.output.println("RMSE: " + GEPFitnessFunction.RMSErawFitness(bl, gEPIndividual, n) + "    \tMAE:  " + GEPFitnessFunction.MAErawFitness(bl, gEPIndividual, n) + "    \tRRSE: " + GEPFitnessFunction.RRSErawFitness(bl, gEPIndividual, n), 3000, this.statisticslog);
                evolutionState.output.println("Corr Coeff: " + GEPFitnessFunction.CCrawFitness(bl, gEPIndividual, n), 3000, this.statisticslog);
                ++n;
            }
        }
    }

    void displaySimplifiedMathExpressionVariableFunctionCounts(EvolutionState evolutionState, GEPSymbolSet gEPSymbolSet, String string, String string2) {
        String string3;
        String string4;
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        HashMap<Object, Integer> hashMap;
        int n = 0;
        int n2 = 0;
        Object object4 = "";
        if (string2.equals("")) {
            evolutionState.output.println("\n\nSize of program (" + string + " simplified): unknown ... expression simplification failed", 3000, this.statisticslog);
            return;
        }
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        object4 = string2;
        Object[] objectArray = new String[gEPSymbolSet.numberOfTerminals];
        int n3 = 0;
        while (n3 < gEPSymbolSet.numberOfTerminals) {
            hashMap = gEPSymbolSet.symbols[gEPSymbolSet.terminals[n3]];
            object3 = ((GEPSymbol)((Object)hashMap)).symbol;
            try {
                object3 = Expression.valueOf((String)object3).simplify().toString();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            objectArray[n3] = object3;
            ++n3;
        }
        Arrays.sort(objectArray);
        n3 = gEPSymbolSet.numberOfTerminals - 1;
        while (n3 >= 0) {
            hashMap = "\\Q" + (String)objectArray[n3] + "\\E";
            object3 = ((String)object4).replaceFirst((String)((Object)hashMap), "#");
            while (!object3.equals(object4)) {
                ++n;
                Integer n4 = (Integer)hashMap2.get(objectArray[n3]);
                if (n4 == null) {
                    hashMap2.put(objectArray[n3], new Integer(1));
                } else {
                    hashMap2.put(objectArray[n3], new Integer(n4 + 1));
                }
                object4 = object3;
                object3 = ((String)object4).replaceFirst((String)((Object)hashMap), "#");
            }
            --n3;
        }
        String[] stringArray = new String[]{"^", "**"};
        hashMap = new HashMap<Object, Integer>();
        object3 = new String[gEPSymbolSet.numberOfFunctions + stringArray.length];
        int n5 = 0;
        while (n5 < gEPSymbolSet.numberOfFunctions) {
            object2 = gEPSymbolSet.symbols[gEPSymbolSet.functions[n5]];
            object3[n5] = ((GEPSymbol)object2).symbol;
            ++n5;
        }
        n5 = 0;
        while (n5 < stringArray.length) {
            object3[gEPSymbolSet.numberOfFunctions + n5] = stringArray[n5];
            ++n5;
        }
        Arrays.sort(object3);
        n5 = ((Object[])object3).length - 1;
        while (n5 >= 0) {
            object2 = "\\Q" + (String)object3[n5] + "\\E";
            iterator = ((String)object4).replaceFirst((String)object2, "");
            while (!((String)((Object)iterator)).equals(object4)) {
                ++n2;
                object = (Integer)hashMap.get(object3[n5]);
                if (object == null) {
                    hashMap.put(object3[n5], new Integer(1));
                } else {
                    hashMap.put(object3[n5], new Integer((Integer)object + 1));
                }
                object4 = iterator;
                iterator = ((String)object4).replaceFirst((String)object2, "");
            }
            --n5;
        }
        evolutionState.output.println("\n\nSize of program (" + string + " simplified): " + (n + n2), 3000, this.statisticslog);
        Set set = hashMap2.entrySet();
        evolutionState.output.print("Variables used(variable count) " + set.size() + ": ", 3000, this.statisticslog);
        boolean bl = true;
        iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                evolutionState.output.print(", ", 3000, this.statisticslog);
            }
            bl = false;
            object = (Map.Entry)iterator.next();
            string4 = (String)object.getKey();
            string3 = ((Integer)object.getValue()).toString();
            evolutionState.output.print(String.valueOf(string4) + " " + string3, 3000, this.statisticslog);
        }
        set = hashMap.entrySet();
        evolutionState.output.print("\nFunctions used(function count) " + set.size() + ": ", 3000, this.statisticslog);
        bl = true;
        iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                evolutionState.output.print(", ", 3000, this.statisticslog);
            }
            bl = false;
            object = iterator.next();
            string4 = (String)object.getKey();
            string3 = ((Integer)object.getValue()).toString();
            evolutionState.output.print(String.valueOf(string4) + " " + string3, 3000, this.statisticslog);
        }
    }

    class BestGEPIndividualComparator
    implements SortComparatorL {
        Individual[] inds;

        public BestGEPIndividualComparator(Individual[] individualArray) {
            this.inds = individualArray;
        }

        public boolean lt(long l, long l2) {
            return this.inds[(int)l2].fitness.betterThan(this.inds[(int)l].fitness);
        }

        public boolean gt(long l, long l2) {
            return this.inds[(int)l].fitness.betterThan(this.inds[(int)l2].fitness);
        }
    }
}

