/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.gep.GEPChromosome;
import ec.gep.GEPDependentVariable;
import ec.gep.GEPFitnessFunction;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.gep.GEPSymbol;
import ec.gep.GEPSymbolSet;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jscl.math.Expression;
import jscl.text.ParseException;

public class GEPSimpleStatisticsNRCTimeSeries
extends Statistics
implements SteadyStateStatisticsForm {
    public static final String P_STATISTICS_FILE = "file";
    public static final String P_OBSERVED_VS_COMPUTED_FILE = "file-observed-versus-computed";
    public static final String P_OBSERVED_VS_COMPUTED_TEST_FILE = "file-observed-versus-computed-test";
    public static final String P_DETAIL_TO_LOG = "detail-to-log";
    public static final String P_NO_OBSERVED_VS_COMPUTED = "no-observed-versus-computed";
    public static final String P_COMPRESS = "gzip";
    public int statisticslog = 0;
    public int observedVsComputedlog;
    public int observedVsComputedTestlog;
    public boolean noObserveredComputedDisplay = false;
    public String detailToLog = "change";
    public Individual[] best_of_run = null;
    public int[] best_of_run_generation = null;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        File file;
        super.setup(evolutionState, parameter);
        File file2 = evolutionState.parameters.getFile(parameter.push(P_STATISTICS_FILE), null);
        if (file2 != null) {
            try {
                this.statisticslog = evolutionState.output.addLog(file2, 2999, false, !evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false), evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred while trying to create the log " + file2 + ":\n" + iOException);
            }
        }
        this.noObserveredComputedDisplay = evolutionState.parameters.getBoolean(parameter.push(P_NO_OBSERVED_VS_COMPUTED), parameter.push(P_NO_OBSERVED_VS_COMPUTED), false);
        File file3 = evolutionState.parameters.getFile(parameter.push(P_OBSERVED_VS_COMPUTED_FILE), null);
        if (file3 != null) {
            try {
                this.observedVsComputedlog = evolutionState.output.addLog(file3, 2999, false, !evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false), evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred while trying to create the log " + file3 + ":\n" + iOException);
            }
        } else {
            this.observedVsComputedlog = this.statisticslog;
        }
        if ((file = evolutionState.parameters.getFile(parameter.push(P_OBSERVED_VS_COMPUTED_TEST_FILE), null)) == null) {
            this.observedVsComputedTestlog = this.observedVsComputedlog;
        } else {
            try {
                this.observedVsComputedTestlog = evolutionState.output.addLog(file, 2999, false, !evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false), evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred while trying to create the log " + file + ":\n" + iOException);
            }
        }
        this.detailToLog = evolutionState.parameters.getStringWithDefault(parameter.push(P_DETAIL_TO_LOG), null, "change");
        if (!(this.detailToLog.equals("change") || this.detailToLog.equals("final") || this.detailToLog.equals("all"))) {
            evolutionState.output.warning("Expecting detail-to-log to be one of 'change', 'final' or 'all' not '" + this.detailToLog + "'. Setting to 'change'.");
            this.detailToLog = "change";
        }
    }

    public void postInitializationStatistics(EvolutionState evolutionState) {
        super.postInitializationStatistics(evolutionState);
        this.best_of_run = new Individual[evolutionState.population.subpops.length];
        this.best_of_run_generation = new int[evolutionState.population.subpops.length];
        GEPSpecies gEPSpecies = (GEPSpecies)evolutionState.population.subpops[0].species;
        int[] nArray = evolutionState.seeds;
        String string = String.valueOf(nArray[0]);
        int n = 0;
        while (n < nArray.length - 1) {
            string = String.valueOf(string) + String.valueOf(nArray[n]);
            ++n;
        }
        evolutionState.output.println("GENERAL PARAMETERS", 3000, this.statisticslog);
        String string2 = "";
        String[] stringArray = evolutionState.runtimeArguments;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                string2 = String.valueOf(stringArray[n2]) + " ";
                ++n2;
            }
        }
        evolutionState.output.println("Arguments used in this run: " + string2, 3000, this.statisticslog);
        evolutionState.output.println("Maximum number of generations in this run: " + evolutionState.numGenerations, 3000, this.statisticslog);
        evolutionState.output.println("Size of population in this run: " + evolutionState.population.subpops[0].individuals.length, 3000, this.statisticslog);
        evolutionState.output.println("Number of Chromosomes per individual: " + gEPSpecies.numberOfChromosomes, 3000, this.statisticslog);
        evolutionState.output.println("Number of genes per chromosome: " + gEPSpecies.numberOfGenes, 3000, this.statisticslog);
        evolutionState.output.println("Size of gene head: " + gEPSpecies.headSize, 3000, this.statisticslog);
        evolutionState.output.println("Seed(s) used in this job: " + string, 3000, this.statisticslog);
        evolutionState.output.println("Problem type: " + gEPSpecies.problemTypeName, 3000, this.statisticslog);
        if (gEPSpecies.problemType == 1) {
            evolutionState.output.println("Classification rounding threshold: " + GEPIndividual.getThreshold(), 3000, this.statisticslog);
        }
        Parameter parameter = new Parameter("eval.problem.fitness-function");
        evolutionState.output.println("Fitness function: " + evolutionState.parameters.getStringWithDefault(parameter, parameter, "??UNKNOWN??"), 3000, this.statisticslog);
        evolutionState.output.println("", 3000, this.statisticslog);
    }

    public void postEvaluationStatistics(EvolutionState evolutionState) {
        super.postEvaluationStatistics(evolutionState);
        Individual[] individualArray = new Individual[evolutionState.population.subpops.length];
        int n = 0;
        while (n < evolutionState.population.subpops.length) {
            individualArray[n] = evolutionState.population.subpops[n].individuals[0];
            int n2 = 1;
            while (n2 < evolutionState.population.subpops[n].individuals.length) {
                if (evolutionState.population.subpops[n].individuals[n2].fitness.betterThan(individualArray[n].fitness)) {
                    individualArray[n] = evolutionState.population.subpops[n].individuals[n2];
                }
                ++n2;
            }
            n2 = 0;
            if (this.best_of_run[n] == null || individualArray[n].fitness.betterThan(this.best_of_run[n].fitness)) {
                this.best_of_run[n] = (Individual)individualArray[n].clone();
                this.best_of_run_generation[n] = evolutionState.generation;
                n2 = 1;
            }
            if (this.detailToLog.equals("all") || this.detailToLog.equals("change") && n2 != 0) {
                evolutionState.output.println("BEST INDIVIDUAL OF GENERATION", 3000, this.statisticslog);
                evolutionState.output.println("Generation: " + evolutionState.generation, 3000, this.statisticslog);
                individualArray[n].printIndividualForHumans(evolutionState, this.statisticslog, 3000);
            }
            ++n;
        }
    }

    public void finalStatistics(EvolutionState evolutionState, int n) {
        super.finalStatistics(evolutionState, n);
        int n2 = 0;
        while (n2 < evolutionState.population.subpops.length) {
            GEPIndividual gEPIndividual = (GEPIndividual)this.best_of_run[n2];
            evolutionState.output.println("\nBEST INDIVIDUAL OF RUN", 3000, this.statisticslog);
            evolutionState.output.println("Found at Generation: " + this.best_of_run_generation[n2], 3000, this.statisticslog);
            this.best_of_run[n2].printIndividualForHumans(evolutionState, this.statisticslog, 3000);
            String string = ((GEPIndividual)this.best_of_run[n2]).genotypeToStringForHumansMathExpression();
            String string2 = string.replaceAll("T\\[t-", "v");
            string2 = string2.replaceAll("S\\[t-", "w");
            string2 = string2.replace("]", "");
            evolutionState.output.println("USER\n" + string2, 3000, this.statisticslog);
            String string3 = "";
            try {
                string3 = Expression.valueOf((String)string2).simplify().toString();
                evolutionState.output.println("USER (SIMPLIFIED)\n" + Expression.valueOf((String)string2).simplify().toString() + "\n", 3000, this.statisticslog);
            }
            catch (ParseException parseException) {
                evolutionState.output.println("USER (SIMPLIFIED)\nUnable to simplify the math expression ... jscl.meditor simplify failed\n", 3000, this.statisticslog);
            }
            string2 = string.replaceAll("T\\[t-", "T_{");
            string2 = string2.replaceAll("S\\[t-", "S_{");
            string2 = string2.replaceAll("]", "}");
            evolutionState.output.println("LATEX\n" + string2, 3000, this.statisticslog);
            string2 = string.replaceAll("T\\[t-", "T[");
            string2 = string2.replaceAll("S\\[t-", "S[");
            try {
                string2 = Expression.valueOf((String)string2).simplify().toString();
                string2 = string2.replaceAll("T\\[", "T_{");
                string2 = string2.replaceAll("S\\[", "S_{");
                string2 = string2.replaceAll("]", "}");
                evolutionState.output.println("LATEX (SIMPLIFIED)\n" + string2 + "\n", 3000, this.statisticslog);
            }
            catch (ParseException parseException) {
                evolutionState.output.println("LATEX (SIMPLIFIED)\nUnable to simplify the math expression ... jscl.meditor simplify failed\n", 3000, this.statisticslog);
            }
            string2 = string.replaceAll("t-", "");
            evolutionState.output.println("C\n" + string2 + "\n", 3000, this.statisticslog);
            int n3 = gEPIndividual.chromosomes.length;
            int n4 = 0;
            while (n4 < n3) {
                double d;
                int n5;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                int n6 = n4 + 1;
                if (n4 > 0) {
                    evolutionState.output.println("", 3000, this.statisticslog);
                }
                if (n3 > 1) {
                    evolutionState.output.println("Chromosome " + n6 + ":", 3000, this.statisticslog);
                }
                GEPChromosome gEPChromosome = gEPIndividual.chromosomes[n4];
                evolutionState.output.println("MODEL COMPOSITION", 3000, this.statisticslog);
                evolutionState.output.println("Size of program: " + gEPChromosome.size(), 3000, this.statisticslog);
                evolutionState.output.print("Variables used(variable count): ", 3000, this.statisticslog);
                int[] nArray = gEPChromosome.variableUseageCounts();
                GEPSymbolSet gEPSymbolSet = ((GEPSpecies)evolutionState.population.subpops[n2].species).symbolSet;
                boolean bl = true;
                int n7 = 0;
                while (n7 < nArray.length) {
                    if (nArray[n7] > 0) {
                        if (!bl) {
                            evolutionState.output.print(", ", 3000, this.statisticslog);
                        }
                        object4 = gEPSymbolSet.symbols[gEPSymbolSet.terminals[n7]].symbol;
                        evolutionState.output.print(String.valueOf(object4) + " " + nArray[n7], 3000, this.statisticslog);
                        bl = false;
                    }
                    ++n7;
                }
                evolutionState.output.print("\nFunctions used(function count): ", 3000, this.statisticslog);
                HashMap hashMap = gEPChromosome.functionUseageCounts();
                object4 = hashMap.entrySet();
                bl = true;
                Object object5 = object4.iterator();
                while (object5.hasNext()) {
                    if (!bl) {
                        evolutionState.output.print(", ", 3000, this.statisticslog);
                    }
                    bl = false;
                    object3 = (Map.Entry)object5.next();
                    object2 = (String)object3.getKey();
                    object = ((Integer)object3.getValue()).toString();
                    evolutionState.output.print(String.valueOf(object2) + " " + (String)object, 3000, this.statisticslog);
                }
                object5 = gEPChromosome.myGEPIndividual.genotypeToStringForHumansMathExpression();
                object3 = "";
                try {
                    object3 = Expression.valueOf((String)object5).simplify().toString();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.displaySimplifiedMathExpressionVariableFunctionCounts(evolutionState, gEPChromosome, gEPSymbolSet, "MATH", (String)object3);
                this.displaySimplifiedMathExpressionVariableFunctionCounts(evolutionState, gEPChromosome, gEPSymbolSet, "USER", string3);
                object2 = (GEPSpecies)evolutionState.population.subpops[0].species;
                evolutionState.output.println("\n\nMODEL QUALITY MEASURES (TRAINING)", 3000, this.statisticslog);
                this.displayStatistics(evolutionState, (GEPSpecies)object2, gEPIndividual, n4, true);
                object = GEPDependentVariable.testingData.getDependentVariableValues(n4);
                if (object != null) {
                    evolutionState.output.println("\nMODEL QUALITY MEASURES (TEST)", 3000, this.statisticslog);
                    int n8 = 0;
                    n5 = 0;
                    while (n5 < ((Object)object).length) {
                        d = gEPIndividual.eval(n4, false, n5);
                        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || Double.isNaN(d)) {
                            ++n8;
                        }
                        ++n5;
                    }
                    evolutionState.output.println("Number of Calculation Errors: " + n8 + " out of " + ((Object)object).length + " test sets", 3000, this.statisticslog);
                    this.displayStatistics(evolutionState, (GEPSpecies)object2, gEPIndividual, n4, false);
                }
                if (!this.noObserveredComputedDisplay) {
                    double d2;
                    evolutionState.output.println("OBSERVED\tAND COMPUTED (TRAINING)", 3000, this.observedVsComputedlog);
                    evolutionState.output.println("#Observed GEP-Model", 3000, this.observedVsComputedlog);
                    double[] dArray = GEPDependentVariable.trainingData.getDependentVariableValues(n4);
                    n5 = 0;
                    while (n5 < dArray.length) {
                        d = dArray[n5];
                        d2 = gEPIndividual.eval(n4, true, n5);
                        evolutionState.output.println(String.valueOf(Double.toString(d)) + "\t" + Double.toString(d2), 3000, this.observedVsComputedlog);
                        ++n5;
                    }
                    if (object != null) {
                        evolutionState.output.println("", 3000, this.statisticslog);
                        evolutionState.output.println("OBSERVED\tAND COMPUTED (TEST)", 3000, this.observedVsComputedlog);
                        evolutionState.output.println("#Observed GEP-Model", 3000, this.observedVsComputedlog);
                        dArray = GEPDependentVariable.testingData.getDependentVariableValues(n4);
                        n5 = 0;
                        while (n5 < dArray.length) {
                            d = dArray[n5];
                            d2 = gEPIndividual.eval(n4, false, n5);
                            evolutionState.output.println(String.valueOf(Double.toString(d)) + "\t" + Double.toString(d2), 3000, this.observedVsComputedTestlog);
                            ++n5;
                        }
                    }
                    evolutionState.output.println("#----------", 3000, this.observedVsComputedlog);
                }
                ++n4;
            }
            ++n2;
        }
    }

    void displayStatistics(EvolutionState evolutionState, GEPSpecies gEPSpecies, GEPIndividual gEPIndividual, int n, boolean bl) {
        if (gEPSpecies.problemType == 1 || gEPSpecies.problemType == 2) {
            evolutionState.output.println("Confusion Matrix: ", 3000, this.statisticslog);
            evolutionState.output.println("                Predicted Value\n               |  Yes\t|  No\n               |----------------", 3000, this.statisticslog);
            int[] nArray = GEPFitnessFunction.getConfusionMatrixValues(bl, gEPIndividual, n);
            evolutionState.output.println("            Yes|  " + nArray[0] + "\t|  " + nArray[1], 3000, this.statisticslog);
            evolutionState.output.println("Actual Value   |----------------", 3000, this.statisticslog);
            evolutionState.output.println("            No |  " + nArray[2] + "\t|  " + nArray[3], 3000, this.statisticslog);
            evolutionState.output.println("               |----------------", 3000, this.statisticslog);
        } else {
            evolutionState.output.println("Statistics: ", 3000, this.statisticslog);
            evolutionState.output.println("MSE:  " + GEPFitnessFunction.MSErawFitness(bl, gEPIndividual, n) + "    \tRAE:  " + GEPFitnessFunction.RAErawFitness(bl, gEPIndividual, n) + "    \tRSE:  " + GEPFitnessFunction.RSErawFitness(bl, gEPIndividual, n), 3000, this.statisticslog);
            evolutionState.output.println("RMSE: " + GEPFitnessFunction.RMSErawFitness(bl, gEPIndividual, n) + "    \tMAE:  " + GEPFitnessFunction.MAErawFitness(bl, gEPIndividual, n) + "    \tRRSE: " + GEPFitnessFunction.RRSErawFitness(bl, gEPIndividual, n), 3000, this.statisticslog);
            evolutionState.output.println("Corr Coeff: " + GEPFitnessFunction.CCrawFitness(bl, gEPIndividual, n), 3000, this.statisticslog);
        }
        evolutionState.output.println("", 3000, this.statisticslog);
    }

    void displaySimplifiedMathExpressionVariableFunctionCounts(EvolutionState evolutionState, GEPChromosome gEPChromosome, GEPSymbolSet gEPSymbolSet, String string, String string2) {
        String string3;
        String string4;
        Object object;
        Iterator iterator;
        Object object2;
        String string5;
        Object[] objectArray;
        int n = 0;
        int n2 = 0;
        Object object3 = "";
        if (string2.equals("")) {
            evolutionState.output.println("\n\nSize of program (" + string + " simplified): unknown ... expression simplification failed", 3000, this.statisticslog);
            return;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        object3 = string2;
        Object[] objectArray2 = new String[gEPSymbolSet.numberOfTerminals];
        int n3 = 0;
        while (n3 < gEPSymbolSet.numberOfTerminals) {
            objectArray = gEPSymbolSet.symbols[gEPSymbolSet.terminals[n3]];
            string5 = objectArray.symbol;
            if (string.equals("USER")) {
                string5 = string5.replaceAll("T\\[t-", "v");
                string5 = string5.replaceAll("S\\[t-", "w");
                string5 = string5.replaceAll("]", "");
            } else {
                try {
                    string5 = Expression.valueOf((String)string5).simplify().toString();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            objectArray2[n3] = string5;
            ++n3;
        }
        Arrays.sort(objectArray2);
        n3 = gEPSymbolSet.numberOfTerminals - 1;
        while (n3 >= 0) {
            objectArray = "\\Q" + (String)objectArray2[n3] + "\\E";
            string5 = ((String)object3).replaceFirst((String)objectArray, "");
            while (!string5.equals(object3)) {
                ++n;
                object2 = (Integer)hashMap.get(objectArray2[n3]);
                if (object2 == null) {
                    hashMap.put(objectArray2[n3], new Integer(1));
                } else {
                    hashMap.put(objectArray2[n3], new Integer((Integer)object2 + 1));
                }
                object3 = string5;
                string5 = ((String)object3).replaceFirst((String)objectArray, "");
            }
            --n3;
        }
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        objectArray = new String[gEPSymbolSet.numberOfFunctions];
        int n4 = 0;
        while (n4 < gEPSymbolSet.numberOfFunctions) {
            object2 = gEPSymbolSet.symbols[gEPSymbolSet.functions[n4]];
            objectArray[n4] = ((GEPSymbol)object2).symbol;
            ++n4;
        }
        Arrays.sort(objectArray);
        n4 = gEPSymbolSet.numberOfFunctions - 1;
        while (n4 >= 0) {
            object2 = "\\Q" + (String)objectArray[n4] + "\\E";
            iterator = ((String)object3).replaceFirst((String)object2, "");
            while (!((String)((Object)iterator)).equals(object3)) {
                ++n2;
                object = (Integer)hashMap2.get(objectArray[n4]);
                if (object == null) {
                    hashMap2.put(objectArray[n4], new Integer(1));
                } else {
                    hashMap2.put(objectArray[n4], new Integer((Integer)object + 1));
                }
                object3 = iterator;
                iterator = ((String)object3).replaceFirst((String)object2, "");
            }
            --n4;
        }
        evolutionState.output.println("\n\nSize of program (" + string + " simplified): " + (n + n2), 3000, this.statisticslog);
        evolutionState.output.print("Variables used(variable count): ", 3000, this.statisticslog);
        Set set = hashMap.entrySet();
        boolean bl = true;
        iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                evolutionState.output.print(", ", 3000, this.statisticslog);
            }
            bl = false;
            object = (Map.Entry)iterator.next();
            string4 = (String)object.getKey();
            string3 = ((Integer)object.getValue()).toString();
            evolutionState.output.print(String.valueOf(string4) + " " + string3, 3000, this.statisticslog);
        }
        evolutionState.output.print("\nFunctions used(function count): ", 3000, this.statisticslog);
        set = hashMap2.entrySet();
        bl = true;
        iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                evolutionState.output.print(", ", 3000, this.statisticslog);
            }
            bl = false;
            object = iterator.next();
            string4 = (String)object.getKey();
            string3 = ((Integer)object.getValue()).toString();
            evolutionState.output.print(String.valueOf(string4) + " " + string3, 3000, this.statisticslog);
        }
    }
}

