/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.EvolutionState;
import ec.Fitness;
import ec.Individual;
import ec.Species;
import ec.gep.GEPDefaults;
import ec.gep.GEPDependentVariable;
import ec.gep.GEPFitnessFunction;
import ec.gep.GEPFunctionSymbol;
import ec.gep.GEPIndividual;
import ec.gep.GEPSymbolSet;
import ec.util.Parameter;

public class GEPSpecies
extends Species {
    public static final String P_GEPSPECIES = "species";
    public static final String P_NUMGENES = "numgenes";
    public static final String P_NUMCHROMOSOMES = "numchromosomes";
    public static final String P_HEADSIZE = "gene-headsize";
    public static final String P_LINKINGFUNCTION = "gene-linking-function";
    public static final String P_PROBLEMTYPE = "problemtype";
    public static final String P_CLASSIFICATION_THRESHOLD = "classification-threshold";
    public static final String P_TIMESERIES_DELAY = "timeseries-delay";
    public static final String P_TIMESERIES_EMBEDDINGDIMENSION = "timeseries-embeddingdimension";
    public static final String P_TIMESERIES_TESTINGPREDICTIONS = "timeseries-testingpredictions";
    public static final String P_INVERSIONPROB = "inversion-prob";
    public static final String P_MUTATIONPROB = "mutation-prob";
    public static final String P_ISTRANSPOSITIONPROB = "istransposition-prob";
    public static final String P_RISTRANSPOSITIONPROB = "ristransposition-prob";
    public static final String P_ONEPOINTRECOMBPROB = "onepointrecomb-prob";
    public static final String P_TWOPOINTRECOMBPROB = "twopointrecomb-prob";
    public static final String P_GENERECOMBPROB = "generecomb-prob";
    public static final String P_GENETRANSPOSITIONPROB = "genetransposition-prob";
    public static final String P_USECONSTANTS = "use-constants";
    public static final String P_NUMCONSTANTSPERGENE = "numconstantspergene";
    public static final String P_INTEGERCONSTANTS = "integer-constants";
    public static final String P_CONSTANTSLOWERLIMIT = "constants-lowerlimit";
    public static final String P_CONSTANTSUPPERLIMIT = "constants-upperlimit";
    public static final String P_DCINVERSIONPROB = "dc-inversion-prob";
    public static final String P_DCMUTATIONPROB = "dc-mutation-prob";
    public static final String P_DCISTRANSPOSITIONPROB = "dc-istransposition-prob";
    public static final String P_RNCMUTATIONPROB = "rnc-mutation-prob";
    public static final String P_SYMBOLSET = "symbolset";
    public static final int PT_FUNCTIONFINDING = 0;
    public static final int PT_CLASSIFICATION = 1;
    public static final int PT_LOGICAL = 2;
    public static final int PT_TIMESERIES = 3;
    public static final int LF_FIELDSIZE_IN_LINKINGFUNCTIONS = 5;
    public static final int LF_ADD = 0;
    public static final int LF_SUB = 1;
    public static final int LF_MUL = 2;
    public static final int LF_DIV = 3;
    public static final int LF_AND = 4;
    public static final int LF_OR = 5;
    public static final int LF_XOR = 6;
    public static final int LF_NAND = 7;
    public static final int LF_NOR = 8;
    public static final int LF_NXOR = 9;
    public double mutationProbability;
    public double inversionProbability;
    public double isTranspositionProbability;
    public double risTranspositionProbability;
    public double onePointRecombinationProbability;
    public double twoPointRecombinationProbability;
    public double geneRecombinationProbability;
    public double geneTranspositionProbability;
    public int problemType = -1;
    String[] problemTypeNames = new String[]{"functionfinding", "classification", "timeseries", "logical"};
    public int[] problemTypeIds;
    public String problemTypeName;
    public int numberOfChromosomes;
    public int numberOfGenes;
    public int headSize;
    public int tailSize;
    public int geneSize;
    public int timeseriesDelay;
    public int timeseriesEmbeddingDimension;
    public int timeseriesTestingPredictions;
    public String linkingFunctions;
    public String[] oldLinkingFunctionSymbolNames;
    public GEPFunctionSymbol linkingFunctionSymbol;
    public String linkingFunctionName;
    public boolean useConstants;
    public int numberOfConstantsPerGene;
    public boolean integerConstants;
    public double constantsLowerLimit;
    public double constantsUpperLimit;
    public double dcMutationProbability;
    public double dcInversionProbability;
    public double dcIsTranspositionProbability;
    public double rncMutationProbability;
    public GEPSymbolSet symbolSet;
    public String symbolSetName;

    public GEPSpecies() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        this.problemTypeIds = nArray;
        this.problemTypeName = "";
        this.timeseriesDelay = 1;
        this.timeseriesEmbeddingDimension = 1;
        this.timeseriesTestingPredictions = 1;
        this.linkingFunctions = "+    add  -    sub  *    mul  /    div  and  or   xor  nand nor  nxor ";
        this.oldLinkingFunctionSymbolNames = new String[]{"Add", "Add", "Sub", "Sub", "Mul", "Mul", "Div", "Div", "And", "Or", "Xor", "Nand", "Nor", "Nxor"};
        this.linkingFunctionSymbol = null;
        this.linkingFunctionName = "Add";
        this.useConstants = false;
        this.numberOfConstantsPerGene = 0;
        this.integerConstants = false;
        this.constantsLowerLimit = 0.0;
        this.constantsUpperLimit = 1.0;
    }

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_GEPSPECIES);
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        Parameter parameter2;
        block51: {
            parameter2 = this.defaultBase();
            GEPFitnessFunction.setup(evolutionState);
            this.mutationProbability = evolutionState.parameters.getDouble(parameter.push(P_MUTATIONPROB), parameter2.push(P_MUTATIONPROB), 0.0, 1.0);
            if (this.mutationProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have a mutation probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_MUTATIONPROB), parameter2.push(P_MUTATIONPROB));
                this.mutationProbability = 0.0;
            }
            this.inversionProbability = evolutionState.parameters.getDouble(parameter.push(P_INVERSIONPROB), parameter2.push(P_INVERSIONPROB), 0.0, 1.0);
            if (this.inversionProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have an inversion probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_INVERSIONPROB), parameter2.push(P_INVERSIONPROB));
                this.inversionProbability = 0.0;
            }
            this.isTranspositionProbability = evolutionState.parameters.getDouble(parameter.push(P_ISTRANSPOSITIONPROB), parameter2.push(P_ISTRANSPOSITIONPROB), 0.0, 1.0);
            if (this.isTranspositionProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have an IS transposition probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_ISTRANSPOSITIONPROB), parameter2.push(P_ISTRANSPOSITIONPROB));
                this.isTranspositionProbability = 0.0;
            }
            this.risTranspositionProbability = evolutionState.parameters.getDouble(parameter.push(P_RISTRANSPOSITIONPROB), parameter2.push(P_RISTRANSPOSITIONPROB), 0.0, 1.0);
            if (this.risTranspositionProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have an RIS transposition probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_RISTRANSPOSITIONPROB), parameter2.push(P_RISTRANSPOSITIONPROB));
                this.risTranspositionProbability = 0.0;
            }
            this.onePointRecombinationProbability = evolutionState.parameters.getDouble(parameter.push(P_ONEPOINTRECOMBPROB), parameter2.push(P_ONEPOINTRECOMBPROB), 0.0, 1.0);
            if (this.onePointRecombinationProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have an one point recombination probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_ONEPOINTRECOMBPROB), parameter2.push(P_ONEPOINTRECOMBPROB));
                this.onePointRecombinationProbability = 0.0;
            }
            this.twoPointRecombinationProbability = evolutionState.parameters.getDouble(parameter.push(P_TWOPOINTRECOMBPROB), parameter2.push(P_TWOPOINTRECOMBPROB), 0.0, 1.0);
            if (this.twoPointRecombinationProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have an two point recombination probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_TWOPOINTRECOMBPROB), parameter2.push(P_TWOPOINTRECOMBPROB));
                this.twoPointRecombinationProbability = 0.0;
            }
            this.geneRecombinationProbability = evolutionState.parameters.getDouble(parameter.push(P_GENERECOMBPROB), parameter2.push(P_GENERECOMBPROB), 0.0, 1.0);
            if (this.geneRecombinationProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have an gene recombination probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_GENERECOMBPROB), parameter2.push(P_GENERECOMBPROB));
                this.geneRecombinationProbability = 0.0;
            }
            this.geneTranspositionProbability = evolutionState.parameters.getDouble(parameter.push(P_GENETRANSPOSITIONPROB), parameter2.push(P_GENETRANSPOSITIONPROB), 0.0, 1.0);
            if (this.geneTranspositionProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have an gene transposition probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_GENETRANSPOSITIONPROB), parameter2.push(P_GENETRANSPOSITIONPROB));
                this.geneTranspositionProbability = 0.0;
            }
            this.numberOfChromosomes = evolutionState.parameters.getIntWithDefault(parameter.push(P_NUMCHROMOSOMES), parameter2.push(P_NUMCHROMOSOMES), 1);
            if (this.numberOfChromosomes < 1) {
                evolutionState.output.error("Number of Chromosomes in an individual must be > 0", parameter.push(P_NUMCHROMOSOMES), parameter2.push(P_NUMCHROMOSOMES));
            }
            GEPDependentVariable.trainingData.setup(this.numberOfChromosomes);
            GEPDependentVariable.testingData.setup(this.numberOfChromosomes);
            this.numberOfGenes = evolutionState.parameters.getInt(parameter.push(P_NUMGENES), parameter2.push(P_NUMGENES), 1);
            if (this.numberOfGenes < 1) {
                evolutionState.output.error("Number of Genes in Genome must be > 0", parameter.push(P_NUMGENES), parameter2.push(P_NUMGENES));
            }
            this.headSize = evolutionState.parameters.getInt(parameter.push(P_HEADSIZE), parameter2.push(P_HEADSIZE), 1);
            if (this.headSize == 0) {
                evolutionState.output.error("Genes must have a head size > 0", parameter.push(P_HEADSIZE), parameter2.push(P_HEADSIZE));
            }
            this.problemTypeName = evolutionState.parameters.getStringWithDefault(parameter.push(P_PROBLEMTYPE), parameter2.push(P_PROBLEMTYPE), "unknown");
            this.problemType = -1;
            int n = 0;
            while (n < this.problemTypeNames.length) {
                if (this.problemTypeName.equals(this.problemTypeNames[n])) {
                    this.problemType = this.problemTypeIds[n];
                    break;
                }
                ++n;
            }
            if (this.problemType < 0) {
                evolutionState.output.fatal("Must specify a problem type as one of: functionfinding, classification, timeseries, logical", parameter.push(P_PROBLEMTYPE), parameter2.push(P_PROBLEMTYPE));
            }
            this.linkingFunctionName = evolutionState.parameters.getStringWithDefault(parameter.push(P_LINKINGFUNCTION), parameter2.push(P_LINKINGFUNCTION), "Add");
            String string = this.linkingFunctionName.trim().toLowerCase();
            int n2 = this.linkingFunctions.indexOf(String.valueOf(string) + " ");
            if (n2 >= 0) {
                this.linkingFunctionName = this.oldLinkingFunctionSymbolNames[n2];
            }
            try {
                Class<?> clazz = Class.forName("ec.gep.symbols." + this.linkingFunctionName);
                this.linkingFunctionSymbol = (GEPFunctionSymbol)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                if (this.numberOfGenes > 1) {
                    evolutionState.output.fatal("Unable to create GEPFunctionSymbol class for linking function '" + this.linkingFunctionName + "'. " + instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (this.numberOfGenes > 1) {
                    evolutionState.output.fatal("Unable to create GEPFunctionSymbol class for linking function '" + this.linkingFunctionName + "' " + illegalAccessException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.numberOfGenes <= 1) break block51;
                evolutionState.output.fatal("Unable to create GEPFunctionSymbol class for linking function '" + this.linkingFunctionName + "' " + classNotFoundException);
            }
        }
        if (this.linkingFunctionSymbol != null) {
            int n;
            if (!this.linkingFunctionSymbol.isLogicalFunction() && this.problemType == 2) {
                evolutionState.output.fatal("linking function for a logical problem type must be a logical function and not: " + this.linkingFunctionName, parameter.push(P_LINKINGFUNCTION), parameter2.push(P_LINKINGFUNCTION));
            }
            if (this.linkingFunctionSymbol.isLogicalFunction() && this.problemType != 2) {
                evolutionState.output.fatal("linking function for a non logical problem type must not be a logical function as specified: " + this.linkingFunctionName, parameter.push(P_LINKINGFUNCTION), parameter2.push(P_LINKINGFUNCTION));
            }
            if ((n = this.linkingFunctionSymbol.arity) > 2 && (this.numberOfGenes - n) % (n - 1) != 0) {
                evolutionState.output.fatal("Arity (" + this.linkingFunctionSymbol.arity + ") of linking function '" + this.linkingFunctionName + "' is NOT compatible with the number of genes: " + this.numberOfGenes, parameter.push(P_LINKINGFUNCTION), parameter2.push(P_LINKINGFUNCTION));
            }
        }
        if (this.problemType == 3) {
            this.timeseriesDelay = evolutionState.parameters.getIntWithDefault(parameter.push(P_TIMESERIES_DELAY), parameter2.push(P_TIMESERIES_DELAY), -1);
            this.timeseriesEmbeddingDimension = evolutionState.parameters.getIntWithDefault(parameter.push(P_TIMESERIES_EMBEDDINGDIMENSION), parameter2.push(P_TIMESERIES_EMBEDDINGDIMENSION), -1);
            this.timeseriesTestingPredictions = evolutionState.parameters.getIntWithDefault(parameter.push(P_TIMESERIES_TESTINGPREDICTIONS), parameter2.push(P_TIMESERIES_TESTINGPREDICTIONS), -1);
            if (this.timeseriesDelay <= 0 && this.timeseriesEmbeddingDimension <= 0 && this.timeseriesTestingPredictions <= 0) {
                evolutionState.output.warning("Assuming time series data is NOT in raw format since delay, embedding dimension and testing prediction parameters not supplied.", parameter.push(P_TIMESERIES_DELAY), parameter2.push(P_TIMESERIES_DELAY));
            } else {
                if (this.timeseriesDelay <= 0) {
                    evolutionState.output.warning("Time series delay value must be > 0 ... defaulting to 1.", parameter.push(P_TIMESERIES_DELAY), parameter2.push(P_TIMESERIES_DELAY));
                    this.timeseriesDelay = 1;
                }
                if (this.timeseriesEmbeddingDimension <= 0) {
                    evolutionState.output.warning("Time series embedding dimension value must be > 0 ... defaulting to 5.", parameter.push(P_TIMESERIES_EMBEDDINGDIMENSION), parameter2.push(P_TIMESERIES_EMBEDDINGDIMENSION));
                    this.timeseriesEmbeddingDimension = 5;
                }
                if (this.timeseriesTestingPredictions <= 0) {
                    evolutionState.output.warning("Time series testing predictions value must be > 0 ... defaulting to 5.", parameter.push(P_TIMESERIES_TESTINGPREDICTIONS), parameter2.push(P_TIMESERIES_TESTINGPREDICTIONS));
                    this.timeseriesTestingPredictions = 5;
                }
            }
        }
        GEPIndividual.setThresholdOFF();
        if (this.problemType == 1) {
            double d = 0.5;
            if (evolutionState.parameters.exists(parameter.push(P_CLASSIFICATION_THRESHOLD), parameter2.push(P_CLASSIFICATION_THRESHOLD))) {
                d = evolutionState.parameters.getDouble(parameter.push(P_CLASSIFICATION_THRESHOLD), parameter2.push(P_CLASSIFICATION_THRESHOLD), -1.0);
            } else {
                evolutionState.output.error("Classification problem type must have a rounding threshold set.", parameter.push(P_CLASSIFICATION_THRESHOLD), parameter2.push(P_CLASSIFICATION_THRESHOLD));
            }
            GEPIndividual.setThreshold(d);
        }
        this.useConstants = evolutionState.parameters.getBoolean(parameter.push(P_USECONSTANTS), parameter2.push(P_USECONSTANTS), false);
        if (this.useConstants && this.problemType == 2) {
            evolutionState.output.warning("Cannot use constants with a logical problem type ... turning off constants.", parameter.push(P_USECONSTANTS), parameter2.push(P_USECONSTANTS));
            this.useConstants = false;
        }
        if (this.useConstants) {
            this.integerConstants = evolutionState.parameters.getBoolean(parameter.push(P_INTEGERCONSTANTS), parameter2.push(P_INTEGERCONSTANTS), false);
            evolutionState.output.message("Using " + (this.integerConstants ? "Integer" : "Floating Point") + " Constants");
            this.numberOfConstantsPerGene = evolutionState.parameters.getInt(parameter.push(P_NUMCONSTANTSPERGENE), parameter2.push(P_NUMCONSTANTSPERGENE), 1);
            if (this.numberOfConstantsPerGene <= 0) {
                evolutionState.output.error("Number of constants per gene must be > 0.", parameter.push(P_NUMCONSTANTSPERGENE), parameter2.push(P_NUMCONSTANTSPERGENE));
            }
            if (!evolutionState.parameters.exists(parameter.push(P_CONSTANTSLOWERLIMIT), parameter2.push(P_CONSTANTSLOWERLIMIT))) {
                evolutionState.output.error("GEPSpecies must have a lower limit for the random constants", parameter.push(P_CONSTANTSLOWERLIMIT), parameter2.push(P_CONSTANTSLOWERLIMIT));
            } else {
                this.constantsLowerLimit = evolutionState.parameters.getDoubleWithDefault(parameter.push(P_CONSTANTSLOWERLIMIT), parameter2.push(P_CONSTANTSLOWERLIMIT), 0.0);
            }
            if (this.integerConstants) {
                this.constantsLowerLimit = Math.floor(this.constantsLowerLimit);
            }
            if (!evolutionState.parameters.exists(parameter.push(P_CONSTANTSUPPERLIMIT), parameter2.push(P_CONSTANTSUPPERLIMIT))) {
                evolutionState.output.error("GEPSpecies must have an upper limit for the random constants", parameter.push(P_CONSTANTSLOWERLIMIT), parameter2.push(P_CONSTANTSLOWERLIMIT));
            } else {
                this.constantsUpperLimit = evolutionState.parameters.getDoubleWithDefault(parameter.push(P_CONSTANTSUPPERLIMIT), parameter2.push(P_CONSTANTSUPPERLIMIT), 1.0);
            }
            if (this.integerConstants) {
                this.constantsUpperLimit = Math.ceil(this.constantsUpperLimit);
            }
            if (this.constantsUpperLimit <= this.constantsLowerLimit) {
                evolutionState.output.error("Constants lower limit must be greater than the upper limit");
            }
            this.dcMutationProbability = evolutionState.parameters.getDouble(parameter.push(P_DCMUTATIONPROB), parameter2.push(P_DCMUTATIONPROB), 0.0, 1.0);
            if (this.dcMutationProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have a Dc mutation probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_DCMUTATIONPROB), parameter2.push(P_DCMUTATIONPROB));
                this.dcMutationProbability = 0.0;
            }
            this.dcInversionProbability = evolutionState.parameters.getDouble(parameter.push(P_DCINVERSIONPROB), parameter2.push(P_DCINVERSIONPROB), 0.0, 1.0);
            if (this.dcInversionProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have a Dc inversion probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_DCINVERSIONPROB), parameter2.push(P_DCINVERSIONPROB));
                this.dcInversionProbability = 0.0;
            }
            this.dcIsTranspositionProbability = evolutionState.parameters.getDouble(parameter.push(P_DCISTRANSPOSITIONPROB), parameter2.push(P_DCISTRANSPOSITIONPROB), 0.0, 1.0);
            if (this.dcIsTranspositionProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have a Dc IS transposition probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_DCISTRANSPOSITIONPROB), parameter2.push(P_DCISTRANSPOSITIONPROB));
                this.dcIsTranspositionProbability = 0.0;
            }
            this.rncMutationProbability = evolutionState.parameters.getDouble(parameter.push(P_RNCMUTATIONPROB), parameter2.push(P_RNCMUTATIONPROB), 0.0, 1.0);
            if (this.rncMutationProbability == -1.0) {
                evolutionState.output.warning("GEPSpecies must have an RNC mutation probability between 0.0 and 1.0 inclusive, defaulting to 0.0", parameter.push(P_RNCMUTATIONPROB), parameter2.push(P_RNCMUTATIONPROB));
                this.rncMutationProbability = 0.0;
            }
        }
        Parameter parameter3 = parameter.push(P_SYMBOLSET);
        Parameter parameter4 = parameter2.push(P_SYMBOLSET);
        if (evolutionState.parameters.exists(parameter3) || evolutionState.parameters.exists(parameter4)) {
            this.symbolSet = (GEPSymbolSet)evolutionState.parameters.getInstanceForParameterEq(parameter3, parameter4, GEPSymbolSet.class);
        } else {
            evolutionState.output.warning("No GEPSymbolSet specified, assuming the default class: ec.gep.GEPSymbolSet.", parameter3, parameter4);
            this.symbolSet = new GEPSymbolSet();
        }
        this.symbolSet.setup(evolutionState, parameter3, parameter4, this);
        this.tailSize = this.headSize * (this.symbolSet.maxArity - 1) + 1;
        this.geneSize = this.headSize + this.tailSize;
        evolutionState.output.exitIfErrors();
        super.setup(evolutionState, parameter);
        if (!(this.i_prototype instanceof GEPIndividual)) {
            evolutionState.output.fatal("The Individual class for the Species " + this.getClass().getName() + " is must be a subclass of ec.gep.GEPIndividual.", parameter);
        }
    }

    public GEPSymbolSet symbolSetFor(String string, EvolutionState evolutionState) {
        GEPSymbolSet gEPSymbolSet = null;
        if (this.symbolSet.name.equals(string)) {
            gEPSymbolSet = this.symbolSet;
        }
        if (gEPSymbolSet == null) {
            evolutionState.output.error("The GEP symbol set \"" + string + "\" could not be found.");
        }
        return gEPSymbolSet;
    }

    public Individual newIndividual(EvolutionState evolutionState, int n) {
        GEPIndividual gEPIndividual = (GEPIndividual)this.i_prototype.clone();
        gEPIndividual.reset(evolutionState, n);
        gEPIndividual.fitness = (Fitness)this.f_prototype.clone();
        gEPIndividual.evaluated = false;
        gEPIndividual.chromosomesParsed = false;
        gEPIndividual.species = this;
        return gEPIndividual;
    }
}

