/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;

public class GEPSubpopulation
extends Subpopulation {
    public int numZeroFitnessRetries;
    public static final String P_ZERO_FITNESS_RETRIES = "zero-fitness-retries";

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        this.numZeroFitnessRetries = evolutionState.parameters.getInt(parameter.push(P_ZERO_FITNESS_RETRIES), null, 0);
        if (this.numZeroFitnessRetries < 0) {
            evolutionState.output.fatal("The number of retries for individuals with 0 fitness must be an integer >= 0.\n", parameter.push(P_ZERO_FITNESS_RETRIES), null);
        }
    }

    public void populate(EvolutionState evolutionState, int n) {
        if (this.loadInds != null) {
            try {
                this.readSubpopulation(evolutionState, new LineNumberReader(new FileReader(this.loadInds)));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred when trying to read from the file " + this.loadInds + ".  The IOException was: \n" + iOException);
            }
        } else {
            Hashtable<Individual, Individual> hashtable = null;
            if (this.numDuplicateRetries >= 1) {
                hashtable = new Hashtable<Individual, Individual>(this.individuals.length / 2);
            }
            int n2 = 0;
            while (n2 < this.individuals.length) {
                int n3 = 0;
                while (n3 <= this.numDuplicateRetries) {
                    Object v;
                    this.individuals[n2] = this.species.newIndividual(evolutionState, n);
                    int n4 = 0;
                    while (n4 <= this.numZeroFitnessRetries) {
                        ((SimpleProblemForm)((Object)evolutionState.evaluator.p_problem)).evaluate(evolutionState, this.individuals[n2], 0, 0);
                        if (!((double)this.individuals[n2].fitness.fitness() <= 0.0)) break;
                        this.individuals[n2] = this.species.newIndividual(evolutionState, n);
                        ++n4;
                    }
                    if (this.numDuplicateRetries >= 1 && (v = hashtable.get(this.individuals[n2])) == null) {
                        hashtable.put(this.individuals[n2], this.individuals[n2]);
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

