/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import com.csvreader.CsvReader;
import ec.Clique;
import ec.EvolutionState;
import ec.gep.GEPConstantTerminalSymbol;
import ec.gep.GEPDefaults;
import ec.gep.GEPDependentVariable;
import ec.gep.GEPFunctionSymbol;
import ec.gep.GEPProblem;
import ec.gep.GEPSpecies;
import ec.gep.GEPSymbol;
import ec.gep.GEPTerminalSymbol;
import ec.util.Parameter;
import ec.util.RandomChoice;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class GEPSymbolSet
implements Clique {
    public static final String P_SPECIES = "species";
    public static final String P_SYMBOLSET = "symbolset";
    public static final String P_NAME = "name";
    public static final String P_SYMBOL = "symbol";
    public static final String P_FUNCTION = "function";
    public static final String P_FUNCTIONSIZE = "functionsize";
    public static final String P_FUNCTIONWEIGHT = "weight";
    public static final String P_TERMINAL = "terminal";
    public static final String P_TERMINALSIZE = "terminalsize";
    public static final String P_TERMINALFILENAME = "terminalfilename";
    public static final String P_TESTINGTERMINALFILENAME = "testingdatafilename";
    public static final String P_TERMINALFILESEPARATOR = "terminalfileseparator";
    public static final int CHECK_BOUNDARY = 8;
    public static final String LOCATION_OF_FUNCTION_CLASSES = "ec.gep.symbols";
    public String name;
    public int numberOfSymbols;
    public int maxArity;
    public GEPSymbol[] symbols;
    public int[] terminals;
    public int[] functions;
    public int numberOfTerminals;
    public int numberOfFunctions;
    public float[] cumulativeNormalizedSymbolWeights;
    public float[] cumulativeNormalizedTerminalWeights;
    public float[] cumulativeNormalizedFunctionWeights;
    public double probabilityOfChoosingFunction;

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_SPECIES).push(P_SYMBOLSET);
    }

    public String toString() {
        return this.name;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
    }

    public void setup(EvolutionState evolutionState, Parameter parameter, Parameter parameter2, GEPSpecies gEPSpecies) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        this.maxArity = 0;
        this.name = evolutionState.parameters.getString(parameter.push(P_NAME), parameter2.push(P_NAME));
        if (this.name == null || this.name.equals("")) {
            evolutionState.output.warning("No name was given for this GEP symbol set...not required at this time.", parameter.push(P_NAME), parameter2.push(P_NAME));
        }
        this.numberOfSymbols = this.numberOfFunctions = evolutionState.parameters.getInt(parameter.push(P_FUNCTIONSIZE), parameter2.push(P_FUNCTIONSIZE), 1);
        String string = evolutionState.parameters.getStringWithDefault(parameter.push(P_TERMINALFILENAME), parameter2.push(P_TERMINALFILENAME), "");
        String string2 = evolutionState.parameters.getStringWithDefault(parameter.push(P_TESTINGTERMINALFILENAME), parameter2.push(P_TESTINGTERMINALFILENAME), "");
        String[] stringArray = null;
        CsvReader csvReader = null;
        CsvReader csvReader2 = null;
        boolean bl2 = bl = gEPSpecies.problemType == 3 && gEPSpecies.timeseriesEmbeddingDimension > 0;
        if (!string.equals("")) {
            String string3 = ",";
            try {
                if (string.endsWith(".gz") || string.endsWith(".gzip")) {
                    csvReader = new CsvReader((InputStream)new GZIPInputStream(new FileInputStream(string)), Charset.forName("ISO-8859-1"));
                    string = string.endsWith(".gz") ? string.substring(0, string.length() - 3) : string.substring(0, string.length() - 5);
                } else {
                    csvReader = new CsvReader(string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                evolutionState.output.fatal("The file with terminal definitions and/or values (" + string + ") could not be found", parameter.push(P_TERMINALFILENAME), parameter2.push(P_TERMINALFILENAME));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("The file with terminal definitions and/or values (" + string + ") could not be found or the expected GZIP file could nor be opened", parameter.push(P_TERMINALFILENAME), parameter2.push(P_TERMINALFILENAME));
            }
            if (string.endsWith(".dat")) {
                string3 = "space";
            }
            if (((String)(object4 = evolutionState.parameters.getStringWithDefault(parameter.push(P_TERMINALFILESEPARATOR), parameter2.push(P_TERMINALFILESEPARATOR), string3))).toLowerCase().equals("comma")) {
                object4 = ",";
            } else if (object4 == "\\t" || ((String)object4).toLowerCase().equals("tab")) {
                object4 = "\t";
            } else if (object4 == "space") {
                object4 = " ";
            }
            csvReader.setDelimiter(((String)object4).charAt(0));
            if (!string2.equals("")) {
                try {
                    csvReader2 = string2.endsWith(".gz") || string2.endsWith(".gzip") ? new CsvReader((InputStream)new GZIPInputStream(new FileInputStream(string2)), Charset.forName("ISO-8859-1")) : new CsvReader(string2);
                    csvReader2.setDelimiter(((String)object4).charAt(0));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    evolutionState.output.fatal("The file with testing data values (" + string2 + ") could not be found", parameter.push(P_TERMINALFILENAME), parameter2.push(P_TERMINALFILENAME));
                }
                catch (IOException iOException) {
                    evolutionState.output.fatal("The file with testing data values (" + string + ") could not be found or the expected GZIP file could nor be opened", parameter.push(P_TERMINALFILENAME), parameter2.push(P_TERMINALFILENAME));
                }
            }
        }
        if (bl) {
            this.numberOfTerminals = gEPSpecies.timeseriesEmbeddingDimension;
        } else if (csvReader != null) {
            try {
                csvReader.readHeaders();
                stringArray = csvReader.getHeaders();
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("The file with variable (terminal) definitions and values (" + string + ") failed to read the headers" + iOException, parameter.push(P_TERMINALFILENAME), parameter2.push(P_TERMINALFILENAME));
            }
            this.numberOfTerminals = stringArray.length - gEPSpecies.numberOfChromosomes;
            if (this.numberOfTerminals < 1) {
                evolutionState.output.fatal("The file with terminal definitions and data values (" + string + ") has no independent variables specified in record 1", parameter.push(P_TERMINALFILENAME), parameter2.push(P_TERMINALFILENAME));
            }
        } else {
            this.numberOfTerminals = evolutionState.parameters.getInt(parameter.push(P_TERMINALSIZE), parameter2.push(P_TERMINALSIZE), 1);
        }
        this.numberOfSymbols += this.numberOfTerminals;
        if (this.numberOfSymbols < 1) {
            evolutionState.output.error("The GEPSymbolSet \"" + this.name + "\" have at least 1 terminal symbol defined.", parameter.push(P_TERMINALSIZE), parameter2.push(P_TERMINALSIZE));
        }
        if (gEPSpecies.useConstants) {
            ++this.numberOfTerminals;
            ++this.numberOfSymbols;
        }
        this.symbols = new GEPSymbol[this.numberOfSymbols];
        int n = this.numberOfSymbols;
        if (gEPSpecies.useConstants) {
            this.symbols[this.numberOfSymbols - 1] = new GEPConstantTerminalSymbol();
            this.symbols[this.numberOfSymbols - 1].id = this.numberOfSymbols - 1;
            --n;
        }
        object4 = parameter.push(P_TERMINAL);
        Parameter parameter3 = parameter2.push(P_TERMINAL);
        Parameter parameter4 = parameter.push(P_FUNCTION);
        Parameter parameter5 = parameter2.push(P_FUNCTION);
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
        int n2 = 0;
        while (n2 < this.numberOfFunctions) {
            Parameter parameter6 = parameter4.push("" + n2);
            object2 = evolutionState.parameters.getStringWithDefault(parameter6, (Parameter)(object3 = parameter5.push("" + n2)), "");
            if (((String)object2).equals("")) {
                evolutionState.output.fatal("Invalid function specifier: '" + (String)object2 + "'", parameter6, (Parameter)object3);
            }
            if (hashtable.get(object2) != null) {
                evolutionState.output.fatal("Function '" + (String)object2 + "' was specified more than once in list of function symbols");
            } else {
                hashtable.put(object2, object2);
            }
            serializable = null;
            try {
                Class<?> clazz = Class.forName("ec.gep.symbols." + (String)object2);
                serializable = (GEPFunctionSymbol)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                evolutionState.output.fatal("Unable to create GEPFunctionSymbol class for function '" + (String)object2 + "'. " + instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                evolutionState.output.fatal("Unable to create GEPFunctionSymbol class for function '" + (String)object2 + "' " + illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                evolutionState.output.fatal("Unable to create GEPFunctionSymbol class for function '" + (String)object2 + "' " + classNotFoundException);
            }
            if (((GEPFunctionSymbol)serializable).isLogicalFunction() && gEPSpecies.problemType != 2) {
                evolutionState.output.fatal("Can only use logical functions with a logical problem type. Function " + (String)object2 + " is  a logical function.", parameter6, (Parameter)object3);
            }
            if (!((GEPFunctionSymbol)serializable).isLogicalFunction() && gEPSpecies.problemType == 2) {
                evolutionState.output.fatal("Can only use logical functions with a non logical problem type. Function " + (String)object2 + " is a numerical function.", parameter6, (Parameter)object3);
            }
            this.symbols[n2] = serializable;
            if (((GEPFunctionSymbol)serializable).arity < 1) {
                evolutionState.output.fatal("Arity must be > 0 for a GEPTerminalSymbol)", parameter6, (Parameter)object3);
            }
            this.symbols[n2].id = n2;
            int n3 = evolutionState.parameters.getInt(parameter6.push(P_FUNCTIONWEIGHT), ((Parameter)object3).push(P_FUNCTIONWEIGHT), 1);
            if (n3 < 1) {
                evolutionState.output.warning("Weight for GEP Function must be > 0; defaulting to 1)", parameter6.push(P_FUNCTIONWEIGHT), ((Parameter)object3).push(P_FUNCTIONWEIGHT));
                n3 = 1;
            }
            this.symbols[n2].weight = n3;
            if (this.symbols[n2].arity > this.maxArity) {
                this.maxArity = this.symbols[n2].arity;
            }
            ++n2;
        }
        n2 = this.numberOfFunctions;
        while (n2 < n) {
            int n4 = n2 - this.numberOfFunctions;
            object3 = "";
            if (bl) {
                object3 = "v" + n4;
            } else if (csvReader == null) {
                object2 = ((Parameter)object4).push("" + n4);
                serializable = parameter3.push("" + n4);
                object3 = evolutionState.parameters.getStringWithDefault((Parameter)object2, (Parameter)serializable, "");
            } else {
                object3 = stringArray[n4];
            }
            if (((String)object3).equals("")) {
                evolutionState.output.fatal("Invalid terminal specifier: '" + (String)object3 + "' for terminal # " + n4);
            }
            if (hashtable2.get(object3) != null) {
                evolutionState.output.fatal("Terminal symbol (indep var) '" + (String)object3 + "' was specified more than once in list of terminal symbols (independent variables)");
            } else {
                hashtable2.put(object3, object3);
            }
            this.symbols[n2] = object2 = new GEPTerminalSymbol((String)object3, this);
            if (((GEPTerminalSymbol)object2).arity != 0) {
                evolutionState.output.fatal("Arity must be exactly 0 for a GEPTerminalSymbol)");
            }
            this.symbols[n2].id = n2;
            this.symbols[n2].weight = 1;
            ++n2;
        }
        if (this.numberOfTerminals < 1) {
            evolutionState.output.fatal("Must be at least one Terminal Symbol in the set of GEPSymbols\nEither did not specify the terminal symbols in the param file or\ndid not specify the appropriate data file with the terminals specified in the first line.");
        }
        this.terminals = new int[this.numberOfTerminals];
        n2 = 0;
        this.functions = new int[this.numberOfFunctions];
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.numberOfSymbols) {
            if (this.symbols[n6] instanceof GEPConstantTerminalSymbol) {
                this.terminals[n2++] = n6;
            } else if (this.symbols[n6] instanceof GEPTerminalSymbol) {
                this.terminals[n2++] = n6;
            } else if (this.symbols[n6] instanceof GEPFunctionSymbol) {
                this.functions[n5++] = n6;
            }
            ++n6;
        }
        this.cumulativeNormalizedSymbolWeights = new float[this.numberOfSymbols];
        this.cumulativeNormalizedTerminalWeights = new float[this.numberOfTerminals];
        this.cumulativeNormalizedFunctionWeights = new float[this.numberOfFunctions];
        n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.numberOfSymbols) {
            float f;
            this.cumulativeNormalizedSymbolWeights[n8] = f = (float)this.symbols[n8].weight;
            if (this.symbols[n8] instanceof GEPTerminalSymbol || this.symbols[n8] instanceof GEPConstantTerminalSymbol) {
                this.cumulativeNormalizedTerminalWeights[n6++] = f;
            }
            if (this.symbols[n8] instanceof GEPFunctionSymbol) {
                this.cumulativeNormalizedFunctionWeights[n7++] = f;
            }
            ++n8;
        }
        RandomChoice.organizeDistribution(this.cumulativeNormalizedSymbolWeights);
        RandomChoice.organizeDistribution(this.cumulativeNormalizedTerminalWeights);
        RandomChoice.organizeDistribution(this.cumulativeNormalizedFunctionWeights);
        this.probabilityOfChoosingFunction = this.numberOfFunctions < this.numberOfTerminals - (gEPSpecies.useConstants ? 1 : 0) ? 0.6666666666666666 : 0.5;
        if (bl) {
            GEPDependentVariable.symbol = "dependentVariable";
            object = null;
            object = csvReader == null ? ((GEPProblem)evolutionState.evaluator.p_problem).getTimeSeriesDataValues() : this.getRawTimeSeriesValuesFromCSVfile(evolutionState, csvReader);
            if (object == null) {
                evolutionState.output.fatal("Unable to get time series data values from User Program or CSV file");
            }
            Vector[] vectorArray = this.processRawTimeSeriesValues(evolutionState, gEPSpecies, (double[])object);
            int n9 = 0;
            while (n9 < vectorArray.length) {
                int n10 = vectorArray[n9].size() - gEPSpecies.timeseriesTestingPredictions;
                double[] dArray = new double[n10];
                double[] dArray2 = new double[gEPSpecies.timeseriesTestingPredictions];
                int n11 = 0;
                while (n11 < dArray.length) {
                    dArray[n11] = (Double)vectorArray[n9].elementAt(n11);
                    ++n11;
                }
                n11 = 0;
                while (n11 < dArray2.length) {
                    dArray2[n11] = (Double)vectorArray[n9].elementAt(n11 + n10);
                    ++n11;
                }
                n11 = n9 - vectorArray.length + gEPSpecies.numberOfChromosomes;
                if (n11 >= 0) {
                    GEPDependentVariable.trainingData.setValues(dArray, n11);
                    GEPDependentVariable.testingData.setValues(dArray2, n11);
                } else {
                    ((GEPTerminalSymbol)this.symbols[this.numberOfFunctions + n9]).setTrainingValues(dArray);
                    ((GEPTerminalSymbol)this.symbols[this.numberOfFunctions + n9]).setTestingValues(dArray2);
                }
                ++n9;
            }
        } else if (csvReader != null) {
            GEPDependentVariable.symbol = stringArray[stringArray.length - 1];
            object = new Vector[stringArray.length];
            int n12 = 0;
            while (n12 < stringArray.length) {
                object[n12] = (double)new Vector();
                ++n12;
            }
            try {
                while (csvReader.readRecord()) {
                    n12 = 0;
                    while (n12 < stringArray.length) {
                        ((Vector)object[n12]).add(csvReader.get(n12));
                        ++n12;
                    }
                }
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("The file with terminal definitions/values failed when reading records. " + iOException);
            }
            int n13 = 0;
            while (n13 < stringArray.length) {
                double[] dArray = new double[((Vector)object[n13]).size()];
                int n14 = 0;
                while (n14 < dArray.length) {
                    try {
                        dArray[n14] = Double.parseDouble((String)((Vector)object[n13]).elementAt(n14));
                    }
                    catch (Exception exception) {
                        evolutionState.output.fatal("Failed trying to read a training data set value. The field is supposed to be a number but was the string '" + (String)((Vector)object[n13]).elementAt(n14) + "'.\n" + exception);
                    }
                    ++n14;
                }
                n14 = stringArray.length - gEPSpecies.numberOfChromosomes;
                if (n13 >= n14) {
                    GEPDependentVariable.trainingData.setValues(dArray, n13 - n14);
                } else {
                    ((GEPTerminalSymbol)this.symbols[this.numberOfFunctions + n13]).setTrainingValues(dArray);
                }
                ++n13;
            }
            if (csvReader2 != null) {
                Vector[] vectorArray = new Vector[stringArray.length];
                int n15 = 0;
                while (n15 < stringArray.length) {
                    vectorArray[n15] = new Vector();
                    ++n15;
                }
                try {
                    while (csvReader2.readRecord()) {
                        n15 = 0;
                        while (n15 < stringArray.length) {
                            vectorArray[n15].add(csvReader2.get(n15));
                            ++n15;
                        }
                    }
                }
                catch (IOException iOException) {
                    evolutionState.output.fatal("The file with testing data values failed when reading records. \nMake sure the file has the same column separators as the testing data file.\nAlso check that it has the same as the number of columns as the testing file" + iOException);
                }
                int n16 = 0;
                while (n16 < stringArray.length) {
                    double[] dArray = new double[vectorArray[n16].size()];
                    int n17 = 0;
                    while (n17 < dArray.length) {
                        try {
                            dArray[n17] = Double.parseDouble((String)vectorArray[n16].elementAt(n17));
                        }
                        catch (Exception exception) {
                            evolutionState.output.fatal("Failed trying to read a testing data set value. The field is supposed to be a number but was the string '" + (String)vectorArray[n16].elementAt(n17) + "'.\n" + exception);
                        }
                        ++n17;
                    }
                    n17 = stringArray.length - gEPSpecies.numberOfChromosomes;
                    if (n16 >= n17) {
                        GEPDependentVariable.testingData.setValues(dArray, n16 - n17);
                    } else {
                        ((GEPTerminalSymbol)this.symbols[this.numberOfFunctions + n16]).setTestingValues(dArray);
                    }
                    ++n16;
                }
            }
        } else {
            Object object5;
            GEPDependentVariable.symbol = "dependentVariable";
            object = (GEPProblem)evolutionState.evaluator.p_problem;
            double[] dArray = null;
            int n18 = this.numberOfFunctions;
            while (n18 < n) {
                object5 = (GEPTerminalSymbol)this.symbols[n18];
                dArray = object.getDataValues(((GEPTerminalSymbol)object5).symbol);
                if (dArray == null) {
                    evolutionState.output.fatal("Expecting user problem (GEPProblem/ProblemForm) to supply training data values for terminal symbol '" + object5 + "'.");
                }
                ((GEPTerminalSymbol)object5).setTrainingValues(dArray);
                dArray = object.getTestingDataValues(((GEPTerminalSymbol)object5).symbol);
                if (dArray != null) {
                    ((GEPTerminalSymbol)object5).setTestingValues(dArray);
                }
                ++n18;
            }
            n18 = 0;
            while (n18 < gEPSpecies.numberOfChromosomes) {
                object5 = GEPDependentVariable.symbol;
                if (gEPSpecies.numberOfChromosomes > 1) {
                    object5 = String.valueOf(object5) + n18;
                }
                if ((dArray = object.getDataValues((String)object5)) == null) {
                    evolutionState.output.fatal("Expecting user problem (GEPProblem/ProblemForm) to supply training data values for dependent variable '" + (String)object5 + "'.");
                }
                GEPDependentVariable.trainingData.setValues(dArray, n18);
                dArray = object.getTestingDataValues((String)object5);
                if (dArray != null) {
                    GEPDependentVariable.testingData.setValues(dArray, n18);
                }
                ++n18;
            }
        }
        int n19 = GEPDependentVariable.trainingData.values[0].length;
        int n20 = this.numberOfFunctions;
        while (n20 < n) {
            if (((GEPTerminalSymbol)this.symbols[n20]).trainingValues.length != n19) {
                evolutionState.output.fatal("Must have same number of values for all independent variables and the dependent variable./nNumber of values for Dependent Variable is: " + n19 + "/nNumber of values for Independent Variable '" + this.symbols[n20].symbol + "' is: " + ((GEPTerminalSymbol)this.symbols[n20]).trainingValues.length);
            }
            ++n20;
        }
        if (gEPSpecies.problemType == 1 || gEPSpecies.problemType == 2) {
            double[] dArray = GEPDependentVariable.trainingData.values[0];
            int n21 = 0;
            while (n21 < n19) {
                if (dArray[n21] != 0.0 && dArray[n21] != 1.0) {
                    evolutionState.output.fatal("For classification/logical problems all dependent variable values must be either 1 or 0.\nFound value " + dArray[n21] + " at index " + n21 + "in the values.");
                }
                ++n21;
            }
        }
        if (gEPSpecies.problemType == 2) {
            int n22 = this.numberOfFunctions;
            while (n22 < n) {
                double[] dArray = ((GEPTerminalSymbol)this.symbols[n22]).trainingValues;
                int n23 = 0;
                while (n23 < n19) {
                    if (dArray[n23] != 0.0 && dArray[n23] != 1.0) {
                        evolutionState.output.fatal("For logical problems all independent variable values must be either 1 or 0.\nFound value " + dArray[n23] + " at index '" + n23 + "' in the variable '" + ((GEPTerminalSymbol)this.symbols[n22]).symbol + "'.");
                    }
                    ++n23;
                }
                ++n22;
            }
        }
        evolutionState.output.exitIfErrors();
    }

    public int getBaseTerminalSymbolId() {
        return this.numberOfFunctions;
    }

    public double[] getRawTimeSeriesValuesFromCSVfile(EvolutionState evolutionState, CsvReader csvReader) {
        Vector<String> vector = new Vector<String>(100);
        try {
            while (csvReader.readRecord()) {
                int n = 0;
                while (n < csvReader.getColumnCount()) {
                    vector.add(csvReader.get(n));
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            evolutionState.output.fatal("The file with time series raw values failed when reading records. " + iOException);
        }
        double[] dArray = new double[vector.size()];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Double.parseDouble((String)vector.elementAt(n));
            ++n;
        }
        return dArray;
    }

    public Vector[] processRawTimeSeriesValues(EvolutionState evolutionState, GEPSpecies gEPSpecies, double[] dArray) {
        int n = dArray.length;
        int n2 = gEPSpecies.timeseriesDelay;
        int n3 = gEPSpecies.timeseriesEmbeddingDimension + gEPSpecies.numberOfChromosomes;
        Vector[] vectorArray = new Vector[n3];
        int n4 = (n - n3 * n2 - 1) / n2 + 2;
        int n5 = 0;
        while (n5 < n3) {
            vectorArray[n5] = new Vector();
            vectorArray[n5].setSize(n4);
            ++n5;
        }
        n5 = n - 1;
        int n6 = n4 - 1;
        while (n6 >= 0) {
            int n7 = n3 - 1;
            int n8 = n5;
            while (n8 > n5 - n3 * n2) {
                vectorArray[n7].setElementAt(new Double(dArray[n8]), n6);
                n8 -= n2;
                --n7;
            }
            n5 -= n2;
            --n6;
        }
        return vectorArray;
    }

    public int chooseFunctionSymbol(EvolutionState evolutionState, int n) {
        int n2 = RandomChoice.pickFromDistribution(this.cumulativeNormalizedFunctionWeights, evolutionState.random[n].nextFloat(), 8);
        return this.functions[n2];
    }

    public int chooseTerminalSymbol(EvolutionState evolutionState, int n) {
        int n2 = RandomChoice.pickFromDistribution(this.cumulativeNormalizedTerminalWeights, evolutionState.random[n].nextFloat(), 8);
        return this.terminals[n2];
    }

    public int chooseFunctionOrTerminalSymbol(EvolutionState evolutionState, int n, int n2, GEPSpecies gEPSpecies) {
        if (n2 < gEPSpecies.headSize) {
            if ((double)evolutionState.random[n].nextFloat() < this.probabilityOfChoosingFunction) {
                return this.chooseFunctionSymbol(evolutionState, n);
            }
            return this.chooseTerminalSymbol(evolutionState, n);
        }
        return this.chooseTerminalSymbol(evolutionState, n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

