/*
 * Decompiled with CFR 0.152.
 */
package ec.gep.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gep.GEPBreedingPipeline;
import ec.gep.GEPChromosome;
import ec.gep.GEPDefaults;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;

public class GenetranspositionPipeline
extends GEPBreedingPipeline {
    public static final int NUM_SOURCES = 1;
    public static final String P_GENETRANSPOSITION_PIPE = "genetransposition";

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_GENETRANSPOSITION_PIPE);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        GenetranspositionPipeline genetranspositionPipeline = (GenetranspositionPipeline)super.clone();
        return genetranspositionPipeline;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6 = this.sources[0].produce(n2, n2, n3, n4, individualArray, evolutionState, n5);
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            int n7 = n3;
            while (n7 < n6 + n3) {
                individualArray[n7] = (Individual)individualArray[n7].clone();
                ++n7;
            }
        }
        GEPSpecies gEPSpecies = (GEPSpecies)individualArray[0].species;
        MersenneTwisterFast mersenneTwisterFast = evolutionState.random[n5];
        int n8 = (int)Math.round(gEPSpecies.geneTranspositionProbability * (double)n6);
        int n9 = 0;
        while (n9 < n8) {
            int n10 = mersenneTwisterFast.nextInt(n6);
            GEPIndividual gEPIndividual = (GEPIndividual)individualArray[n10];
            int n11 = gEPIndividual.chromosomes.length;
            int n12 = 0;
            while (n12 < n11) {
                GEPChromosome gEPChromosome = gEPIndividual.chromosomes[n12];
                this.geneTranspose(gEPChromosome.genome, mersenneTwisterFast);
                gEPChromosome.parsedGeneExpressions = null;
                ++n12;
            }
            gEPIndividual.evaluated = false;
            gEPIndividual.chromosomesParsed = false;
            ++n9;
        }
        return n6;
    }

    public void geneTranspose(int[][] nArray, MersenneTwisterFast mersenneTwisterFast) {
        if (nArray.length > 1) {
            int n = mersenneTwisterFast.nextInt(nArray.length - 1) + 1;
            int[] nArray2 = nArray[0];
            nArray[0] = nArray[n];
            nArray[n] = nArray2;
        }
    }
}

