/*
 * Decompiled with CFR 0.152.
 */
package ec.gep.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gep.GEPBreedingPipeline;
import ec.gep.GEPChromosome;
import ec.gep.GEPDefaults;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;

public class IStranspositionPipeline
extends GEPBreedingPipeline {
    public static final int NUM_SOURCES = 1;
    public static final String P_ISTRANSPOSITION_PIPE = "IStransposition";

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_ISTRANSPOSITION_PIPE);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        IStranspositionPipeline iStranspositionPipeline = (IStranspositionPipeline)super.clone();
        return iStranspositionPipeline;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6 = this.sources[0].produce(n2, n2, n3, n4, individualArray, evolutionState, n5);
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            int n7 = n3;
            while (n7 < n6 + n3) {
                individualArray[n7] = (Individual)individualArray[n7].clone();
                ++n7;
            }
        }
        GEPSpecies gEPSpecies = (GEPSpecies)individualArray[0].species;
        MersenneTwisterFast mersenneTwisterFast = evolutionState.random[n5];
        int n8 = (int)Math.round(gEPSpecies.isTranspositionProbability * (double)n6);
        try {
            int n9 = 0;
            while (n9 < n8) {
                int n10 = mersenneTwisterFast.nextInt(n6);
                GEPIndividual gEPIndividual = (GEPIndividual)individualArray[n10];
                int n11 = gEPIndividual.chromosomes.length;
                int n12 = 0;
                while (n12 < n11) {
                    GEPChromosome gEPChromosome = gEPIndividual.chromosomes[n12];
                    this.isTranspose(gEPChromosome.genome, mersenneTwisterFast, gEPSpecies.headSize, gEPSpecies.geneSize);
                    gEPChromosome.parsedGeneExpressions = null;
                    ++n12;
                }
                gEPIndividual.evaluated = false;
                gEPIndividual.chromosomesParsed = false;
                ++n9;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n6;
    }

    public void isTranspose(int[][] nArray, MersenneTwisterFast mersenneTwisterFast, int n, int n2) {
        try {
            int n3 = mersenneTwisterFast.nextInt(nArray.length);
            int[] nArray2 = nArray[n3];
            int n4 = mersenneTwisterFast.nextInt(n2);
            if (n <= 1) {
                return;
            }
            int n5 = mersenneTwisterFast.nextInt(n - 1 < nArray2.length - n4 ? n - 1 : nArray2.length - n4) + 1;
            n3 = mersenneTwisterFast.nextInt(nArray.length);
            int[] nArray3 = nArray[n3];
            int n6 = mersenneTwisterFast.nextInt(n - n5);
            int[] nArray4 = new int[n5];
            int n7 = 0;
            while (n7 < n5) {
                nArray4[n7] = nArray2[n4 + n7];
                ++n7;
            }
            n7 = n - n5 - 1;
            while (n7 > n6) {
                nArray3[n7 + n5] = nArray3[n7];
                --n7;
            }
            n7 = 0;
            while (n7 < n5) {
                nArray3[n7 + n6 + 1] = nArray4[n7];
                ++n7;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

