/*
 * Decompiled with CFR 0.152.
 */
package ec.gep.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gep.GEPBreedingPipeline;
import ec.gep.GEPChromosome;
import ec.gep.GEPDefaults;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;

public class InversionPipeline
extends GEPBreedingPipeline {
    public static final int NUM_SOURCES = 1;
    public static final String P_INVERSION_PIPE = "inversion";

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_INVERSION_PIPE);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        InversionPipeline inversionPipeline = (InversionPipeline)super.clone();
        return inversionPipeline;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6 = this.sources[0].produce(n2, n2, n3, n4, individualArray, evolutionState, n5);
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            int n7 = n3;
            while (n7 < n6 + n3) {
                individualArray[n7] = (Individual)individualArray[n7].clone();
                ++n7;
            }
        }
        GEPSpecies gEPSpecies = (GEPSpecies)individualArray[0].species;
        int n8 = gEPSpecies.headSize;
        MersenneTwisterFast mersenneTwisterFast = evolutionState.random[n5];
        int n9 = (int)Math.round(gEPSpecies.inversionProbability * (double)n6);
        int n10 = 0;
        while (n10 < n9) {
            int n11 = mersenneTwisterFast.nextInt(n6);
            GEPIndividual gEPIndividual = (GEPIndividual)individualArray[n11];
            int n12 = gEPIndividual.chromosomes.length;
            int n13 = 0;
            while (n13 < n12) {
                GEPChromosome gEPChromosome = gEPIndividual.chromosomes[n13];
                this.invert(gEPChromosome.genome, mersenneTwisterFast, n8);
                gEPChromosome.parsedGeneExpressions = null;
                ++n13;
            }
            gEPIndividual.evaluated = false;
            gEPIndividual.chromosomesParsed = false;
            ++n10;
        }
        return n6;
    }

    public void invert(int[][] nArray, MersenneTwisterFast mersenneTwisterFast, int n) {
        try {
            int n2 = mersenneTwisterFast.nextInt(nArray.length);
            int[] nArray2 = nArray[n2];
            if (n > 2) {
                int n3 = mersenneTwisterFast.nextInt(n - 1);
                int n4 = mersenneTwisterFast.nextInt(n - n3 - 1) + n3 + 1;
                int[] nArray3 = new int[n4 - n3 + 1];
                int n5 = 0;
                while (n5 < nArray3.length) {
                    nArray3[n5] = nArray2[n5 + n3];
                    ++n5;
                }
                n5 = 0;
                while (n5 < nArray3.length) {
                    nArray2[n4 - n5] = nArray3[n5];
                    ++n5;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

