/*
 * Decompiled with CFR 0.152.
 */
package ec.gep.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gep.GEPBreedingPipeline;
import ec.gep.GEPChromosome;
import ec.gep.GEPDefaults;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;

public class MutationPipeline
extends GEPBreedingPipeline {
    public static final int NUM_SOURCES = 1;
    public static final String P_MUTATION_PIPE = "mutation";

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_MUTATION_PIPE);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        MutationPipeline mutationPipeline = (MutationPipeline)super.clone();
        return mutationPipeline;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6 = this.sources[0].produce(n2, n2, n3, n4, individualArray, evolutionState, n5);
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            int n7 = n3;
            while (n7 < n6 + n3) {
                individualArray[n7] = (Individual)individualArray[n7].clone();
                ++n7;
            }
        }
        MersenneTwisterFast mersenneTwisterFast = evolutionState.random[n5];
        GEPSpecies gEPSpecies = (GEPSpecies)individualArray[n3].species;
        int n8 = (int)Math.round((double)(n6 * gEPSpecies.geneSize * gEPSpecies.numberOfGenes) * gEPSpecies.mutationProbability);
        int n9 = 0;
        while (n9 < n8) {
            try {
                GEPIndividual gEPIndividual = (GEPIndividual)individualArray[mersenneTwisterFast.nextInt(n6)];
                int n10 = gEPIndividual.chromosomes.length;
                int n11 = 0;
                while (n11 < n10) {
                    GEPChromosome gEPChromosome = gEPIndividual.chromosomes[n11];
                    int[][] nArray = gEPChromosome.genome;
                    int[] nArray2 = nArray[mersenneTwisterFast.nextInt(gEPSpecies.numberOfGenes)];
                    int n12 = mersenneTwisterFast.nextInt(nArray2.length);
                    nArray2[n12] = gEPSpecies.symbolSet.chooseFunctionOrTerminalSymbol(evolutionState, n5, n12, gEPSpecies);
                    gEPChromosome.parsedGeneExpressions = null;
                    ++n11;
                }
                gEPIndividual.evaluated = false;
                gEPIndividual.chromosomesParsed = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n9;
        }
        return n6;
    }
}

