/*
 * Decompiled with CFR 0.152.
 */
package ec.gep.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gep.GEPBreedingPipeline;
import ec.gep.GEPChromosome;
import ec.gep.GEPDefaults;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;

public class OnepointrecombinationPipeline
extends GEPBreedingPipeline {
    public static final int NUM_SOURCES = 1;
    public static final String P_ONEPOINTRECOMBINATION_PIPE = "onepointrecombination";

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_ONEPOINTRECOMBINATION_PIPE);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        OnepointrecombinationPipeline onepointrecombinationPipeline = (OnepointrecombinationPipeline)super.clone();
        return onepointrecombinationPipeline;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6 = this.sources[0].produce(n2, n2, n3, n4, individualArray, evolutionState, n5);
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            int n7 = n3;
            while (n7 < n6 + n3) {
                individualArray[n7] = (Individual)individualArray[n7].clone();
                ++n7;
            }
        }
        GEPSpecies gEPSpecies = (GEPSpecies)individualArray[0].species;
        MersenneTwisterFast mersenneTwisterFast = evolutionState.random[n5];
        int n8 = (int)Math.round(gEPSpecies.onePointRecombinationProbability * (double)n6);
        n8 = n8 / 2 * 2;
        int[] nArray = this.chooseWithoutReplacement(evolutionState, n5, n8, n6);
        try {
            int n9 = 0;
            while (n9 < nArray.length - 1) {
                int n10 = nArray[n9];
                int n11 = nArray[n9 + 1];
                GEPIndividual gEPIndividual = (GEPIndividual)individualArray[n10];
                GEPIndividual gEPIndividual2 = (GEPIndividual)individualArray[n11];
                int n12 = gEPIndividual.chromosomes.length;
                int n13 = 0;
                while (n13 < n12) {
                    GEPChromosome gEPChromosome = gEPIndividual.chromosomes[n13];
                    GEPChromosome gEPChromosome2 = gEPIndividual2.chromosomes[n13];
                    this.onepointRecombine(evolutionState, n5, gEPSpecies, mersenneTwisterFast, gEPChromosome, gEPChromosome2);
                    gEPChromosome.parsedGeneExpressions = null;
                    gEPChromosome2.parsedGeneExpressions = null;
                    ++n13;
                }
                gEPIndividual.evaluated = false;
                gEPIndividual.chromosomesParsed = false;
                gEPIndividual2.evaluated = false;
                gEPIndividual2.chromosomesParsed = false;
                n9 += 2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n6;
    }

    public void onepointRecombine(EvolutionState evolutionState, int n, GEPSpecies gEPSpecies, MersenneTwisterFast mersenneTwisterFast, GEPChromosome gEPChromosome, GEPChromosome gEPChromosome2) {
        int[][] nArray = gEPChromosome.genome;
        int[][] nArray2 = gEPChromosome2.genome;
        try {
            int n2 = mersenneTwisterFast.nextInt(gEPSpecies.geneSize * gEPSpecies.numberOfGenes - 1);
            int n3 = n2 + 1;
            int[] nArray3 = new int[n3];
            int[] nArray4 = new int[n3];
            this.copyFromGenome(nArray, 0, 0, n3, nArray3);
            this.copyFromGenome(nArray2, 0, 0, n3, nArray4);
            this.copyToGenome(nArray, 0, 0, n3, nArray4);
            this.copyToGenome(nArray2, 0, 0, n3, nArray3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void copyFromGenome(int[][] nArray, int n, int n2, int n3, int[] nArray2) {
        int[] nArray3 = nArray[n];
        int n4 = nArray3.length;
        int n5 = n2;
        int n6 = 0;
        while (n6 < n3) {
            nArray2[n6] = nArray3[n5];
            if (++n5 >= n4) {
                n5 = 0;
                nArray3 = nArray[++n];
            }
            ++n6;
        }
    }

    private void copyToGenome(int[][] nArray, int n, int n2, int n3, int[] nArray2) {
        int[] nArray3 = nArray[n];
        int n4 = nArray3.length;
        int n5 = n2;
        int n6 = 0;
        while (n6 < n3) {
            nArray3[n5] = nArray2[n6];
            if (++n5 >= n4) {
                n5 = 0;
                nArray3 = nArray[++n];
            }
            ++n6;
        }
    }
}

