/*
 * Decompiled with CFR 0.152.
 */
package ec.gep.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gep.GEPBreedingPipeline;
import ec.gep.GEPChromosome;
import ec.gep.GEPDefaults;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.gep.GEPTerminalSymbol;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;

public class RIStranspositionPipeline
extends GEPBreedingPipeline {
    public static final int NUM_SOURCES = 1;
    public static final String P_RISTRANSPOSITION_PIPE = "RIStransposition";

    public Parameter defaultBase() {
        return GEPDefaults.base().push(P_RISTRANSPOSITION_PIPE);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        RIStranspositionPipeline rIStranspositionPipeline = (RIStranspositionPipeline)super.clone();
        return rIStranspositionPipeline;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6 = this.sources[0].produce(n2, n2, n3, n4, individualArray, evolutionState, n5);
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            int n7 = n3;
            while (n7 < n6 + n3) {
                individualArray[n7] = (Individual)individualArray[n7].clone();
                ++n7;
            }
        }
        GEPSpecies gEPSpecies = (GEPSpecies)individualArray[0].species;
        MersenneTwisterFast mersenneTwisterFast = evolutionState.random[n5];
        int n8 = (int)Math.round(gEPSpecies.risTranspositionProbability * (double)n6);
        try {
            int n9 = 0;
            while (n9 < n8) {
                int n10 = mersenneTwisterFast.nextInt(n6);
                GEPIndividual gEPIndividual = (GEPIndividual)individualArray[n10];
                int n11 = gEPIndividual.chromosomes.length;
                int n12 = 0;
                while (n12 < n11) {
                    GEPChromosome gEPChromosome = gEPIndividual.chromosomes[n12];
                    this.risTranspose(gEPChromosome.genome, mersenneTwisterFast, gEPSpecies);
                    gEPChromosome.parsedGeneExpressions = null;
                    ++n12;
                }
                gEPIndividual.evaluated = false;
                gEPIndividual.chromosomesParsed = false;
                ++n9;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n6;
    }

    public void risTranspose(int[][] nArray, MersenneTwisterFast mersenneTwisterFast, GEPSpecies gEPSpecies) {
        try {
            int n = gEPSpecies.headSize;
            int n2 = mersenneTwisterFast.nextInt(nArray.length);
            int[] nArray2 = nArray[n2];
            int n3 = mersenneTwisterFast.nextInt(n);
            while (n3 < n && gEPSpecies.symbolSet.symbols[nArray2[n3]] instanceof GEPTerminalSymbol) {
                ++n3;
            }
            if (n3 >= n) {
                return;
            }
            int n4 = mersenneTwisterFast.nextInt(n < nArray2.length - n3 ? n : nArray2.length - n3) + 1;
            n2 = mersenneTwisterFast.nextInt(nArray.length);
            int[] nArray3 = nArray[n2];
            int[] nArray4 = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                nArray4[n5] = nArray2[n3 + n5];
                ++n5;
            }
            n5 = n - n4 - 1;
            while (n5 >= 0) {
                nArray3[n5 + n4] = nArray3[n5];
                --n5;
            }
            n5 = 0;
            while (n5 < n4) {
                nArray3[n5] = nArray4[n5];
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

