/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.RandomChoice;
import ec.util.SortComparatorL;

public class BestSelection
extends SelectionMethod {
    public static final String P_BEST = "best";
    public static final String P_N = "n";
    public static final String P_PICKWORST = "pick-worst";
    public float[] sortedFit;
    public int[] sortedPop;
    public boolean pickWorst;
    public int bestn;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_BEST);
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = this.defaultBase();
        this.bestn = evolutionState.parameters.getInt(parameter.push(P_N), parameter2.push(P_N), 1);
        if (this.bestn == 0) {
            evolutionState.output.fatal("n must be an integer greater than 0", parameter.push(P_N), parameter2.push(P_N));
        }
        this.pickWorst = evolutionState.parameters.getBoolean(parameter.push(P_PICKWORST), parameter2.push(P_PICKWORST), false);
    }

    public void prepareToProduce(EvolutionState evolutionState, int n, int n2) {
        final Individual[] individualArray = evolutionState.population.subpops[n].individuals;
        this.sortedPop = new int[individualArray.length];
        int n3 = 0;
        while (n3 < this.sortedPop.length) {
            this.sortedPop[n3] = n3;
            ++n3;
        }
        QuickSort.qsort(this.sortedPop, new SortComparatorL(){

            public boolean lt(long l, long l2) {
                return individualArray[(int)l2].fitness.betterThan(individualArray[(int)l].fitness);
            }

            public boolean gt(long l, long l2) {
                return individualArray[(int)l].fitness.betterThan(individualArray[(int)l2].fitness);
            }
        });
        this.sortedFit = new float[Math.min(this.sortedPop.length, this.bestn)];
        if (this.pickWorst) {
            n3 = 0;
            while (n3 < this.sortedFit.length) {
                this.sortedFit[n3] = individualArray[this.sortedPop[n3]].fitness.fitness();
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.sortedFit.length) {
                this.sortedFit[n3] = individualArray[this.sortedPop[this.sortedPop.length - n3 - 1]].fitness.fitness();
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < this.sortedFit.length) {
            if (this.sortedFit[n3] < 0.0f) {
                evolutionState.output.fatal("Discovered a negative fitness value.  BestSelection requires that all fitness values be non-negative(offending subpopulation #" + n + ")");
            }
            ++n3;
        }
        RandomChoice.organizeDistribution(this.sortedFit, true);
    }

    public int produce(int n, EvolutionState evolutionState, int n2) {
        if (this.pickWorst) {
            return this.sortedPop[RandomChoice.pickFromDistribution(this.sortedFit, evolutionState.random[n2].nextFloat(), 8)];
        }
        return this.sortedPop[this.sortedPop.length - RandomChoice.pickFromDistribution(this.sortedFit, evolutionState.random[n2].nextFloat(), 8) - 1];
    }

    public void finishProducing(EvolutionState evolutionState, int n, int n2) {
        this.sortedFit = null;
        this.sortedPop = null;
    }
}

