/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import ec.util.RandomChoice;

public class FitProportionateSelection
extends SelectionMethod {
    public static final String P_FITNESSPROPORTIONATE = "fitness-proportionate";
    public float[] sortedFit;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_FITNESSPROPORTIONATE);
    }

    public void prepareToProduce(EvolutionState evolutionState, int n, int n2) {
        this.sortedFit = new float[evolutionState.population.subpops[n].individuals.length];
        int n3 = 0;
        while (n3 < this.sortedFit.length) {
            this.sortedFit[n3] = evolutionState.population.subpops[n].individuals[n3].fitness.fitness();
            if (this.sortedFit[n3] < 0.0f) {
                evolutionState.output.fatal("Discovered a negative fitness value.  FitProportionateSelection requires that all fitness values be non-negative(offending subpopulation #" + n + ")");
            }
            ++n3;
        }
        RandomChoice.organizeDistribution(this.sortedFit, true);
    }

    public int produce(int n, EvolutionState evolutionState, int n2) {
        return RandomChoice.pickFromDistribution(this.sortedFit, evolutionState.random[n2].nextFloat(), 8);
    }

    public void finishProducing(EvolutionState evolutionState, int n, int n2) {
        this.sortedFit = null;
    }
}

