/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.RandomChoice;
import ec.util.SortComparatorL;

public class GreedyOverselection
extends SelectionMethod {
    public float[] sortedFitOver;
    public float[] sortedFitUnder;
    public int[] sortedPop;
    public static final String P_GREEDY = "greedy";
    public static final String P_TOP = "top";
    public static final String P_GETS = "gets";
    public float top_n_percent;
    public float gets_n_percent;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_GREEDY);
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = this.defaultBase();
        this.top_n_percent = evolutionState.parameters.getFloat(parameter.push(P_TOP), parameter2.push(P_TOP), 0.0, 1.0);
        if ((double)this.top_n_percent < 0.0) {
            evolutionState.output.fatal("Top-n-percent must be between 0.0 and 1.0", parameter.push(P_TOP), parameter2.push(P_TOP));
        }
        this.gets_n_percent = evolutionState.parameters.getFloat(parameter.push(P_GETS), parameter2.push(P_GETS), 0.0, 1.0);
        if ((double)this.gets_n_percent < 0.0) {
            evolutionState.output.fatal("Gets-n-percent must be between 0.0 and 1.0", parameter.push(P_GETS), parameter2.push(P_GETS));
        }
    }

    public void prepareToProduce(EvolutionState evolutionState, int n, int n2) {
        final Individual[] individualArray = evolutionState.population.subpops[n].individuals;
        this.sortedPop = new int[individualArray.length];
        int n3 = 0;
        while (n3 < this.sortedPop.length) {
            this.sortedPop[n3] = n3;
            ++n3;
        }
        QuickSort.qsort(this.sortedPop, new SortComparatorL(){

            public boolean lt(long l, long l2) {
                return individualArray[(int)l2].fitness.betterThan(individualArray[(int)l].fitness);
            }

            public boolean gt(long l, long l2) {
                return individualArray[(int)l].fitness.betterThan(individualArray[(int)l2].fitness);
            }
        });
        n3 = (int)((float)this.sortedPop.length * this.top_n_percent);
        if (n3 == 0) {
            n3 = 1;
        }
        if (n3 == this.sortedPop.length) {
            n3 = this.sortedPop.length - 1;
        }
        if (n3 == 0) {
            evolutionState.output.fatal("Greedy Overselection can only be done with a population of size 2 or more (offending subpopulation #" + n + ")");
        }
        this.sortedFitOver = new float[n3];
        int n4 = 0;
        int n5 = this.sortedPop.length - n3;
        while (n5 < this.sortedPop.length) {
            this.sortedFitOver[n4] = individualArray[this.sortedPop[n5]].fitness.fitness();
            if (this.sortedFitOver[n4] < 0.0f) {
                evolutionState.output.fatal("Discovered a negative fitness value.  Greedy Overselection requires that all fitness values be non-negative (offending subpopulation #" + n + ")");
            }
            ++n4;
            ++n5;
        }
        this.sortedFitUnder = new float[this.sortedPop.length - n3];
        n4 = 0;
        n5 = 0;
        while (n5 < this.sortedPop.length - n3) {
            this.sortedFitUnder[n4] = individualArray[this.sortedPop[n5]].fitness.fitness();
            if (this.sortedFitUnder[n4] < 0.0f) {
                evolutionState.output.fatal("Discovered a negative fitness value.  Greedy Overselection requires that all fitness values be non-negative (offending subpopulation #" + n + ")");
            }
            ++n4;
            ++n5;
        }
        RandomChoice.organizeDistribution(this.sortedFitUnder, true);
        RandomChoice.organizeDistribution(this.sortedFitOver, true);
    }

    public int produce(int n, EvolutionState evolutionState, int n2) {
        if (evolutionState.random[n2].nextBoolean(this.gets_n_percent)) {
            return this.sortedPop[this.sortedFitUnder.length + RandomChoice.pickFromDistribution(this.sortedFitOver, evolutionState.random[n2].nextFloat(), 8)];
        }
        return this.sortedPop[RandomChoice.pickFromDistribution(this.sortedFitUnder, evolutionState.random[n2].nextFloat(), 8)];
    }

    public void finishProducing(EvolutionState evolutionState, int n, int n2) {
        this.sortedFitUnder = null;
        this.sortedFitOver = null;
        this.sortedPop = null;
    }
}

