/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;

public class MultiSelection
extends SelectionMethod {
    public static final String P_NUMSELECTS = "num-selects";
    public static final String P_SELECT = "select";
    public static final String P_MULTISELECT = "multiselect";
    public SelectionMethod[] selects;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_MULTISELECT);
    }

    public Object clone() {
        MultiSelection multiSelection = (MultiSelection)super.clone();
        multiSelection.selects = new SelectionMethod[this.selects.length];
        int n = 0;
        while (n < this.selects.length) {
            multiSelection.selects[n] = (SelectionMethod)this.selects[n].clone();
            ++n;
        }
        return multiSelection;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = this.defaultBase();
        int n = evolutionState.parameters.getInt(parameter.push(P_NUMSELECTS), parameter2.push(P_NUMSELECTS), 1);
        if (n == 0) {
            evolutionState.output.fatal("The number of MultiSelection sub-selection methods must be >= 1).", parameter.push(P_NUMSELECTS), parameter2.push(P_NUMSELECTS));
        }
        this.selects = new SelectionMethod[n];
        float f = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter3 = parameter.push(P_SELECT).push("" + n2);
            Parameter parameter4 = parameter2.push(P_SELECT).push("" + n2);
            this.selects[n2] = (SelectionMethod)evolutionState.parameters.getInstanceForParameter(parameter3, parameter4, SelectionMethod.class);
            this.selects[n2].setup(evolutionState, parameter3);
            if ((double)this.selects[n2].probability < 0.0) {
                evolutionState.output.error("MultiSelection select #" + n2 + " must have a probability >= 0.0", parameter3.push("prob"), parameter4.push("prob"));
            } else {
                f += this.selects[n2].probability;
            }
            ++n2;
        }
        evolutionState.output.exitIfErrors();
        if ((double)f <= 0.0) {
            evolutionState.output.fatal("MultiSelection selects do not sum to a positive probability", parameter);
        }
        if ((double)f != 1.0) {
            evolutionState.output.message("Must normalize probabilities for " + parameter);
            n2 = 0;
            while (n2 < n) {
                this.selects[n2].probability /= f;
                ++n2;
            }
        }
        float f2 = 0.0f;
        int n3 = 0;
        while (n3 < n - 1) {
            this.selects[n3].probability = f2 += this.selects[n3].probability;
            ++n3;
        }
        this.selects[n - 1].probability = 1.0f;
    }

    public boolean produces(EvolutionState evolutionState, Population population, int n, int n2) {
        if (!super.produces(evolutionState, population, n, n2)) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.selects.length) {
            if (!this.selects[n3].produces(evolutionState, population, n, n2)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void prepareToProduce(EvolutionState evolutionState, int n, int n2) {
        int n3 = 0;
        while (n3 < this.selects.length) {
            this.selects[n3].prepareToProduce(evolutionState, n, n2);
            ++n3;
        }
    }

    public int produce(int n, EvolutionState evolutionState, int n2) {
        return this.selects[BreedingSource.pickRandom(this.selects, evolutionState.random[n2].nextFloat())].produce(n, evolutionState, n2);
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        return this.selects[BreedingSource.pickRandom(this.selects, evolutionState.random[n5].nextFloat())].produce(n, n2, n3, n4, individualArray, evolutionState, n5);
    }
}

