/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;

public class TournamentSelection
extends SelectionMethod
implements SteadyStateBSourceForm {
    public static final String P_TOURNAMENT = "tournament";
    public static final String P_PICKWORST = "pick-worst";
    public static final String P_SIZE = "size";
    public static final int DEFAULT_SIZE = 7;
    public int size;
    public double probabilityOfSelection;
    public boolean pickWorst;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_TOURNAMENT);
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = this.defaultBase();
        double d = evolutionState.parameters.getDouble(parameter.push(P_SIZE), parameter2.push(P_SIZE), 1.0);
        if (d < 1.0) {
            evolutionState.output.fatal("Tournament size must be >= 1.", parameter.push(P_SIZE), parameter2.push(P_SIZE));
        } else if (d > 1.0 && d < 2.0) {
            this.size = 2;
            this.probabilityOfSelection = d / 2.0;
        } else if (d != (double)((int)d)) {
            evolutionState.output.fatal("If >= 2, Tournament size must be an integer.", parameter.push(P_SIZE), parameter2.push(P_SIZE));
        } else {
            this.size = (int)d;
            this.probabilityOfSelection = 1.0;
        }
        this.pickWorst = evolutionState.parameters.getBoolean(parameter.push(P_PICKWORST), parameter2.push(P_PICKWORST), false);
    }

    public int produce(int n, EvolutionState evolutionState, int n2) {
        int n3;
        Individual[] individualArray = evolutionState.population.subpops[n].individuals;
        int n4 = n3 = evolutionState.random[n2].nextInt(individualArray.length);
        int n5 = 1;
        while (n5 < this.size) {
            int n6 = evolutionState.random[n2].nextInt(individualArray.length);
            if (this.pickWorst) {
                if (!individualArray[n6].fitness.betterThan(individualArray[n3].fitness)) {
                    n4 = n3;
                    n3 = n6;
                } else {
                    n4 = n6;
                }
            } else if (individualArray[n6].fitness.betterThan(individualArray[n3].fitness)) {
                n4 = n3;
                n3 = n6;
            } else {
                n4 = n6;
            }
            ++n5;
        }
        if (this.probabilityOfSelection != 1.0 && !evolutionState.random[n2].nextBoolean(this.probabilityOfSelection)) {
            n3 = n4;
        }
        return n3;
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6 = 1;
        if (n6 > n2) {
            n6 = n2;
        }
        if (n6 < n) {
            n6 = n;
        }
        int n7 = 0;
        while (n7 < n6) {
            int n8;
            Individual[] individualArray2 = evolutionState.population.subpops[n4].individuals;
            int n9 = n8 = evolutionState.random[n5].nextInt(individualArray2.length);
            int n10 = 1;
            while (n10 < this.size) {
                int n11 = evolutionState.random[n5].nextInt(individualArray2.length);
                if (this.pickWorst) {
                    if (!individualArray2[n11].fitness.betterThan(individualArray2[n8].fitness)) {
                        n9 = n8;
                        n8 = n11;
                    } else {
                        n9 = n11;
                    }
                } else if (individualArray2[n11].fitness.betterThan(individualArray2[n8].fitness)) {
                    n9 = n8;
                    n8 = n11;
                } else {
                    n9 = n11;
                }
                ++n10;
            }
            if (this.probabilityOfSelection != 1.0 && !evolutionState.random[n5].nextBoolean(this.probabilityOfSelection)) {
                n8 = n9;
            }
            individualArray[n3 + n7] = individualArray2[n8];
            ++n7;
        }
        return n6;
    }

    public void individualReplaced(SteadyStateEvolutionState steadyStateEvolutionState, int n, int n2, int n3) {
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState steadyStateEvolutionState) {
    }
}

