/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.Breeder;
import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.simple.SimpleBreederThread;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparatorL;

public class SimpleBreeder
extends Breeder {
    public static final String P_ELITE = "elite";
    public int[] elite;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        Parameter parameter2 = new Parameter("pop").push("subpops");
        int n = evolutionState.parameters.getInt(parameter2, null, 1);
        this.elite = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.elite[n2] = evolutionState.parameters.getIntWithDefault(parameter.push(P_ELITE).push("" + n2), null, 0);
            if (this.elite[n2] < 0) {
                evolutionState.output.error("The number of elites for subpopulation " + n2 + " must be >= 0", parameter.push(P_ELITE).push("" + n2));
            }
            ++n2;
        }
        evolutionState.output.exitIfErrors();
    }

    public int computeSubpopulationLength(EvolutionState evolutionState, int n) {
        return evolutionState.population.subpops[n].individuals.length - this.elite[n];
    }

    public Population breedPopulation(EvolutionState evolutionState) {
        int n;
        int[][] nArray = new int[evolutionState.breedthreads][evolutionState.population.subpops.length];
        int[][] nArray2 = new int[evolutionState.breedthreads][evolutionState.population.subpops.length];
        Population population = (Population)evolutionState.population.emptyClone();
        this.loadElites(evolutionState, population);
        int n2 = 0;
        while (n2 < evolutionState.breedthreads) {
            n = 0;
            while (n < evolutionState.population.subpops.length) {
                int n3 = this.computeSubpopulationLength(evolutionState, n);
                int n4 = n3 / evolutionState.breedthreads;
                int n5 = n4 + n3 - n4 * evolutionState.breedthreads;
                nArray[n2][n] = n2 < evolutionState.breedthreads - 1 ? n4 : n5;
                nArray2[n2][n] = n4 * n2;
                ++n;
            }
            ++n2;
        }
        if (evolutionState.breedthreads == 1) {
            this.breedPopChunk(population, evolutionState, nArray[0], nArray2[0], 0);
        } else {
            Thread[] threadArray = new Thread[evolutionState.breedthreads];
            n = 0;
            while (n < evolutionState.breedthreads) {
                SimpleBreederThread simpleBreederThread = new SimpleBreederThread();
                simpleBreederThread.threadnum = n;
                simpleBreederThread.newpop = population;
                simpleBreederThread.numinds = nArray[n];
                simpleBreederThread.from = nArray2[n];
                simpleBreederThread.me = this;
                simpleBreederThread.state = evolutionState;
                threadArray[n] = new Thread(simpleBreederThread);
                threadArray[n].start();
                ++n;
            }
            n = 0;
            while (n < evolutionState.breedthreads) {
                try {
                    threadArray[n].join();
                }
                catch (InterruptedException interruptedException) {
                    evolutionState.output.fatal("Whoa! The main breeding thread got interrupted!  Dying...");
                }
                ++n;
            }
        }
        return population;
    }

    protected void breedPopChunk(Population population, EvolutionState evolutionState, int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < population.subpops.length) {
            BreedingPipeline breedingPipeline = (BreedingPipeline)population.subpops[n2].species.pipe_prototype.clone();
            if (!breedingPipeline.produces(evolutionState, population, n2, n)) {
                evolutionState.output.fatal("The Breeding Pipeline of subpopulation " + n2 + " does not produce individuals of the expected species " + population.subpops[n2].species.getClass().getName() + " or fitness " + population.subpops[n2].species.f_prototype);
            }
            breedingPipeline.prepareToProduce(evolutionState, n2, n);
            int n3 = nArray2[n2];
            int n4 = nArray2[n2] + nArray[n2];
            while (n3 < n4) {
                n3 += breedingPipeline.produce(1, n4 - n3, n3, n2, population.subpops[n2].individuals, evolutionState, n);
            }
            if (n3 > n4) {
                evolutionState.output.fatal("Whoa!  A breeding pipeline overwrote the space of another pipeline in subpopulation " + n2 + ".  You need to check your breeding pipeline code (in produce() ).");
            }
            breedingPipeline.finishProducing(evolutionState, n2, n);
            ++n2;
        }
    }

    public void loadElites(EvolutionState evolutionState, Population population) {
        int n = 0;
        while (n < evolutionState.population.subpops.length) {
            if (this.elite[n] > evolutionState.population.subpops[n].individuals.length) {
                evolutionState.output.error("The number of elites for subpopulation " + n + " exceeds the actual size of the subpopulation", new Parameter("breed").push(P_ELITE).push("" + n));
            }
            ++n;
        }
        evolutionState.output.exitIfErrors();
        n = 0;
        while (n < evolutionState.population.subpops.length) {
            Individual[] individualArray;
            Individual[] individualArray2;
            if (this.elite[n] == 1) {
                int n2 = 0;
                individualArray2 = evolutionState.population.subpops[n].individuals;
                int n3 = 1;
                while (n3 < individualArray2.length) {
                    if (individualArray2[n3].fitness.betterThan(individualArray2[n2].fitness)) {
                        n2 = n3;
                    }
                    ++n3;
                }
                individualArray = population.subpops[n].individuals;
                individualArray[individualArray.length - 1] = (Individual)individualArray2[n2].clone();
            } else if (this.elite[n] > 0) {
                int[] nArray = new int[evolutionState.population.subpops[n].individuals.length];
                int n4 = 0;
                while (n4 < evolutionState.population.subpops[n].individuals.length) {
                    nArray[n4] = n4;
                    ++n4;
                }
                QuickSort.qsort(nArray, (SortComparatorL)new EliteComparator(evolutionState.population.subpops[n].individuals));
                individualArray2 = population.subpops[n].individuals;
                individualArray = evolutionState.population.subpops[n].individuals;
                int n5 = individualArray2.length - this.elite[n];
                while (n5 < individualArray2.length) {
                    individualArray2[n5] = (Individual)individualArray[nArray[n5]].clone();
                    ++n5;
                }
            }
            ++n;
        }
    }

    class EliteComparator
    implements SortComparatorL {
        Individual[] inds;

        public EliteComparator(Individual[] individualArray) {
            this.inds = individualArray;
        }

        public boolean lt(long l, long l2) {
            return this.inds[(int)l2].fitness.betterThan(this.inds[(int)l].fitness);
        }

        public boolean gt(long l, long l2) {
            return this.inds[(int)l].fitness.betterThan(this.inds[(int)l2].fitness);
        }
    }
}

