/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.util.Checkpoint;

public class SimpleEvolutionState
extends EvolutionState {
    public void startFresh() {
        this.output.message("Setting up");
        this.setup(this, null);
        this.output.message("Initializing Generation 0");
        this.statistics.preInitializationStatistics(this);
        this.population = this.initializer.initialPopulation(this, 0);
        this.statistics.postInitializationStatistics(this);
        this.exchanger.initializeContacts(this);
        this.evaluator.initializeContacts(this);
    }

    public int evolve() {
        if (this.generation > 0) {
            this.output.message("Generation " + this.generation);
        }
        this.statistics.preEvaluationStatistics(this);
        this.evaluator.evaluatePopulation(this);
        this.statistics.postEvaluationStatistics(this);
        if (this.evaluator.runComplete(this) && this.quitOnRunComplete) {
            this.output.message("Found Ideal Individual");
            return 0;
        }
        if (this.generation == this.numGenerations - 1) {
            return 1;
        }
        this.statistics.prePreBreedingExchangeStatistics(this);
        this.population = this.exchanger.preBreedingExchangePopulation(this);
        this.statistics.postPreBreedingExchangeStatistics(this);
        String string = this.exchanger.runComplete(this);
        if (string != null) {
            this.output.message(string);
            return 0;
        }
        this.statistics.preBreedingStatistics(this);
        this.population = this.breeder.breedPopulation(this);
        this.statistics.postBreedingStatistics(this);
        this.statistics.prePostBreedingExchangeStatistics(this);
        this.population = this.exchanger.postBreedingExchangePopulation(this);
        this.statistics.postPostBreedingExchangeStatistics(this);
        ++this.generation;
        if (this.checkpoint && this.generation % this.checkpointModulo == 0) {
            this.output.message("Checkpointing");
            this.statistics.preCheckpointStatistics(this);
            Checkpoint.setCheckpoint(this);
            this.statistics.postCheckpointStatistics(this);
        }
        return 2;
    }

    public void finish(int n) {
        this.statistics.finalStatistics(this, n);
        this.finisher.finishPopulation(this, n);
        this.exchanger.closeContacts(this, n);
        this.evaluator.closeContacts(this, n);
    }
}

