/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Fitness;
import ec.simple.SimpleDefaults;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class SimpleFitness
extends Fitness {
    protected float fitness;
    protected boolean isIdeal;

    public Parameter defaultBase() {
        return SimpleDefaults.base().push("fitness");
    }

    public void setFitness(EvolutionState evolutionState, float f) {
        this.setFitness(evolutionState, f, false);
    }

    public void setFitness(EvolutionState evolutionState, float f, boolean bl) {
        if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY || Float.isNaN(f)) {
            evolutionState.output.warning("Bad fitness: " + f + ", setting to 0.");
            this.fitness = 0.0f;
        } else {
            this.fitness = f;
        }
        this.isIdeal = bl;
    }

    public float fitness() {
        return this.fitness;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
    }

    public boolean isIdealFitness() {
        return this.isIdeal;
    }

    public boolean equivalentTo(Fitness fitness) {
        return ((SimpleFitness)fitness).fitness() == this.fitness();
    }

    public boolean betterThan(Fitness fitness) {
        return ((SimpleFitness)fitness).fitness() < this.fitness();
    }

    public String fitnessToString() {
        return "Fitness: " + Code.encode(this.fitness());
    }

    public String fitnessToStringForHumans() {
        return "Fitness: " + this.fitness();
    }

    public void readFitness(EvolutionState evolutionState, LineNumberReader lineNumberReader) throws IOException {
        this.setFitness(evolutionState, Code.readFloatWithPreamble("Fitness: ", evolutionState, lineNumberReader));
    }

    public void writeFitness(EvolutionState evolutionState, DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.fitness);
        dataOutput.writeBoolean(this.isIdeal);
    }

    public void readFitness(EvolutionState evolutionState, DataInput dataInput) throws IOException {
        this.fitness = dataInput.readFloat();
        this.isIdeal = dataInput.readBoolean();
    }
}

