/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;

public class SimpleShortStatistics
extends Statistics {
    public static final String P_STATISTICS_FILE = "file";
    public int statisticslog = 0;
    public static final String P_COMPRESS = "gzip";
    public static final String P_FULL = "gather-full";
    public boolean doFull;
    public Individual[] best_of_run_a;
    public long[] lengths;
    public long lastTime;
    public long lastUsage;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        File file = evolutionState.parameters.getFile(parameter.push(P_STATISTICS_FILE), null);
        if (file != null) {
            try {
                this.statisticslog = evolutionState.output.addLog(file, 2999, false, !evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false), evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred while trying to create the log " + file + ":\n" + iOException);
            }
        }
        this.doFull = evolutionState.parameters.getBoolean(parameter.push(P_FULL), null, false);
    }

    public void preInitializationStatistics(EvolutionState evolutionState) {
        super.preInitializationStatistics(evolutionState);
        if (this.doFull) {
            Runtime runtime = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = runtime.totalMemory() - runtime.freeMemory();
        }
    }

    public void postInitializationStatistics(EvolutionState evolutionState) {
        super.postInitializationStatistics(evolutionState);
        this.best_of_run_a = new Individual[evolutionState.population.subpops.length];
        evolutionState.output.print("0 ", 3000, this.statisticslog);
        if (this.doFull) {
            this.lengths = new long[evolutionState.population.subpops.length];
            int n = 0;
            while (n < this.lengths.length) {
                this.lengths[n] = 0L;
                ++n;
            }
            Runtime runtime = Runtime.getRuntime();
            long l = runtime.totalMemory() - runtime.freeMemory();
            evolutionState.output.print(System.currentTimeMillis() - this.lastTime + " ", 3000, this.statisticslog);
            evolutionState.output.print(l - this.lastUsage + " ", 3000, this.statisticslog);
        }
    }

    public void preBreedingStatistics(EvolutionState evolutionState) {
        super.preBreedingStatistics(evolutionState);
        if (this.doFull) {
            Runtime runtime = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = runtime.totalMemory() - runtime.freeMemory();
        }
    }

    public void postBreedingStatistics(EvolutionState evolutionState) {
        super.postBreedingStatistics(evolutionState);
        evolutionState.output.print(evolutionState.generation + 1 + " ", 3000, this.statisticslog);
        if (this.doFull) {
            Runtime runtime = Runtime.getRuntime();
            long l = runtime.totalMemory() - runtime.freeMemory();
            evolutionState.output.print(System.currentTimeMillis() - this.lastTime + " ", 3000, this.statisticslog);
            evolutionState.output.print(l - this.lastUsage + " ", 3000, this.statisticslog);
        }
    }

    public void preEvaluationStatistics(EvolutionState evolutionState) {
        super.preEvaluationStatistics(evolutionState);
        if (this.doFull) {
            Runtime runtime = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = runtime.totalMemory() - runtime.freeMemory();
        }
    }

    protected void _postEvaluationStatistics(EvolutionState evolutionState) {
        if (this.doFull) {
            Runtime runtime = Runtime.getRuntime();
            long l = runtime.totalMemory() - runtime.freeMemory();
            evolutionState.output.print(System.currentTimeMillis() - this.lastTime + " ", 3000, this.statisticslog);
            evolutionState.output.print(l - this.lastUsage + " ", 3000, this.statisticslog);
        }
        long l = 0L;
        Individual[] individualArray = new Individual[evolutionState.population.subpops.length];
        int n = 0;
        while (n < evolutionState.population.subpops.length) {
            if (this.doFull) {
                l = 0L;
                int n2 = 0;
                while (n2 < evolutionState.population.subpops[n].individuals.length) {
                    long l2 = evolutionState.population.subpops[n].individuals[n2].size();
                    l += l2;
                    int n3 = n;
                    this.lengths[n3] = this.lengths[n3] + l2;
                    ++n2;
                }
                evolutionState.output.print((double)l / (double)evolutionState.population.subpops[n].individuals.length + " ", 3000, this.statisticslog);
                evolutionState.output.print((double)this.lengths[n] / (double)(evolutionState.population.subpops[n].individuals.length * (evolutionState.generation + 1)) + " ", 3000, this.statisticslog);
            }
            double d = 0.0;
            int n4 = 0;
            while (n4 < evolutionState.population.subpops[n].individuals.length) {
                if (individualArray[n] == null || evolutionState.population.subpops[n].individuals[n4].fitness.betterThan(individualArray[n].fitness)) {
                    individualArray[n] = evolutionState.population.subpops[n].individuals[n4];
                }
                d += (double)evolutionState.population.subpops[n].individuals[n4].fitness.fitness();
                ++n4;
            }
            evolutionState.output.print((d /= (double)evolutionState.population.subpops[n].individuals.length) + " " + individualArray[n].fitness.fitness() + " ", 3000, this.statisticslog);
            if (this.best_of_run_a[n] == null || individualArray[n].fitness.betterThan(this.best_of_run_a[n].fitness)) {
                this.best_of_run_a[n] = (Individual)individualArray[n].clone();
            }
            evolutionState.output.print(this.best_of_run_a[n].fitness.fitness() + " ", 3000, this.statisticslog);
            if (this.doFull) {
                evolutionState.output.print((double)individualArray[n].size() + " " + (double)this.best_of_run_a[n].size() + " ", 3000, this.statisticslog);
            }
            ++n;
        }
    }

    public void postEvaluationStatistics(EvolutionState evolutionState) {
        super.postEvaluationStatistics(evolutionState);
        this._postEvaluationStatistics(evolutionState);
        evolutionState.output.println("", 3000, this.statisticslog);
    }
}

