/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.simple.SimpleProblemForm;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;

public class SimpleStatistics
extends Statistics
implements SteadyStateStatisticsForm {
    public static final String P_STATISTICS_FILE = "file";
    public static final String P_COMPRESS = "gzip";
    public int statisticslog = 0;
    public Individual[] best_of_run = null;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        File file = evolutionState.parameters.getFile(parameter.push(P_STATISTICS_FILE), null);
        if (file != null) {
            try {
                this.statisticslog = evolutionState.output.addLog(file, 2999, false, !evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false), evolutionState.parameters.getBoolean(parameter.push(P_COMPRESS), null, false));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred while trying to create the log " + file + ":\n" + iOException);
            }
        }
    }

    public void postInitializationStatistics(EvolutionState evolutionState) {
        super.postInitializationStatistics(evolutionState);
        this.best_of_run = new Individual[evolutionState.population.subpops.length];
    }

    public void postEvaluationStatistics(EvolutionState evolutionState) {
        super.postEvaluationStatistics(evolutionState);
        Individual[] individualArray = new Individual[evolutionState.population.subpops.length];
        int n = 0;
        while (n < evolutionState.population.subpops.length) {
            individualArray[n] = evolutionState.population.subpops[n].individuals[0];
            int n2 = 1;
            while (n2 < evolutionState.population.subpops[n].individuals.length) {
                if (evolutionState.population.subpops[n].individuals[n2].fitness.betterThan(individualArray[n].fitness)) {
                    individualArray[n] = evolutionState.population.subpops[n].individuals[n2];
                }
                ++n2;
            }
            if (this.best_of_run[n] == null || individualArray[n].fitness.betterThan(this.best_of_run[n].fitness)) {
                this.best_of_run[n] = (Individual)individualArray[n].clone();
            }
            ++n;
        }
        evolutionState.output.println("\nGeneration: " + evolutionState.generation, 3000, this.statisticslog);
        evolutionState.output.println("Best Individual:", 3000, this.statisticslog);
        n = 0;
        while (n < evolutionState.population.subpops.length) {
            individualArray[n].printIndividualForHumans(evolutionState, this.statisticslog, 3000);
            evolutionState.output.message("Subpop " + n + " best fitness of generation: " + individualArray[n].fitness.fitnessToStringForHumans());
            ++n;
        }
    }

    public void finalStatistics(EvolutionState evolutionState, int n) {
        super.finalStatistics(evolutionState, n);
        evolutionState.output.println("\nBest Individual of Run:", 3000, this.statisticslog);
        int n2 = 0;
        while (n2 < evolutionState.population.subpops.length) {
            this.best_of_run[n2].printIndividualForHumans(evolutionState, this.statisticslog, 3000);
            evolutionState.output.message("Subpop " + n2 + " best fitness of run: " + this.best_of_run[n2].fitness.fitnessToStringForHumans());
            if (evolutionState.evaluator.p_problem instanceof SimpleProblemForm) {
                ((SimpleProblemForm)evolutionState.evaluator.p_problem.clone()).describe(this.best_of_run[n2], evolutionState, n2, 0, this.statisticslog, 3000);
            }
            ++n2;
        }
    }
}

