/*
 * Decompiled with CFR 0.152.
 */
package ec.steadystate;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.simple.SimpleBreeder;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateDefaults;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;

public class SteadyStateBreeder
extends SimpleBreeder {
    BreedingPipeline[] bp = null;
    public static final String P_DESELECTOR = "deselector";
    public static final String P_RETRIES = "duplicate-retries";
    SelectionMethod[] deselectors = null;
    public int numDuplicateRetries;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = new Parameter("pop").push("subpops");
        int n = evolutionState.parameters.getInt(parameter2, null, 1);
        if (n > 0) {
            this.deselectors = new SelectionMethod[n];
        }
        int n2 = 0;
        while (n2 < this.deselectors.length) {
            this.deselectors[n2] = (SelectionMethod)evolutionState.parameters.getInstanceForParameter(SteadyStateDefaults.base().push(P_DESELECTOR).push("" + n2), null, SelectionMethod.class);
            if (!(this.deselectors[n2] instanceof SteadyStateBSourceForm)) {
                evolutionState.output.error("Deselector for subpopulation " + n2 + " is not of SteadyStateBSourceForm.");
            }
            this.deselectors[n2].setup(evolutionState, SteadyStateDefaults.base().push(P_DESELECTOR).push("" + n2));
            ++n2;
        }
        evolutionState.output.exitIfErrors();
        this.numDuplicateRetries = evolutionState.parameters.getInt(SteadyStateDefaults.base().push(P_RETRIES), null, 0);
        if (this.numDuplicateRetries < 0) {
            evolutionState.output.fatal("The number of retries for duplicates must be an integer >= 0.\n", parameter.push(P_RETRIES), null);
        }
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState steadyStateEvolutionState, BreedingPipeline[] breedingPipelineArray) {
        int n = 0;
        while (n < breedingPipelineArray.length) {
            if (!(breedingPipelineArray[n] instanceof SteadyStateBSourceForm)) {
                steadyStateEvolutionState.output.error("Breeding Pipeline of subpopulation " + n + " is not of SteadyStateBSourceForm");
            }
            breedingPipelineArray[n].sourcesAreProperForm(steadyStateEvolutionState);
            ++n;
        }
    }

    public void individualReplaced(SteadyStateEvolutionState steadyStateEvolutionState, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.bp.length) {
            this.bp[n4].individualReplaced(steadyStateEvolutionState, n, n2, n3);
            ++n4;
        }
        ((SteadyStateBSourceForm)((Object)this.deselectors[n])).individualReplaced(steadyStateEvolutionState, n, n2, n3);
    }

    public void finishPipelines(EvolutionState evolutionState) {
        int n = 0;
        while (n < this.deselectors.length) {
            this.bp[n].finishProducing(evolutionState, n, 0);
            this.deselectors[n].finishProducing(evolutionState, n, 0);
            ++n;
        }
    }

    public void prepareToBreed(EvolutionState evolutionState, int n) {
        SteadyStateEvolutionState steadyStateEvolutionState = (SteadyStateEvolutionState)evolutionState;
        this.bp = new BreedingPipeline[steadyStateEvolutionState.population.subpops.length];
        int n2 = 0;
        while (n2 < this.bp.length) {
            this.bp[n2] = (BreedingPipeline)steadyStateEvolutionState.population.subpops[n2].species.pipe_prototype.clone();
            if (!this.bp[n2].produces(steadyStateEvolutionState, steadyStateEvolutionState.population, n2, 0)) {
                steadyStateEvolutionState.output.error("The Breeding Pipeline of subpopulation " + n2 + " does not produce individuals of the expected species " + steadyStateEvolutionState.population.subpops[n2].species.getClass().getName() + " and with the expected Fitness class " + steadyStateEvolutionState.population.subpops[n2].species.f_prototype.getClass().getName());
            }
            ++n2;
        }
        this.sourcesAreProperForm(steadyStateEvolutionState, this.bp);
        steadyStateEvolutionState.output.exitIfErrors();
        n2 = 0;
        while (n2 < this.bp.length) {
            this.bp[n2].prepareToProduce(evolutionState, n2, 0);
            this.deselectors[n2].prepareToProduce(evolutionState, n2, 0);
            ++n2;
        }
    }

    public Individual breedIndividual(EvolutionState evolutionState, int n, int n2) {
        SteadyStateEvolutionState steadyStateEvolutionState = (SteadyStateEvolutionState)evolutionState;
        Individual[] individualArray = new Individual[1];
        this.bp[n].produce(1, 1, 0, n, individualArray, evolutionState, n2);
        return individualArray[0];
    }
}

