/*
 * Decompiled with CFR 0.152.
 */
package ec.steadystate;

import ec.EvolutionState;
import ec.Individual;
import ec.eval.MasterProblem;
import ec.simple.SimpleEvaluator;
import ec.simple.SimpleProblemForm;
import ec.steadystate.QueueIndividual;
import ec.util.Parameter;
import java.util.LinkedList;

public class SteadyStateEvaluator
extends SimpleEvaluator {
    LinkedList queue = new LinkedList();
    int subpopulationBeingEvaluated = -1;
    SimpleProblemForm problem;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
    }

    public void prepareToEvaluate(EvolutionState evolutionState, int n) {
        this.problem = (SimpleProblemForm)this.p_problem.clone();
        if (this.problem instanceof MasterProblem) {
            ((MasterProblem)this.problem).prepareToEvaluate(evolutionState, n);
        }
    }

    public void evaluateIndividual(EvolutionState evolutionState, Individual individual, int n) {
        this.problem.evaluate(evolutionState, individual, n, 0);
        this.queue.addLast(new QueueIndividual(individual, n));
    }

    public boolean canEvaluate() {
        if (this.problem instanceof MasterProblem) {
            return ((MasterProblem)this.problem).canEvaluate();
        }
        return true;
    }

    public Individual getNextEvaluatedIndividual() {
        QueueIndividual queueIndividual = null;
        if (this.problem instanceof MasterProblem) {
            if (((MasterProblem)this.problem).evaluatedIndividualAvailable()) {
                queueIndividual = ((MasterProblem)this.problem).getNextEvaluatedIndividual();
            }
        } else {
            queueIndividual = (QueueIndividual)this.queue.removeFirst();
        }
        if (queueIndividual == null) {
            return null;
        }
        this.subpopulationBeingEvaluated = queueIndividual.subpop;
        return queueIndividual.ind;
    }

    public int getSubpopulationOfEvaluatedIndividual() {
        return this.subpopulationBeingEvaluated;
    }
}

