/*
 * Decompiled with CFR 0.152.
 */
package ec.steadystate;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.steadystate.SteadyStateBreeder;
import ec.steadystate.SteadyStateEvaluator;
import ec.steadystate.SteadyStateExchangerForm;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Checkpoint;
import ec.util.Parameter;
import java.util.HashMap;

public class SteadyStateEvolutionState
extends EvolutionState {
    public static final String P_STEADYSTATE = "steady";
    public static final String P_NUMEVALUATIONS = "evaluations";
    public boolean generationBoundary;
    public long numEvaluations;
    public static long UNDEFINED = 0L;
    public int generationSize;
    public long evaluations;
    int[] individualCount;
    HashMap[] individualHash;
    int whichSubpop;
    protected boolean firstTime;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        if (!(this.breeder instanceof SteadyStateBreeder)) {
            evolutionState.output.error("You've chosen to use Steady-State Evolution, but your breeder is not of the class SteadyStateBreeder.", parameter);
        }
        if (!(this.evaluator instanceof SteadyStateEvaluator)) {
            evolutionState.output.error("You've chosen to use Steady-State Evolution, but your evaluator is not of the class SteadyStateEvaluator.", parameter);
        }
        if (!(this.exchanger instanceof SteadyStateExchangerForm)) {
            evolutionState.output.error("You've chosen to use Steady-State Evolution, but your exchanger does not implement the SteadyStateExchangerForm.", parameter);
        }
        this.checkStatistics(evolutionState, this.statistics, parameter);
        this.numEvaluations = this.parameters.getLong(new Parameter(P_NUMEVALUATIONS), null, 1L);
        if (this.numEvaluations == 0L) {
            this.output.message("Number of evaluations not defined; using number of generations");
        }
    }

    void checkStatistics(EvolutionState evolutionState, Statistics statistics, Parameter parameter) {
        if (!(statistics instanceof SteadyStateStatisticsForm)) {
            evolutionState.output.warning("You've chosen to use Steady-State Evolution, but your statistics does not implement the SteadyStateStatisticsForm.", parameter);
        }
        int n = 0;
        while (n < statistics.children.length) {
            if (statistics.children[n] != null) {
                this.checkStatistics(evolutionState, statistics.children[n], parameter.push("child").push("" + n));
            }
            ++n;
        }
    }

    public void startFresh() {
        this.output.message("Setting up");
        this.setup(this, null);
        this.output.message("Initializing Generation 0");
        this.statistics.preInitializationStatistics(this);
        this.population = this.initializer.setupPopulation(this, 0);
        if (this.numEvaluations > 0L && this.numEvaluations < (long)this.population.subpops[0].individuals.length) {
            this.output.fatal("Number of evaluations desired is smaller than the initial population of individuals");
        }
        this.generationSize = 0;
        this.generationBoundary = false;
        this.firstTime = true;
        this.evaluations = 0L;
        this.whichSubpop = -1;
        this.individualHash = new HashMap[this.population.subpops.length];
        int n = 0;
        while (n < this.population.subpops.length) {
            this.individualHash[n] = new HashMap();
            ++n;
        }
        this.individualCount = new int[this.population.subpops.length];
        n = 0;
        while (n < this.population.subpops.length) {
            this.individualCount[n] = 0;
            this.generationSize += this.population.subpops[n].individuals.length;
            ++n;
        }
        this.exchanger.initializeContacts(this);
        this.evaluator.initializeContacts(this);
    }

    public int evolve() {
        Individual individual;
        int n;
        int n2;
        Individual individual2;
        boolean bl;
        if (this.generationBoundary && this.generation > 0) {
            this.output.message("Generation " + this.generation + "\tEvaluations " + this.evaluations);
        }
        if (this.firstTime) {
            if (this.statistics instanceof SteadyStateStatisticsForm) {
                ((SteadyStateStatisticsForm)((Object)this.statistics)).preInitialEvaluationStatistics(this);
            }
            this.statistics.postInitializationStatistics(this);
            ((SteadyStateBreeder)this.breeder).prepareToBreed(this, 0);
            ((SteadyStateEvaluator)this.evaluator).prepareToEvaluate(this, 0);
            this.firstTime = false;
        }
        if (this.checkpoint && this.generation % this.checkpointModulo == 0) {
            this.output.message("Checkpointing");
            this.statistics.preCheckpointStatistics(this);
            Checkpoint.setCheckpoint(this);
            this.statistics.postCheckpointStatistics(this);
        }
        this.whichSubpop = (this.whichSubpop + 1) % this.population.subpops.length;
        boolean bl2 = bl = this.individualCount[this.whichSubpop] < this.population.subpops[this.whichSubpop].individuals.length;
        if (((SteadyStateEvaluator)this.evaluator).canEvaluate()) {
            individual2 = null;
            n2 = this.population.subpops[this.whichSubpop].numDuplicateRetries;
            n = 0;
            while (n <= n2) {
                if (bl) {
                    individual2 = this.population.subpops[this.whichSubpop].species.newIndividual((EvolutionState)this, 0);
                } else {
                    individual2 = ((SteadyStateBreeder)this.breeder).breedIndividual(this, this.whichSubpop, 0);
                    this.statistics.individualsBredStatistics(this, null, null, null);
                }
                if (n2 >= 1 && (individual = this.individualHash[this.whichSubpop].get(individual2)) == null) {
                    this.individualHash[this.whichSubpop].put(individual2, individual2);
                    break;
                }
                ++n;
            }
            ((SteadyStateEvaluator)this.evaluator).evaluateIndividual(this, individual2, this.whichSubpop);
        }
        if ((individual2 = ((SteadyStateEvaluator)this.evaluator).getNextEvaluatedIndividual()) != null) {
            n2 = ((SteadyStateEvaluator)this.evaluator).getSubpopulationOfEvaluatedIndividual();
            if (bl) {
                int n3 = n2;
                int n4 = this.individualCount[n3];
                this.individualCount[n3] = n4 + 1;
                this.population.subpops[n2].individuals[n4] = individual2;
                if (this.individualCount[n2] == this.population.subpops[n2].individuals.length && this.statistics instanceof SteadyStateStatisticsForm) {
                    ((SteadyStateStatisticsForm)((Object)this.statistics)).postInitialEvaluationStatistics(n2, this);
                }
            } else {
                n = ((SteadyStateBreeder)this.breeder).deselectors[n2].produce(n2, this, 0);
                individual = this.population.subpops[n2].individuals[n];
                this.population.subpops[n2].individuals[n] = individual2;
                this.individualHash[n2].remove(individual);
                if (this.statistics instanceof SteadyStateStatisticsForm) {
                    ((SteadyStateStatisticsForm)((Object)this.statistics)).individualsEvaluatedStatistics(this, null, null, null, null);
                }
            }
            ++this.evaluations;
            this.generationBoundary = this.evaluations % (long)this.generationSize == 0L;
        } else {
            this.generationBoundary = false;
        }
        if (!bl && this.evaluator.runComplete(this) && this.quitOnRunComplete) {
            this.output.message("Found Ideal Individual");
            return 0;
        }
        if (this.numEvaluations > 0L && this.evaluations >= this.numEvaluations || this.numEvaluations <= 0L && this.generationBoundary && this.generation == this.numGenerations - 1) {
            return 1;
        }
        if (this.generationBoundary) {
            this.statistics.prePreBreedingExchangeStatistics(this);
            this.population = this.exchanger.preBreedingExchangePopulation(this);
            this.statistics.postPreBreedingExchangeStatistics(this);
            String string = this.exchanger.runComplete(this);
            if (string != null) {
                this.output.message(string);
                return 0;
            }
            this.statistics.prePostBreedingExchangeStatistics(this);
            this.population = this.exchanger.postBreedingExchangePopulation(this);
            this.statistics.postPostBreedingExchangeStatistics(this);
            ++this.generation;
            this.statistics.generationBoundaryStatistics(this);
            this.statistics.postEvaluationStatistics(this);
        }
        return 2;
    }

    public void finish(int n) {
        ((SteadyStateBreeder)this.breeder).finishPipelines(this);
        this.statistics.finalStatistics(this, n);
        this.finisher.finishPopulation(this, n);
        this.exchanger.closeContacts(this, n);
        this.evaluator.closeContacts(this, n);
    }
}

