/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.EvolutionState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Checkpoint {
    public static void setCheckpoint(EvolutionState evolutionState) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(evolutionState.checkpointPrefix + "." + evolutionState.generation + ".gz"))));
            objectOutputStream.writeObject(evolutionState);
            objectOutputStream.close();
            evolutionState.output.message("Wrote out checkpoint file " + evolutionState.checkpointPrefix + "." + evolutionState.generation + ".gz");
        }
        catch (IOException iOException) {
            evolutionState.output.warning("Unable to create the checkpoint file " + evolutionState.checkpointPrefix + "." + evolutionState.generation + ".gz" + "because of an IOException:\n--EXCEPTION--\n" + iOException + "\n--EXCEPTION-END--\n");
        }
    }

    public static EvolutionState restoreFromCheckpoint(String string) throws IOException, ClassNotFoundException, OptionalDataException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(string))));
        EvolutionState evolutionState = (EvolutionState)objectInputStream.readObject();
        objectInputStream.close();
        evolutionState.resetFromCheckpoint();
        return evolutionState;
    }
}

