/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.EvolutionState;
import ec.util.DecodeReturn;
import java.io.IOException;
import java.io.LineNumberReader;

public class Code {
    public static String encode(boolean bl) {
        return bl ? "T" : "F";
    }

    public static String encode(byte by) {
        return "b" + Byte.toString(by) + "|";
    }

    public static String encode(char c) {
        if (c >= ' ' && c < '\u007f' && c != '\\' && c != '\'') {
            return "'" + String.valueOf(c) + "'";
        }
        if (c == '\b') {
            return "'\\b'";
        }
        if (c == '\n') {
            return "'\\n'";
        }
        if (c == '\t') {
            return "'\\t'";
        }
        if (c == '\'') {
            return "'\\''";
        }
        if (c == '\\') {
            return "'\\\\'";
        }
        if (c == '\u0000') {
            return "'\\\\0";
        }
        String string = Integer.toHexString(c);
        switch (string.length()) {
            case 1: {
                string = "'\\u000" + string + "'";
                break;
            }
            case 2: {
                string = "'\\u00" + string + "'";
                break;
            }
            case 3: {
                string = "'\\u0" + string + "'";
                break;
            }
            case 4: {
                string = "'\\u" + string + "'";
            }
        }
        return string;
    }

    public static String encode(short s) {
        return "s" + Short.toString(s) + "|";
    }

    public static String encode(int n) {
        return "i" + Integer.toString(n) + "|";
    }

    public static String encode(long l) {
        return "l" + Long.toString(l) + "|";
    }

    public static String encode(float f) {
        return "f" + Integer.toString(Float.floatToIntBits(f)) + "|" + String.valueOf(f) + "|";
    }

    public static String encode(double d) {
        return "d" + Long.toString(Double.doubleToLongBits(d)) + "|" + String.valueOf(d) + "|";
    }

    public static String encode(String string) {
        boolean bl = false;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("\"");
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c >= ' ' && c < '\u007f' && c != '\\' && c != '\"') {
                if (bl) {
                    stringBuffer.append("\\u");
                    bl = false;
                }
                stringBuffer.append(c);
            } else if (c == '\b') {
                if (bl) {
                    stringBuffer.append("\\u");
                    bl = false;
                }
                stringBuffer.append("\\b");
            } else if (c == '\n') {
                if (bl) {
                    stringBuffer.append("\\u");
                    bl = false;
                }
                stringBuffer.append("\\n");
            } else if (c == '\t') {
                if (bl) {
                    stringBuffer.append("\\u");
                    bl = false;
                }
                stringBuffer.append("\\t");
            } else if (c == '\"') {
                if (bl) {
                    stringBuffer.append("\\u");
                    bl = false;
                }
                stringBuffer.append("\\\"");
            } else if (c == '\\') {
                if (bl) {
                    stringBuffer.append("\\u");
                    bl = false;
                }
                stringBuffer.append("\\\\");
            } else if (c == '\u0000') {
                if (bl) {
                    stringBuffer.append("\\u");
                    bl = false;
                }
                stringBuffer.append("\\0");
            } else {
                if (!bl) {
                    stringBuffer.append("\\u");
                    bl = true;
                }
                String string2 = Integer.toHexString(c);
                switch (string2.length()) {
                    case 1: {
                        stringBuffer.append("000" + string2);
                        break;
                    }
                    case 2: {
                        stringBuffer.append("00" + string2);
                        break;
                    }
                    case 3: {
                        stringBuffer.append("0" + string2);
                        break;
                    }
                    case 4: {
                        stringBuffer.append(string2);
                    }
                }
            }
            ++n2;
        }
        if (bl) {
            stringBuffer.append("\\u");
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static void decode(DecodeReturn var0) {
        var1_1 = var0.data;
        var2_2 = var0.pos;
        var3_3 = var0.data.length();
        while (var2_2 < var3_3) {
            if (!Character.isWhitespace(var1_1.charAt(var2_2))) break;
            ++var2_2;
        }
        if (var2_2 == var3_3) {
            var0.type = (byte)-1;
            var0.s = "Out of tokens";
            return;
        }
        switch (var1_1.charAt(var2_2)) {
            case 't': {
                if (var2_2 + 3 < var3_3 && var1_1.charAt(var2_2 + 1) == 'r' && var1_1.charAt(var2_2 + 2) == 'u' && var1_1.charAt(var2_2 + 3) == 'e') {
                    var0.type = 0;
                    var0.l = 1L;
                    var0.pos = var2_2 + 4;
                    return;
                }
                var0.type = (byte)-1;
                var0.s = "Expected a (true) boolean";
                return;
            }
            case 'T': {
                var0.type = 0;
                var0.l = 1L;
                var0.pos = var2_2 + 1;
                return;
            }
            case 'F': {
                var0.type = 0;
                var0.l = 0L;
                var0.pos = var2_2 + 1;
                return;
            }
            case 'f': {
                if (var2_2 + 4 < var3_3 && var1_1.charAt(var2_2 + 1) == 'a' && var1_1.charAt(var2_2 + 2) == 'l' && var1_1.charAt(var2_2 + 3) == 's' && var1_1.charAt(var2_2 + 4) == 'e') {
                    var0.type = 0;
                    var0.l = 0L;
                    var0.pos = var2_2 + 5;
                    return;
                }
                var4_4 = false;
                var5_12 = null;
                var6_20 = var2_2 + 1;
                while (var2_2 < var3_3) {
                    if (var1_1.charAt(var2_2) == '|') break;
                    ++var2_2;
                }
                if (var2_2 == var6_20) {
                    var4_4 = true;
                }
                if (var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a float";
                    return;
                }
                if (!var4_4) {
                    var5_12 = var1_1.substring(var6_20, var2_2);
                }
                var7_27 = ++var2_2;
                while (var2_2 < var3_3) {
                    if (var1_1.charAt(var2_2) == '|') break;
                    ++var2_2;
                }
                if (var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a float";
                    return;
                }
                if (var4_4) {
                    var5_12 = var1_1.substring(var7_27, var2_2);
                }
                try {
                    var8_33 = var4_4 ? Float.parseFloat(var5_12) : Float.intBitsToFloat(Integer.parseInt(var5_12));
                }
                catch (NumberFormatException var9_36) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a float";
                    return;
                }
                var0.type = (byte)6;
                var0.d = var8_33;
                var0.pos = var2_2 + 1;
                return;
            }
            case 'd': {
                var4_5 = false;
                var5_13 = null;
                var6_21 = var2_2 + 1;
                while (var2_2 < var3_3) {
                    if (var1_1.charAt(var2_2) == '|') break;
                    ++var2_2;
                }
                if (var2_2 == var6_21) {
                    var4_5 = true;
                }
                if (var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a double";
                    return;
                }
                if (!var4_5) {
                    var5_13 = var1_1.substring(var6_21, var2_2);
                }
                var7_28 = ++var2_2;
                while (var2_2 < var3_3) {
                    if (var1_1.charAt(var2_2) == '|') break;
                    ++var2_2;
                }
                if (var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a double";
                    return;
                }
                if (var4_5) {
                    var5_13 = var1_1.substring(var7_28, var2_2);
                }
                try {
                    var8_34 = var4_5 ? Double.parseDouble(var5_13) : Double.longBitsToDouble(Long.parseLong(var5_13));
                }
                catch (NumberFormatException var10_37) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a double";
                    return;
                }
                var0.type = (byte)7;
                var0.d = var8_34;
                var0.pos = var2_2 + 1;
                return;
            }
            case 'b': {
                var4_6 = var2_2 + 1;
                while (var2_2 < var3_3) {
                    if (var1_1.charAt(var2_2) == '|') break;
                    ++var2_2;
                }
                if (var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a byte";
                    return;
                }
                var5_14 = var1_1.substring(var4_6, var2_2);
                try {
                    var6_22 = Byte.parseByte(var5_14);
                }
                catch (NumberFormatException var7_29) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a byte";
                    return;
                }
                var0.type = 1;
                var0.l = var6_22;
                var0.pos = var2_2 + 1;
                return;
            }
            case 's': {
                var4_7 = var2_2 + 1;
                while (var2_2 < var3_3) {
                    if (var1_1.charAt(var2_2) == '|') break;
                    ++var2_2;
                }
                if (var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a short";
                    return;
                }
                var5_15 = var1_1.substring(var4_7, var2_2);
                try {
                    var6_23 = Short.parseShort(var5_15);
                }
                catch (NumberFormatException var7_30) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a short";
                    return;
                }
                var0.type = (byte)3;
                var0.l = var6_23;
                var0.pos = var2_2 + 1;
                return;
            }
            case 'i': {
                var4_8 = var2_2 + 1;
                while (var2_2 < var3_3) {
                    if (var1_1.charAt(var2_2) == '|') break;
                    ++var2_2;
                }
                if (var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Expected an int";
                    return;
                }
                var5_16 = var1_1.substring(var4_8, var2_2);
                try {
                    var6_24 = Integer.parseInt(var5_16);
                }
                catch (NumberFormatException var7_31) {
                    var0.type = (byte)-1;
                    var0.s = "Expected an int";
                    return;
                }
                var0.type = (byte)4;
                var0.l = var6_24;
                var0.pos = var2_2 + 1;
                return;
            }
            case 'l': {
                var4_9 = var2_2 + 1;
                while (var2_2 < var3_3) {
                    if (var1_1.charAt(var2_2) == '|') break;
                    ++var2_2;
                }
                if (var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a long";
                    return;
                }
                var5_17 = var1_1.substring(var4_9, var2_2);
                try {
                    var6_25 = Long.parseLong(var5_17);
                }
                catch (NumberFormatException var8_35) {
                    var0.type = (byte)-1;
                    var0.s = "Expected a long";
                    return;
                }
                var0.type = (byte)5;
                var0.l = var6_25;
                var0.pos = var2_2 + 1;
                return;
            }
            case '\"': {
                var4_10 = new StringBuffer();
                var5_18 = false;
                ++var2_2;
                while (var2_2 < var3_3) {
                    var6_26 = var1_1.charAt(var2_2);
                    if (var6_26 == '\"') {
                        if (var5_18) {
                            var0.type = (byte)-1;
                            var0.s = "Forgot to terminate Unicode with a '\\u' in the string";
                            return;
                        }
                        var0.type = (byte)8;
                        var0.s = var4_10.toString();
                        var0.pos = var2_2 + 1;
                        return;
                    }
                    if (var6_26 != '\\') ** GOTO lbl261
                    if (++var2_2 >= var3_3) {
                        var0.type = (byte)-1;
                        var0.s = "Unterminated String";
                        return;
                    }
                    if (var1_1.charAt(var2_2) != 'u') {
                        var0.type = (byte)-1;
                        var0.s = "Escape character in Unicode sequence";
                        return;
                    }
                    switch (var1_1.charAt(var2_2)) {
                        case 'u': {
                            var5_18 = var5_18 == false;
                            ** GOTO lbl277
                        }
                        case 'b': {
                            var4_10.append('\b');
                            ** GOTO lbl277
                        }
                        case 'n': {
                            var4_10.append('\n');
                            ** GOTO lbl277
                        }
                        case '\"': {
                            var4_10.append('\"');
                            ** GOTO lbl277
                        }
                        case '\'': {
                            var4_10.append('\'');
                            ** GOTO lbl277
                        }
                        case 't': {
                            var4_10.append('\t');
                            ** GOTO lbl277
                        }
                        case '\\': {
                            var4_10.append('\\');
                            ** GOTO lbl277
                        }
                        case '0': {
                            var4_10.append('\u0000');
                            ** GOTO lbl277
                        }
                        default: {
                            var0.type = (byte)-1;
                            var0.s = "Bad escape char in String";
                            return;
                        }
                    }
lbl261:
                    // 1 sources

                    if (var5_18) {
                        if (var2_2 + 3 >= var3_3) {
                            var0.type = (byte)-1;
                            var0.s = "Unterminated String";
                            return;
                        }
                        try {
                            var4_10.append((char)Integer.decode("0x" + var6_26 + var1_1.charAt(var2_2 + 1) + var1_1.charAt(var2_2 + 2) + var1_1.charAt(var2_2 + 3)).intValue());
                            var2_2 += 3;
                        }
                        catch (NumberFormatException var7_32) {
                            var0.type = (byte)-1;
                            var0.s = "Bad Unicode in String";
                            return;
                        }
                    } else {
                        var4_10.append(var6_26);
                    }
lbl277:
                    // 10 sources

                    ++var2_2;
                }
                var0.type = (byte)-1;
                var0.s = "Unterminated String";
                return;
            }
            case '\'': {
                if (++var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Unterminated char";
                    return;
                }
                var4_11 = var1_1.charAt(var2_2);
                if (var4_11 == 92) {
                    if (++var2_2 >= var3_3) {
                        var0.type = (byte)-1;
                        var0.s = "Unterminated char";
                        return;
                    }
                    switch (var1_1.charAt(var2_2)) {
                        case 'u': {
                            if (var2_2 + 4 >= var3_3) {
                                var0.type = (byte)-1;
                                var0.s = "Unterminated char";
                                return;
                            }
                            try {
                                var4_11 = (char)Integer.decode("0x" + var1_1.charAt(var2_2 + 1) + var1_1.charAt(var2_2 + 2) + var1_1.charAt(var2_2 + 3) + var1_1.charAt(var2_2 + 4)).intValue();
                            }
                            catch (NumberFormatException var5_19) {
                                var0.type = (byte)-1;
                                var0.s = "Bad Unicode in char";
                                return;
                            }
                            var2_2 += 5;
                            break;
                        }
                        case 'b': {
                            var4_11 = 8;
                            ++var2_2;
                            break;
                        }
                        case 'n': {
                            var4_11 = 10;
                            ++var2_2;
                            break;
                        }
                        case '\"': {
                            var4_11 = 34;
                            ++var2_2;
                            break;
                        }
                        case '\'': {
                            var4_11 = 39;
                            ++var2_2;
                            break;
                        }
                        case 't': {
                            var4_11 = 9;
                            ++var2_2;
                            break;
                        }
                        case '\\': {
                            var4_11 = 92;
                            ++var2_2;
                            break;
                        }
                        case '0': {
                            var4_11 = 0;
                            ++var2_2;
                            break;
                        }
                        default: {
                            var0.type = (byte)-1;
                            var0.s = "Bad escape char in char";
                            return;
                        }
                    }
                    if (var1_1.charAt(var2_2) != '\'') {
                        var0.type = (byte)-1;
                        var0.s = "Bad char";
                        return;
                    }
                    var0.type = (byte)2;
                    var0.l = var4_11;
                    var0.pos = var2_2 + 1;
                    return;
                }
                if (++var2_2 >= var3_3) {
                    var0.type = (byte)-1;
                    var0.s = "Unterminated char";
                    return;
                }
                if (var1_1.charAt(var2_2) != '\'') {
                    var0.type = (byte)-1;
                    var0.s = "Bad char";
                    return;
                }
                var0.type = (byte)2;
                var0.l = var4_11;
                var0.pos = var2_2 + 1;
                return;
            }
        }
        var0.type = (byte)-1;
        var0.s = "Unknown token";
    }

    public static DecodeReturn checkPreamble(String string, EvolutionState evolutionState, LineNumberReader lineNumberReader) {
        int n = 0;
        try {
            String string2 = "";
            while (string2 != null && string2.trim().equals("")) {
                n = lineNumberReader.getLineNumber();
                string2 = lineNumberReader.readLine();
            }
            if (string2 == null || !(string2 = string2.trim()).startsWith(string)) {
                evolutionState.output.fatal("Line " + n + "has bad preamble.  Expected '" + string + "'. -->" + string2);
            }
            DecodeReturn decodeReturn = new DecodeReturn(string2, string.length());
            decodeReturn.lineNumber = n;
            return decodeReturn;
        }
        catch (IOException iOException) {
            evolutionState.output.fatal("On line " + n + "an IO error occurred:\n\n" + iOException);
            return null;
        }
    }

    public static int readIntegerWithPreamble(String string, EvolutionState evolutionState, LineNumberReader lineNumberReader) {
        DecodeReturn decodeReturn = Code.checkPreamble(string, evolutionState, lineNumberReader);
        Code.decode(decodeReturn);
        if (decodeReturn.type != 4) {
            evolutionState.output.fatal("Line " + decodeReturn.lineNumber + "has no integer after preamble '" + string + "'. -->" + decodeReturn.data);
        }
        return (int)decodeReturn.l;
    }

    public static float readFloatWithPreamble(String string, EvolutionState evolutionState, LineNumberReader lineNumberReader) {
        DecodeReturn decodeReturn = Code.checkPreamble(string, evolutionState, lineNumberReader);
        Code.decode(decodeReturn);
        if (decodeReturn.type != 6) {
            evolutionState.output.fatal("Line " + decodeReturn.lineNumber + "has no floating point number after preamble '" + string + "'. -->" + decodeReturn.data);
        }
        return (float)decodeReturn.d;
    }

    public static double readDoubleWithPreamble(String string, EvolutionState evolutionState, LineNumberReader lineNumberReader) {
        DecodeReturn decodeReturn = Code.checkPreamble(string, evolutionState, lineNumberReader);
        Code.decode(decodeReturn);
        if (decodeReturn.type != 7) {
            evolutionState.output.fatal("Line " + decodeReturn.lineNumber + "has no double floating point number after preamble '" + string + "'. -->" + decodeReturn.data);
        }
        return decodeReturn.d;
    }

    public static boolean readBooleanWithPreamble(String string, EvolutionState evolutionState, LineNumberReader lineNumberReader) {
        DecodeReturn decodeReturn = Code.checkPreamble(string, evolutionState, lineNumberReader);
        Code.decode(decodeReturn);
        if (decodeReturn.type != 0) {
            evolutionState.output.fatal("Line " + decodeReturn.lineNumber + "has no boolean value ('true' or 'false') after preamble '" + string + "'. -->" + decodeReturn.data);
        }
        return decodeReturn.l != 0L;
    }
}

