/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataPipe {
    byte[] buffer = new byte[8192];
    int size = 0;
    int pull = 0;
    public DataInputStream input;
    public DataOutputStream output;

    void resize() {
        byte[] byArray = new byte[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
        this.buffer = byArray;
    }

    void push(byte by) {
        if (this.size >= this.buffer.length) {
            this.resize();
        }
        this.buffer[this.size++] = by;
    }

    void push(byte[] byArray, int n, int n2) {
        if (this.size + n2 > this.buffer.length) {
            this.resize();
        }
        System.arraycopy(byArray, n, this.buffer, this.size, n2);
        this.size += n2;
    }

    int pull() {
        byte by;
        if (this.pull == this.size) {
            return -1;
        }
        if ((by = this.buffer[this.pull++]) < 0) {
            return by + 256;
        }
        return by;
    }

    int pull(byte[] byArray, int n, int n2) {
        if (this.pull == this.size) {
            return -1;
        }
        if (n2 > this.size - this.pull) {
            n2 = this.size - this.pull;
        }
        System.arraycopy(this.buffer, this.pull, byArray, n, n2);
        this.pull += n2;
        return n2;
    }

    public DataPipe() {
        OutputStream outputStream = new OutputStream(){

            public void write(int n) throws IOException {
                DataPipe.this.push((byte)n);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                DataPipe.this.push(byArray, n, n2);
            }

            public void write(byte[] byArray) throws IOException {
                DataPipe.this.push(byArray, 0, byArray.length);
            }
        };
        this.output = new DataOutputStream(outputStream);
        InputStream inputStream = new InputStream(){

            public int read() throws IOException {
                return DataPipe.this.pull();
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                return DataPipe.this.pull(byArray, n, n2);
            }

            public int read(byte[] byArray) throws IOException {
                return DataPipe.this.pull(byArray, 0, byArray.length);
            }
        };
        this.input = new DataInputStream(inputStream);
    }

    public void reset() {
        this.size = 0;
        this.pull = 0;
    }

    public int size() {
        return this.buffer.length;
    }

    public int numWritten() {
        return this.size;
    }

    public int numRead() {
        return this.pull;
    }

    public String toString() {
        return "DataPipe(" + this.numWritten() + ", " + this.numRead() + ", " + this.size() + ")";
    }
}

