/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.LogRestarter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

public class Log
implements Serializable {
    public transient PrintWriter writer;
    public File filename;
    public int verbosity;
    public boolean postAnnouncements;
    public LogRestarter restarter;
    public boolean repostAnnouncementsOnRestart;
    public boolean appendOnRestart;
    public boolean isLoggingToSystemOut;
    public static final int D_STDOUT = 0;
    public static final int D_STDERR = 1;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.writer != null && !this.isLoggingToSystemOut) {
            this.writer.close();
        }
    }

    public Log(File file, int n, boolean bl, boolean bl2) throws IOException {
        this(file, n, bl, bl2, false);
    }

    public Log(File file, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.verbosity = n;
        this.postAnnouncements = bl;
        this.repostAnnouncementsOnRestart = !bl2;
        this.appendOnRestart = bl2;
        this.isLoggingToSystemOut = false;
        if (bl3) {
            this.filename = new File(String.valueOf(file.getAbsolutePath()) + ".gz");
            if (this.appendOnRestart) {
                throw new IOException("Cannot gzip and appendOnRestart at the same time: new Log(File,int,boolean,boolean,boolean)");
            }
            this.writer = new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(this.filename)))));
            this.restarter = new LogRestarter(){

                public Log restart(Log log) throws IOException {
                    return this.reopen(log);
                }

                public Log reopen(Log log) throws IOException {
                    if (log.writer != null && !log.isLoggingToSystemOut) {
                        log.writer.close();
                    }
                    log.writer = new PrintWriter(new OutputStreamWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(log.filename)))));
                    return log;
                }
            };
        } else {
            this.filename = file;
            this.writer = new PrintWriter(new BufferedWriter(new FileWriter(this.filename)));
            this.restarter = new LogRestarter(){

                public Log restart(Log log) throws IOException {
                    log.writer = new PrintWriter(new BufferedWriter(new FileWriter(log.filename.getPath(), log.appendOnRestart)));
                    return log;
                }

                public Log reopen(Log log) throws IOException {
                    if (log.writer != null && !Log.this.isLoggingToSystemOut) {
                        log.writer.close();
                    }
                    log.writer = new PrintWriter(new BufferedWriter(new FileWriter(log.filename)));
                    return log;
                }
            };
        }
    }

    public Log(int n, int n2, boolean bl) {
        this.filename = null;
        this.verbosity = n2;
        this.postAnnouncements = bl;
        this.repostAnnouncementsOnRestart = true;
        this.appendOnRestart = true;
        this.isLoggingToSystemOut = true;
        if (n == 0) {
            this.writer = new PrintWriter(System.out);
            this.restarter = new LogRestarter(){

                public Log restart(Log log) throws IOException {
                    log.writer = new PrintWriter(System.out);
                    return log;
                }

                public Log reopen(Log log) throws IOException {
                    return log;
                }
            };
        } else {
            this.writer = new PrintWriter(System.err);
            this.restarter = new LogRestarter(){

                public Log restart(Log log) throws IOException {
                    log.writer = new PrintWriter(System.err);
                    return log;
                }

                public Log reopen(Log log) throws IOException {
                    return log;
                }
            };
        }
    }

    public Log(Writer writer, LogRestarter logRestarter, int n, boolean bl, boolean bl2) {
        this.filename = null;
        this.verbosity = n;
        this.postAnnouncements = bl;
        this.repostAnnouncementsOnRestart = bl2;
        this.appendOnRestart = true;
        this.isLoggingToSystemOut = false;
        this.writer = new PrintWriter(new BufferedWriter(writer));
        this.restarter = logRestarter;
    }

    public Log restart() throws IOException {
        return this.restarter.restart(this);
    }

    public Log reopen() throws IOException {
        return this.restarter.reopen(this);
    }
}

