/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public strictfp class MersenneTwister
extends Random
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4035832775130174188L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;

    public Object clone() {
        try {
            MersenneTwister mersenneTwister = (MersenneTwister)super.clone();
            mersenneTwister.mt = (int[])this.mt.clone();
            mersenneTwister.mag01 = (int[])this.mag01.clone();
            return mersenneTwister;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean stateEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof MersenneTwister)) {
            return false;
        }
        MersenneTwister mersenneTwister = (MersenneTwister)object;
        if (this.mti != mersenneTwister.mti) {
            return false;
        }
        int n = 0;
        while (n < this.mag01.length) {
            if (this.mag01[n] != mersenneTwister.mag01[n]) {
                return false;
            }
            ++n;
        }
        n = 0;
        while (n < this.mt.length) {
            if (this.mt[n] != mersenneTwister.mt[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void readState(DataInputStream dataInputStream) throws IOException {
        int n = this.mt.length;
        int n2 = 0;
        while (n2 < n) {
            this.mt[n2] = dataInputStream.readInt();
            ++n2;
        }
        n = this.mag01.length;
        n2 = 0;
        while (n2 < n) {
            this.mag01[n2] = dataInputStream.readInt();
            ++n2;
        }
        this.mti = dataInputStream.readInt();
        this.__nextNextGaussian = dataInputStream.readDouble();
        this.__haveNextNextGaussian = dataInputStream.readBoolean();
    }

    public void writeState(DataOutputStream dataOutputStream) throws IOException {
        int n = this.mt.length;
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeInt(this.mt[n2]);
            ++n2;
        }
        n = this.mag01.length;
        n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeInt(this.mag01[n2]);
            ++n2;
        }
        dataOutputStream.writeInt(this.mti);
        dataOutputStream.writeDouble(this.__nextNextGaussian);
        dataOutputStream.writeBoolean(this.__haveNextNextGaussian);
    }

    public MersenneTwister() {
        this(System.currentTimeMillis());
    }

    public MersenneTwister(long l) {
        super(l);
        this.setSeed(l);
    }

    public MersenneTwister(int[] nArray) {
        super(System.currentTimeMillis());
        this.setSeed(nArray);
    }

    public synchronized void setSeed(long l) {
        super.setSeed(l);
        this.__haveNextNextGaussian = false;
        this.mt = new int[624];
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
        this.mt[0] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            int n = this.mti++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFF;
        }
    }

    public synchronized void setSeed(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Array length must be greater than zero");
        }
        this.setSeed(19650218L);
        int n = 1;
        int n2 = 0;
        int n3 = 624 > nArray.length ? 624 : nArray.length;
        while (n3 != 0) {
            this.mt[n] = (this.mt[n] ^ (this.mt[n - 1] ^ this.mt[n - 1] >>> 30) * 1664525) + nArray[n2] + n2;
            int n4 = n++;
            this.mt[n4] = this.mt[n4] & 0xFFFFFFFF;
            ++n2;
            if (n >= 624) {
                this.mt[0] = this.mt[623];
                n = 1;
            }
            if (n2 >= nArray.length) {
                n2 = 0;
            }
            --n3;
        }
        n3 = 623;
        while (n3 != 0) {
            this.mt[n] = (this.mt[n] ^ (this.mt[n - 1] ^ this.mt[n - 1] >>> 30) * 1566083941) - n;
            int n5 = n++;
            this.mt[n5] = this.mt[n5] & 0xFFFFFFFF;
            if (n >= 624) {
                this.mt[0] = this.mt[623];
                n = 1;
            }
            --n3;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    protected synchronized int next(int n) {
        int n2;
        if (this.mti >= 624) {
            int[] nArray = this.mt;
            int[] nArray2 = this.mag01;
            int n3 = 0;
            while (n3 < 227) {
                n2 = nArray[n3] & Integer.MIN_VALUE | nArray[n3 + 1] & Integer.MAX_VALUE;
                nArray[n3] = nArray[n3 + 397] ^ n2 >>> 1 ^ nArray2[n2 & 1];
                ++n3;
            }
            while (n3 < 623) {
                n2 = nArray[n3] & Integer.MIN_VALUE | nArray[n3 + 1] & Integer.MAX_VALUE;
                nArray[n3] = nArray[n3 + -227] ^ n2 >>> 1 ^ nArray2[n2 & 1];
                ++n3;
            }
            n2 = nArray[623] & Integer.MIN_VALUE | nArray[0] & Integer.MAX_VALUE;
            nArray[623] = nArray[396] ^ n2 >>> 1 ^ nArray2[n2 & 1];
            this.mti = 0;
        }
        n2 = this.mt[this.mti++];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        return n2 >>> 32 - n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public boolean nextBoolean(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (f == 0.0f) {
            return false;
        }
        if (f == 1.0f) {
            return true;
        }
        return this.nextFloat() < f;
    }

    public boolean nextBoolean(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (d == 0.0) {
            return false;
        }
        if (d == 1.0) {
            return true;
        }
        return this.nextDouble() < d;
    }

    public int nextInt(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((n3 = this.next(31)) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    public long nextLong(long l) {
        long l2;
        long l3;
        if (l <= 0L) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        while ((l3 = this.nextLong() >>> 1) - (l2 = l3 % l) + (l - 1L) < 0L) {
        }
        return l2;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public void nextBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)this.next(8);
            ++n;
        }
    }

    public char nextChar() {
        return (char)this.next(16);
    }

    public short nextShort() {
        return (short)this.next(16);
    }

    public byte nextByte() {
        return (byte)this.next(8);
    }

    public synchronized double nextGaussian() {
        double d;
        double d2;
        double d3;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        while ((d3 = (d2 = 2.0 * this.nextDouble() - 1.0) * d2 + (d = 2.0 * this.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        double d4 = StrictMath.sqrt(-2.0 * StrictMath.log(d3) / d3);
        this.__nextNextGaussian = d * d4;
        this.__haveNextNextGaussian = true;
        return d2 * d4;
    }

    public static void main(String[] stringArray) {
        long l;
        MersenneTwister mersenneTwister = new MersenneTwister(new int[]{291, 564, 837, 1110});
        System.out.println("Output of MersenneTwister with new (2002/1/26) seeding mechanism");
        int n = 0;
        while (n < 1000) {
            l = mersenneTwister.nextInt();
            if (l < 0L) {
                l += 0x100000000L;
            }
            String string = String.valueOf(l);
            while (string.length() < 10) {
                string = " " + string;
            }
            System.out.print(String.valueOf(string) + " ");
            if (n % 5 == 4) {
                System.out.println();
            }
            ++n;
        }
        l = 4357L;
        System.out.println("\nTime to test grabbing 100000000 ints");
        mersenneTwister = new MersenneTwister(4357L);
        long l2 = System.currentTimeMillis();
        int n2 = 0;
        n = 0;
        while (n < 100000000) {
            n2 += mersenneTwister.nextInt();
            ++n;
        }
        System.out.println("Mersenne Twister: " + (System.currentTimeMillis() - l2) + "          Ignore this: " + n2);
        System.out.println("To compare this with java.util.Random, run this same test on MersenneTwisterFast.");
        System.out.println("The comparison with Random is removed from MersenneTwister because it is a proper");
        System.out.println("subclass of Random and this unfairly makes some of Random's methods un-inlinable,");
        System.out.println("so it would make Random look worse than it is.");
        System.out.println("\nGrab the first 1000 booleans");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextBoolean()) + " ");
            if (n % 8 == 7) {
                System.out.println();
            }
            ++n;
        }
        if (n % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab 1000 booleans of increasing probability using nextBoolean(double)");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextBoolean((double)n / 999.0)) + " ");
            if (n % 8 == 7) {
                System.out.println();
            }
            ++n;
        }
        if (n % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab 1000 booleans of increasing probability using nextBoolean(float)");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextBoolean((float)n / 999.0f)) + " ");
            if (n % 8 == 7) {
                System.out.println();
            }
            ++n;
        }
        if (n % 8 != 7) {
            System.out.println();
        }
        byte[] byArray = new byte[1000];
        System.out.println("\nGrab the first 1000 bytes using nextBytes");
        mersenneTwister = new MersenneTwister(4357L);
        mersenneTwister.nextBytes(byArray);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(byArray[n]) + " ");
            if (n % 16 == 15) {
                System.out.println();
            }
            ++n;
        }
        if (n % 16 != 15) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 bytes -- must be same as nextBytes");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            byte by = mersenneTwister.nextByte();
            System.out.print(String.valueOf(by) + " ");
            if (by != byArray[n]) {
                System.out.print("BAD ");
            }
            if (n % 16 == 15) {
                System.out.println();
            }
            ++n;
        }
        if (n % 16 != 15) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 shorts");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextShort()) + " ");
            if (n % 8 == 7) {
                System.out.println();
            }
            ++n;
        }
        if (n % 8 != 7) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 ints");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextInt()) + " ");
            if (n % 4 == 3) {
                System.out.println();
            }
            ++n;
        }
        if (n % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 ints of different sizes");
        mersenneTwister = new MersenneTwister(4357L);
        int n3 = 1;
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextInt(n3)) + " ");
            if ((n3 *= 2) <= 0) {
                n3 = 1;
            }
            if (n % 4 == 3) {
                System.out.println();
            }
            ++n;
        }
        if (n % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 longs");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextLong()) + " ");
            if (n % 3 == 2) {
                System.out.println();
            }
            ++n;
        }
        if (n % 3 != 2) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 longs of different sizes");
        mersenneTwister = new MersenneTwister(4357L);
        long l3 = 1L;
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextLong(l3)) + " ");
            if ((l3 *= 2L) <= 0L) {
                l3 = 1L;
            }
            if (n % 4 == 3) {
                System.out.println();
            }
            ++n;
        }
        if (n % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 floats");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextFloat()) + " ");
            if (n % 4 == 3) {
                System.out.println();
            }
            ++n;
        }
        if (n % 4 != 3) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 doubles");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextDouble()) + " ");
            if (n % 3 == 2) {
                System.out.println();
            }
            ++n;
        }
        if (n % 3 != 2) {
            System.out.println();
        }
        System.out.println("\nGrab the first 1000 gaussian doubles");
        mersenneTwister = new MersenneTwister(4357L);
        n = 0;
        while (n < 1000) {
            System.out.print(String.valueOf(mersenneTwister.nextGaussian()) + " ");
            if (n % 3 == 2) {
                System.out.println();
            }
            ++n;
        }
        if (n % 3 != 2) {
            System.out.println();
        }
    }
}

