/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.Announcement;
import ec.util.Log;
import ec.util.LogRestarter;
import ec.util.OutputException;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public class Output
implements Serializable {
    boolean errors = false;
    Vector logs = new Vector();
    Vector announcements = new Vector();
    int verbosity;
    boolean flush = true;
    boolean store = true;
    String filePrefix = "";
    public static final int ALL_LOGS = -1;
    public static final int V_VERBOSE = 0;
    public static final int V_NO_MESSAGES = 1000;
    public static final int V_NO_WARNINGS = 2000;
    public static final int V_NO_GENERAL = 3000;
    public static final int V_NO_ERRORS = 4000;
    public static final int V_TOTALLY_SILENT = 5000;
    HashSet oneTimeWarnings = new HashSet();

    public void setFilePrefix(String string) {
        this.filePrefix = string;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void exitWithError() {
        this.close();
        System.exit(1);
    }

    public synchronized void close() {
        this.flush();
        Enumeration enumeration = this.logs.elements();
        while (enumeration.hasMoreElements()) {
            Log log = (Log)enumeration.nextElement();
            if (log.isLoggingToSystemOut) continue;
            log.writer.close();
        }
    }

    public synchronized void flush() {
        Enumeration enumeration = this.logs.elements();
        while (enumeration.hasMoreElements()) {
            Log log = (Log)enumeration.nextElement();
            log.writer.flush();
        }
        System.out.flush();
        System.err.flush();
    }

    public Output(boolean bl, int n) {
        this.store = bl;
        this.verbosity = n;
    }

    public synchronized void setFlush(boolean bl) {
        this.flush = bl;
    }

    public synchronized boolean getFlush() {
        return this.flush;
    }

    public synchronized void setStore(boolean bl) {
        this.store = bl;
    }

    public synchronized boolean getStore() {
        return this.store;
    }

    public synchronized void setVerbosity(int n) {
        this.verbosity = n;
    }

    public synchronized int getVerbosity() {
        return this.verbosity;
    }

    public synchronized int addLog(File file, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (this.filePrefix != null && this.filePrefix.length() > 0) {
            file = new File(file.getParent(), String.valueOf(this.filePrefix) + file.getName());
        }
        this.logs.addElement(new Log(file, n, bl, bl2, bl3));
        return this.logs.size() - 1;
    }

    public synchronized int addLog(File file, int n, boolean bl, boolean bl2) throws IOException {
        if (this.filePrefix != null && this.filePrefix.length() > 0) {
            file = new File(file.getParent(), String.valueOf(this.filePrefix) + file.getName());
        }
        this.logs.addElement(new Log(file, n, bl, bl2));
        return this.logs.size() - 1;
    }

    public synchronized int addLog(int n, int n2, boolean bl) {
        this.logs.addElement(new Log(n, n2, bl));
        return this.logs.size() - 1;
    }

    public synchronized int addLog(Writer writer, LogRestarter logRestarter, int n, boolean bl, boolean bl2) {
        this.logs.addElement(new Log(writer, logRestarter, n, bl, bl2));
        return this.logs.size() - 1;
    }

    public synchronized int addLog(Log log) {
        this.logs.addElement(log);
        return this.logs.size() - 1;
    }

    public synchronized int numLogs() {
        return this.logs.size();
    }

    public synchronized Log log(int n) {
        return (Log)this.logs.elementAt(n);
    }

    public synchronized Log removeLog(int n) {
        Log log = this.log(n);
        this.logs.removeElementAt(n);
        return log;
    }

    public static void initialError(String string) {
        System.err.println("STARTUP ERROR:\n" + string);
        System.out.flush();
        System.err.flush();
        System.exit(1);
    }

    public static void initialError(String string, Parameter parameter) {
        System.err.println("STARTUP ERROR:\n" + string);
        if (parameter != null) {
            System.err.println("PARAMETER: " + parameter);
        }
        System.out.flush();
        System.err.flush();
        System.exit(1);
    }

    public static void initialError(String string, Parameter parameter, Parameter parameter2) {
        System.err.println("STARTUP ERROR:\n" + string);
        if (parameter != null) {
            System.err.println("PARAMETER: " + parameter);
        }
        if (parameter2 != null && parameter != null) {
            System.err.println("     ALSO: " + parameter2);
        }
        System.out.flush();
        System.err.flush();
        System.exit(1);
    }

    public static void initialMessage(String string) {
        System.err.println(string);
        System.err.flush();
    }

    public synchronized void systemMessage(String string) {
        this.println(string, 1000, -1, true);
    }

    public synchronized void fatal(String string) {
        this.println("FATAL ERROR:\n" + string, 5000, -1, true);
        this.exitWithError();
    }

    public synchronized void fatal(String string, Parameter parameter) {
        this.println("FATAL ERROR:\n" + string, 5000, -1, true);
        if (parameter != null) {
            this.println("PARAMETER: " + parameter, 5000, -1, true);
        }
        this.exitWithError();
    }

    public synchronized void fatal(String string, Parameter parameter, Parameter parameter2) {
        this.println("FATAL ERROR:\n" + string, 5000, -1, true);
        if (parameter != null) {
            this.println("PARAMETER: " + parameter, 5000, -1, true);
        }
        if (parameter2 != null && parameter != null) {
            this.println("     ALSO: " + parameter2, 5000, -1, true);
        } else {
            this.println("PARAMETER: " + parameter2, 5000, -1, true);
        }
        this.exitWithError();
    }

    public synchronized void error(String string) {
        this.println("ERROR:\n" + string, 4000, -1, true);
        this.errors = true;
    }

    public synchronized void error(String string, Parameter parameter) {
        this.println("ERROR:\n" + string, 5000, -1, true);
        if (parameter != null) {
            this.println("PARAMETER: " + parameter, 5000, -1, true);
        }
        this.errors = true;
    }

    public synchronized void error(String string, Parameter parameter, Parameter parameter2) {
        this.println("ERROR:\n" + string, 5000, -1, true);
        if (parameter != null) {
            this.println("PARAMETER: " + parameter, 5000, -1, true);
        }
        if (parameter2 != null && parameter != null) {
            this.println("     ALSO: " + parameter2, 5000, -1, true);
        } else {
            this.println("PARAMETER: " + parameter2, 5000, -1, true);
        }
        this.errors = true;
    }

    public synchronized void warning(String string, Parameter parameter, Parameter parameter2) {
        this.println("WARNING:\n" + string, 2000, -1, true);
        if (parameter != null) {
            this.println("PARAMETER: " + parameter, 5000, -1, true);
        }
        if (parameter2 != null && parameter != null) {
            this.println("     ALSO: " + parameter2, 5000, -1, true);
        } else {
            this.println("PARAMETER: " + parameter2, 5000, -1, true);
        }
    }

    public synchronized void warning(String string, Parameter parameter) {
        this.println("WARNING:\n" + string, 2000, -1, true);
        if (parameter != null) {
            this.println("PARAMETER: " + parameter, 5000, -1, true);
        }
    }

    public synchronized void warning(String string) {
        this.println("WARNING:\n" + string, 2000, -1, true);
    }

    public synchronized void warnOnce(String string) {
        if (!this.oneTimeWarnings.contains(string)) {
            this.oneTimeWarnings.add(string);
            this.println("ONCE-ONLY WARNING:\n" + string, 2000, -1, true);
        }
    }

    public synchronized void warnOnce(String string, Parameter parameter) {
        if (!this.oneTimeWarnings.contains(string)) {
            this.oneTimeWarnings.add(string);
            this.println("ONCE-ONLY WARNING:\n" + string, 2000, -1, true);
            if (parameter != null) {
                this.println("PARAMETER: " + parameter, 5000, -1, true);
            }
        }
    }

    public synchronized void warnOnce(String string, Parameter parameter, Parameter parameter2) {
        if (!this.oneTimeWarnings.contains(string)) {
            this.oneTimeWarnings.add(string);
            this.println("ONCE-ONLY WARNING:\n" + string, 2000, -1, true);
            if (parameter != null) {
                this.println("PARAMETER: " + parameter, 5000, -1, true);
            }
            if (parameter2 != null && parameter != null) {
                this.println("     ALSO: " + parameter2, 5000, -1, true);
            } else {
                this.println("PARAMETER: " + parameter2, 5000, -1, true);
            }
        }
    }

    public synchronized void message(String string) {
        this.println(string, 1000, -1, true);
    }

    public synchronized void reopen(int n) throws IOException {
        Log log = (Log)this.logs.elementAt(n);
        this.logs.setElementAt(log.reopen(), n);
    }

    public synchronized void reopen(int[] nArray) throws IOException {
        int n = 0;
        while (n < nArray.length) {
            Log log = (Log)this.logs.elementAt(nArray[n]);
            this.logs.setElementAt(log.reopen(), nArray[n]);
            ++n;
        }
    }

    protected synchronized void println(String string, int n, Log log, boolean bl, boolean bl2) throws OutputException {
        if (log.writer == null) {
            throw new OutputException("Log with a null writer: " + log);
        }
        if (!log.postAnnouncements && bl) {
            return;
        }
        if (log.verbosity >= n) {
            return;
        }
        if (this.verbosity >= n) {
            return;
        }
        log.writer.println(string);
        if (this.flush) {
            log.writer.flush();
        }
        if (this.store && bl && !bl2) {
            this.announcements.addElement(new Announcement(string, n));
        }
    }

    public synchronized void println(String string, int n, int n2, boolean bl) throws OutputException {
        if (n2 == -1) {
            int n3 = 0;
            while (n3 < this.logs.size()) {
                Log log = (Log)this.logs.elementAt(n3);
                if (log == null) {
                    throw new OutputException("Unknown log number" + log);
                }
                this.println(string, n, log, bl, false);
                ++n3;
            }
        } else {
            Log log = (Log)this.logs.elementAt(n2);
            if (log == null) {
                throw new OutputException("Unknown log number" + log);
            }
            this.println(string, n, log, bl, false);
        }
    }

    public synchronized void println(String string, int n, int[] nArray) throws OutputException {
        int n2 = 0;
        while (n2 < nArray.length) {
            this.println(string, n, (Log)this.logs.elementAt(nArray[n2]), false, false);
            ++n2;
        }
    }

    public synchronized void println(String string, int n, int n2) throws OutputException {
        this.println(string, n, (Log)this.logs.elementAt(n2), false, false);
    }

    protected synchronized void print(String string, int n, Log log) throws OutputException {
        if (log.writer == null) {
            throw new OutputException("Log with a null writer: " + log);
        }
        if (log.verbosity >= n) {
            return;
        }
        if (this.verbosity >= n) {
            return;
        }
        log.writer.print(string);
    }

    public synchronized void print(String string, int n, int n2) throws OutputException {
        if (n2 == -1) {
            int n3 = 0;
            while (n3 < this.logs.size()) {
                Log log = (Log)this.logs.elementAt(n3);
                if (log == null) {
                    throw new OutputException("Unknown log number" + log);
                }
                this.print(string, n, log);
                ++n3;
            }
        } else {
            Log log = (Log)this.logs.elementAt(n2);
            if (log == null) {
                throw new OutputException("Unknown log number" + log);
            }
            this.print(string, n, log);
        }
    }

    public synchronized void print(String string, int n, int[] nArray) throws OutputException {
        int n2 = 0;
        while (n2 < nArray.length) {
            this.print(string, n, nArray[n2]);
            ++n2;
        }
    }

    public synchronized void exitIfErrors() {
        if (this.errors) {
            this.println("SYSTEM EXITING FROM ERRORS\n", 5000, -1, true);
            this.exitWithError();
        }
    }

    public synchronized void clearErrors() {
        this.errors = false;
    }

    public synchronized void clearAnnouncements() {
        if (this.announcements != null) {
            this.announcements = new Vector();
        }
    }

    public synchronized void restart() throws IOException {
        int n = this.logs.size();
        int n2 = 0;
        while (n2 < n) {
            Log log = (Log)this.logs.elementAt(n2);
            log = log.restarter.restart(log);
            this.logs.setElementAt(log, n2);
            if (log.repostAnnouncementsOnRestart && this.store) {
                int n3 = this.announcements.size();
                int n4 = 0;
                while (n4 < n3) {
                    Announcement announcement = (Announcement)this.announcements.elementAt(n4);
                    this.println(announcement.text, announcement.verbosity, log, true, true);
                    ++n4;
                }
            }
            ++n2;
        }
        this.exitIfErrors();
    }

    public static InputStream makeCompressingInputStream(InputStream inputStream) {
        try {
            return (InputStream)Class.forName("com.jcraft.jzlib.ZInputStream").getConstructor(InputStream.class).newInstance(inputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static OutputStream makeCompressingOutputStream(OutputStream outputStream) {
        try {
            Class<?> clazz = Class.forName("com.jcraft.jzlib.JZlib");
            int n = clazz.getField("Z_BEST_SPEED").getInt(null);
            int n2 = clazz.getField("Z_SYNC_FLUSH").getInt(null);
            Class<?> clazz2 = Class.forName("com.jcraft.jzlib.ZOutputStream");
            Object obj = clazz2.getConstructor(OutputStream.class, Integer.TYPE).newInstance(outputStream, new Integer(n));
            clazz2.getMethod("setFlushMode", Integer.TYPE).invoke(obj, new Integer(n2));
            return (OutputStream)obj;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

