/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.ParamClassLoadException;
import ec.util.Parameter;
import ec.util.ParameterDatabaseEvent;
import ec.util.ParameterDatabaseListener;
import ec.util.ParameterDatabaseTreeModel;
import ec.util.ParameterDatabaseTreeNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class ParameterDatabase
extends Properties
implements Serializable {
    public static final String C_HERE = "$";
    public static final String UNKNOWN_VALUE = "";
    public static final String PRINT_PARAMS = "print-params";
    public static final int PS_UNKNOWN = -1;
    public static final int PS_NONE = 0;
    public static final int PS_PRINT_PARAMS = 1;
    public int printState = -1;
    Vector parents;
    File directory;
    String filename = "";
    boolean checked = false;
    Hashtable gotten;
    Hashtable accessed = new Hashtable();
    Vector listeners;

    public Object getInstanceForParameter(Parameter parameter, Parameter parameter2, Class clazz) throws ParamClassLoadException {
        Parameter parameter3;
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            parameter3 = parameter;
        } else if (this._exists(parameter2)) {
            parameter3 = parameter2;
        } else {
            throw new ParamClassLoadException("No class name provided.\nPARAMETER: " + parameter + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2));
        }
        try {
            Class<?> clazz2 = Class.forName(this.get(parameter3));
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new ParamClassLoadException("The class " + clazz2.getName() + "\ndoes not cast into the superclass " + clazz.getName() + "\nPARAMETER: " + parameter + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2));
            }
            if (clazz == clazz2) {
                throw new ParamClassLoadException("The class " + clazz2.getName() + "\nmust not be the same as the required superclass " + clazz.getName() + "\nPARAMETER: " + parameter + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2));
            }
            return clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParamClassLoadException("Class not found: " + this.get(parameter3) + "\nPARAMETER: " + parameter + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParamClassLoadException("Could not load class: " + this.get(parameter3) + "\nPARAMETER: " + parameter + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new ParamClassLoadException("The requested class is an interface or an abstract class: " + this.get(parameter3) + "\nPARAMETER: " + parameter + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ParamClassLoadException("The requested class cannot be initialized with the default initializer: " + this.get(parameter3) + "\nPARAMETER: " + parameter + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + illegalAccessException);
        }
    }

    public Object getInstanceForParameterEq(Parameter parameter, Parameter parameter2, Class clazz) throws ParamClassLoadException {
        Parameter parameter3;
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            parameter3 = parameter;
        } else if (this._exists(parameter2)) {
            parameter3 = parameter2;
        } else {
            throw new ParamClassLoadException("No class name provided.\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2));
        }
        try {
            Class<?> clazz2 = Class.forName(this.get(parameter3));
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new ParamClassLoadException("The class " + clazz2.getName() + "\ndoes not cast into the superclass " + clazz.getName() + "\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2));
            }
            return clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParamClassLoadException("Class not found: " + this.get(parameter3) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParamClassLoadException("Could not load class: " + this.get(parameter3) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new ParamClassLoadException("The requested class is an interface or an abstract class: " + this.get(parameter3) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ParamClassLoadException("The requested class cannot be initialized with the default initializer: " + this.get(parameter3) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + illegalAccessException);
        }
    }

    public Object getClassForParameter(Parameter parameter, Parameter parameter2, Class clazz) throws ParamClassLoadException {
        Parameter parameter3;
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            parameter3 = parameter;
        } else if (this._exists(parameter2)) {
            parameter3 = parameter2;
        } else {
            throw new ParamClassLoadException("No class name provided.\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2));
        }
        try {
            Class<?> clazz2 = Class.forName(this.get(parameter3));
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new ParamClassLoadException("The class " + clazz2.getName() + "\ndoes not cast into the superclass " + clazz.getName() + "\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2));
            }
            return clazz2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParamClassLoadException("Class not found: " + this.get(parameter3) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParamClassLoadException("Could not load class: " + this.get(parameter3) + "\nPARAMETER: " + parameter + "\n     ALSO: " + (parameter2 == null ? UNKNOWN_VALUE : "\n     ALSO: " + parameter2) + "\nEXCEPTION: \n\n" + illegalArgumentException);
        }
    }

    public boolean getBoolean(Parameter parameter, Parameter parameter2, boolean bl) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getBoolean(parameter, bl);
        }
        return this.getBoolean(parameter2, bl);
    }

    boolean getBoolean(Parameter parameter, boolean bl) {
        if (!this._exists(parameter)) {
            return bl;
        }
        return !this.get(parameter).equalsIgnoreCase("false");
    }

    int parseInt(String string) throws NumberFormatException {
        if (string != null && string.length() > 0) {
            char c = 'x';
            if (string.charAt(0) == 'x' || c == 'X') {
                return Integer.parseInt(string.substring(1), 16);
            }
        }
        return Integer.parseInt(string);
    }

    long parseLong(String string) throws NumberFormatException {
        if (string != null && string.length() > 0) {
            char c = 'x';
            if (string.charAt(0) == 'x' || c == 'X') {
                return Long.parseLong(string.substring(1), 16);
            }
        }
        return Long.parseLong(string);
    }

    int getInt(Parameter parameter) throws NumberFormatException {
        if (this._exists(parameter)) {
            try {
                return this.parseInt(this.get(parameter));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Bad integer (" + this.get(parameter) + " ) for parameter " + parameter);
            }
        }
        throw new NumberFormatException("Integer does not exist for parameter " + parameter);
    }

    public int getInt(Parameter parameter, Parameter parameter2) throws NumberFormatException {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getInt(parameter);
        }
        if (this._exists(parameter2)) {
            return this.getInt(parameter2);
        }
        throw new NumberFormatException("Integer does not exist for either parameter " + parameter + "\nor\n" + parameter2);
    }

    public int getInt(Parameter parameter, Parameter parameter2, int n) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getInt(parameter, n);
        }
        return this.getInt(parameter2, n);
    }

    int getInt(Parameter parameter, int n) {
        if (this._exists(parameter)) {
            try {
                int n2 = this.parseInt(this.get(parameter));
                if (n2 < n) {
                    return n - 1;
                }
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n - 1;
            }
        }
        return n - 1;
    }

    public int getIntWithDefault(Parameter parameter, Parameter parameter2, int n) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getIntWithDefault(parameter, n);
        }
        return this.getIntWithDefault(parameter2, n);
    }

    int getIntWithDefault(Parameter parameter, int n) {
        if (this._exists(parameter)) {
            try {
                return this.parseInt(this.get(parameter));
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    public int getIntWithMax(Parameter parameter, Parameter parameter2, int n, int n2) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getIntWithMax(parameter, n, n2);
        }
        return this.getIntWithMax(parameter2, n, n2);
    }

    int getIntWithMax(Parameter parameter, int n, int n2) {
        if (this._exists(parameter)) {
            try {
                int n3 = this.parseInt(this.get(parameter));
                if (n3 < n) {
                    return n - 1;
                }
                if (n3 > n2) {
                    return n - 1;
                }
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                return n - 1;
            }
        }
        return n - 1;
    }

    public float getFloat(Parameter parameter, Parameter parameter2, double d) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getFloat(parameter, d);
        }
        return this.getFloat(parameter2, d);
    }

    float getFloat(Parameter parameter, double d) {
        if (this._exists(parameter)) {
            try {
                float f = Float.valueOf(this.get(parameter)).floatValue();
                if ((double)f < d) {
                    return (float)(d - 1.0);
                }
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                return (float)(d - 1.0);
            }
        }
        return (float)(d - 1.0);
    }

    public float getFloatWithDefault(Parameter parameter, Parameter parameter2, double d) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getFloatWithDefault(parameter, d);
        }
        return this.getFloatWithDefault(parameter2, d);
    }

    float getFloatWithDefault(Parameter parameter, double d) {
        if (this._exists(parameter)) {
            try {
                return Float.valueOf(this.get(parameter)).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                return (float)d;
            }
        }
        return (float)d;
    }

    public float getFloat(Parameter parameter, Parameter parameter2, double d, double d2) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getFloat(parameter, d, d2);
        }
        return this.getFloat(parameter2, d, d2);
    }

    float getFloat(Parameter parameter, double d, double d2) {
        if (this._exists(parameter)) {
            try {
                float f = Float.valueOf(this.get(parameter)).floatValue();
                if ((double)f < d) {
                    return (float)(d - 1.0);
                }
                if ((double)f > d2) {
                    return (float)(d - 1.0);
                }
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                return (float)(d - 1.0);
            }
        }
        return (float)(d - 1.0);
    }

    public int getDouble(Parameter parameter, Parameter parameter2) throws NumberFormatException {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getInt(parameter);
        }
        if (this._exists(parameter2)) {
            return this.getInt(parameter2);
        }
        throw new NumberFormatException("Integer does not exist for either parameter " + parameter + "\nor\n" + parameter2);
    }

    public double getDouble(Parameter parameter, Parameter parameter2, double d) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getDouble(parameter, d);
        }
        return this.getDouble(parameter2, d);
    }

    double getDouble(Parameter parameter, double d) {
        if (this._exists(parameter)) {
            try {
                double d2 = Double.valueOf(this.get(parameter));
                if (d2 < d) {
                    return d - 1.0;
                }
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                return d - 1.0;
            }
        }
        return d - 1.0;
    }

    public double getDouble(Parameter parameter, Parameter parameter2, double d, double d2) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getDouble(parameter, d, d2);
        }
        return this.getDouble(parameter2, d, d2);
    }

    double getDouble(Parameter parameter, double d, double d2) {
        if (this._exists(parameter)) {
            try {
                double d3 = Double.valueOf(this.get(parameter));
                if (d3 < d) {
                    return d - 1.0;
                }
                if (d3 > d2) {
                    return d - 1.0;
                }
                return d3;
            }
            catch (NumberFormatException numberFormatException) {
                return d - 1.0;
            }
        }
        return d - 1.0;
    }

    public double getDoubleWithDefault(Parameter parameter, Parameter parameter2, double d) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getDoubleWithDefault(parameter, d);
        }
        return this.getDoubleWithDefault(parameter2, d);
    }

    double getDoubleWithDefault(Parameter parameter, double d) {
        if (this._exists(parameter)) {
            try {
                return Double.valueOf(this.get(parameter));
            }
            catch (NumberFormatException numberFormatException) {
                return d;
            }
        }
        return d;
    }

    long getLong(Parameter parameter) throws NumberFormatException {
        if (this._exists(parameter)) {
            try {
                return this.parseLong(this.get(parameter));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Bad long (" + this.get(parameter) + " ) for parameter " + parameter);
            }
        }
        throw new NumberFormatException("Long does not exist for parameter " + parameter);
    }

    public long getLong(Parameter parameter, Parameter parameter2) throws NumberFormatException {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getLong(parameter);
        }
        if (this._exists(parameter2)) {
            return this.getLong(parameter2);
        }
        throw new NumberFormatException("Long does not exist for either parameter " + parameter + "\nor\n" + parameter2);
    }

    public long getLong(Parameter parameter, Parameter parameter2, long l) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getLong(parameter, l);
        }
        return this.getLong(parameter2, l);
    }

    long getLong(Parameter parameter, long l) {
        if (this._exists(parameter)) {
            try {
                long l2 = this.parseLong(this.get(parameter));
                if (l2 < l) {
                    return l - 1L;
                }
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                return l - 1L;
            }
        }
        return l - 1L;
    }

    public long getLongWithDefault(Parameter parameter, Parameter parameter2, long l) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getLongWithDefault(parameter, l);
        }
        return this.getLongWithDefault(parameter2, l);
    }

    long getLongWithDefault(Parameter parameter, long l) {
        if (this._exists(parameter)) {
            try {
                return this.parseLong(this.get(parameter));
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }
        return l;
    }

    public long getLongWithMax(Parameter parameter, Parameter parameter2, long l, long l2) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getLong(parameter, l, l2);
        }
        return this.getLong(parameter2, l, l2);
    }

    long getLongWithMax(Parameter parameter, long l, long l2) {
        if (this._exists(parameter)) {
            try {
                long l3 = this.parseLong(this.get(parameter));
                if (l3 < l) {
                    return l - 1L;
                }
                if (l3 > l2) {
                    return l - 1L;
                }
                return l3;
            }
            catch (NumberFormatException numberFormatException) {
                return l - 1L;
            }
        }
        return l - 1L;
    }

    public long getLong(Parameter parameter, Parameter parameter2, long l, long l2) {
        this.printGotten(parameter, parameter2, false);
        return this.getLongWithMax(parameter, parameter2, l, l2);
    }

    long getLong(Parameter parameter, long l, long l2) {
        return this.getLongWithMax(parameter, l, l2);
    }

    public File getFile(Parameter parameter, Parameter parameter2) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getFile(parameter);
        }
        return this.getFile(parameter2);
    }

    File getFile(Parameter parameter) {
        if (this._exists(parameter)) {
            String string = this.get(parameter);
            if (string == null) {
                return null;
            }
            if (string.startsWith(C_HERE)) {
                return new File(string.substring(C_HERE.length()));
            }
            File file = new File(string);
            if (file.isAbsolute()) {
                return file;
            }
            return new File(this.directoryFor(parameter), string);
        }
        return null;
    }

    public synchronized String getString(Parameter parameter, Parameter parameter2) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getString(parameter);
        }
        return this.getString(parameter2);
    }

    synchronized String getString(Parameter parameter) {
        if (this._exists(parameter)) {
            return this.get(parameter);
        }
        return null;
    }

    public String getStringWithDefault(Parameter parameter, Parameter parameter2, String string) {
        this.printGotten(parameter, parameter2, false);
        if (this._exists(parameter)) {
            return this.getStringWithDefault(parameter, string);
        }
        return this.getStringWithDefault(parameter2, string);
    }

    String getStringWithDefault(Parameter parameter, String string) {
        if (this._exists(parameter)) {
            String string2 = this.get(parameter);
            if (string2 == null) {
                if (string == null) {
                    return null;
                }
                string2 = string.trim();
            } else if ((string2 = string2.trim()).length() == 0) {
                if (string == null) {
                    return null;
                }
                string2 = string.trim();
            }
            return string2;
        }
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    synchronized void uncheck() {
        if (!this.checked) {
            return;
        }
        this.checked = false;
        int n = this.parents.size();
        int n2 = 0;
        while (n2 < n) {
            ((ParameterDatabase)this.parents.elementAt(n2)).uncheck();
            ++n2;
        }
    }

    public synchronized void addListener(ParameterDatabaseListener parameterDatabaseListener) {
        this.listeners.add(parameterDatabaseListener);
    }

    public synchronized void removeListener(ParameterDatabaseListener parameterDatabaseListener) {
        this.listeners.remove(parameterDatabaseListener);
    }

    public synchronized void fireParameterSet(Parameter parameter, String string) {
        for (ParameterDatabaseListener parameterDatabaseListener : this.listeners) {
            parameterDatabaseListener.parameterSet(new ParameterDatabaseEvent(this, parameter, string, 0));
        }
    }

    public synchronized void fireParameterAccessed(Parameter parameter, String string) {
        for (ParameterDatabaseListener parameterDatabaseListener : this.listeners) {
            parameterDatabaseListener.parameterSet(new ParameterDatabaseEvent(this, parameter, string, 1));
        }
    }

    public synchronized void set(Parameter parameter, String string) {
        String string2 = string.trim();
        this.put(parameter.param, string2);
        this.fireParameterSet(parameter, string2);
    }

    public synchronized void listGotten(PrintWriter printWriter) {
        Vector vector = new Vector();
        Enumeration enumeration = this.gotten.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        Collections.sort(vector);
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            String string2 = null;
            if (string != null) {
                string2 = this._get(string);
                this.uncheck();
            }
            if (string2 == null) {
                string2 = UNKNOWN_VALUE;
            }
            printWriter.println(String.valueOf(string) + " = " + string2);
            ++n;
        }
        printWriter.flush();
    }

    public synchronized void listNotGotten(PrintWriter printWriter) {
        Vector vector = new Vector();
        Hashtable hashtable = new Hashtable();
        this._list(null, false, null, hashtable);
        Enumeration enumeration = this.gotten.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.remove(enumeration.nextElement());
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        Collections.sort(vector);
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            String string2 = null;
            if (string != null) {
                string2 = this._get(string);
                this.uncheck();
            }
            if (string2 == null) {
                string2 = UNKNOWN_VALUE;
            }
            printWriter.println(String.valueOf(string) + " = " + string2);
            ++n;
        }
        printWriter.flush();
    }

    public synchronized void listNotAccessed(PrintWriter printWriter) {
        Vector vector = new Vector();
        Hashtable hashtable = new Hashtable();
        this._list(null, false, null, hashtable);
        Enumeration enumeration = this.accessed.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.remove(enumeration.nextElement());
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        Collections.sort(vector);
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            String string2 = null;
            if (string != null) {
                string2 = this._get(string);
                this.uncheck();
            }
            if (string2 == null) {
                string2 = UNKNOWN_VALUE;
            }
            printWriter.println(String.valueOf(string) + " = " + string2);
            ++n;
        }
        printWriter.flush();
    }

    public synchronized void listAccessed(PrintWriter printWriter) {
        Vector vector = new Vector();
        Enumeration enumeration = this.accessed.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        Collections.sort(vector);
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            String string2 = null;
            if (string != null) {
                string2 = this._get(string);
                this.uncheck();
            }
            if (string2 == null) {
                string2 = UNKNOWN_VALUE;
            }
            printWriter.println(String.valueOf(string) + " = " + string2);
            ++n;
        }
        printWriter.flush();
    }

    public synchronized boolean exists(Parameter parameter) {
        this.printGotten(parameter, null, true);
        return this._exists(parameter);
    }

    synchronized boolean _exists(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        String string = this._get(parameter.param);
        this.uncheck();
        this.accessed.put(parameter.param, Boolean.TRUE);
        return string != null;
    }

    public synchronized boolean exists(Parameter parameter, Parameter parameter2) {
        this.printGotten(parameter, parameter2, true);
        if (this.exists(parameter)) {
            return true;
        }
        return this.exists(parameter2);
    }

    void printGotten(Parameter parameter, Parameter parameter2, boolean bl) {
        String string;
        Object object;
        if (this.printState == -1) {
            object = new Parameter(PRINT_PARAMS);
            string = this.get((Parameter)object);
            this.printState = string == null || string.equalsIgnoreCase("false") ? 0 : 1;
            this.uncheck();
            this.printGotten((Parameter)object, null, false);
        }
        if (this.printState == 1) {
            object = "P: ";
            if (bl) {
                object = "E: ";
            }
            if (parameter == null && parameter2 == null) {
                return;
            }
            if (parameter == null) {
                string = this._get(parameter2.param);
                this.uncheck();
                if (string == null) {
                    System.err.println("\t!" + (String)object + parameter2.param);
                } else {
                    System.err.println("\t " + (String)object + parameter2.param + " = " + string);
                }
            } else if (parameter2 == null) {
                string = this._get(parameter.param);
                this.uncheck();
                if (string == null) {
                    System.err.println("\t!" + (String)object + parameter.param);
                } else {
                    System.err.println("\t " + (String)object + parameter.param + " = " + string);
                }
            } else {
                string = this._get(parameter.param);
                this.uncheck();
                if (string == null) {
                    System.err.println("\t!" + (String)object + parameter.param);
                    string = this._get(parameter2.param);
                    this.uncheck();
                    if (string == null) {
                        System.err.println("\t!" + (String)object + parameter2.param);
                    } else {
                        System.err.println("\t " + (String)object + parameter2.param + " = " + string);
                    }
                } else {
                    System.err.println("\t " + (String)object + parameter.param + " = " + string);
                    System.err.println("\t<" + (String)object + parameter2.param);
                }
            }
        }
    }

    synchronized String get(Parameter parameter) {
        String string = this._get(parameter.param);
        this.uncheck();
        if (parameter != null) {
            this.accessed.put(parameter.param, Boolean.TRUE);
        }
        if (parameter != null) {
            this.gotten.put(parameter.param, Boolean.TRUE);
        }
        return string;
    }

    synchronized String _get(String string) {
        if (string == null) {
            return null;
        }
        if (this.checked) {
            return null;
        }
        this.checked = true;
        String string2 = this.getProperty(string);
        if (string2 == null) {
            int n = this.parents.size();
            int n2 = 0;
            while (n2 < n) {
                string2 = ((ParameterDatabase)this.parents.elementAt(n2))._get(string);
                if (string2 != null) {
                    return string2;
                }
                ++n2;
            }
        } else if ((string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    Set _getShadowedValues(Parameter parameter, Set set) {
        if (parameter == null) {
            return set;
        }
        if (this.checked) {
            return set;
        }
        this.checked = true;
        String string = this.getProperty(parameter.param);
        if (string != null && (string = string.trim()).length() != 0) {
            set.add(string);
        }
        int n = this.parents.size();
        int n2 = 0;
        while (n2 < n) {
            ((ParameterDatabase)this.parents.elementAt(n2))._getShadowedValues(parameter, set);
            ++n2;
        }
        return set;
    }

    public Set getShadowedValues(Parameter parameter) {
        Set set = new HashSet();
        set = this._getShadowedValues(parameter, set);
        this.uncheck();
        return set;
    }

    public File directoryFor(Parameter parameter) {
        File file = this._directoryFor(parameter);
        this.uncheck();
        return file;
    }

    synchronized File _directoryFor(Parameter parameter) {
        if (this.checked) {
            return null;
        }
        this.checked = true;
        File file = null;
        String string = this.getProperty(parameter.param);
        if (string == null) {
            int n = this.parents.size();
            int n2 = 0;
            while (n2 < n) {
                file = ((ParameterDatabase)this.parents.elementAt(n2))._directoryFor(parameter);
                if (file != null) {
                    return file;
                }
                ++n2;
            }
            return file;
        }
        return this.directory;
    }

    public File fileFor(Parameter parameter) {
        File file = this._fileFor(parameter);
        this.uncheck();
        return file;
    }

    synchronized File _fileFor(Parameter parameter) {
        if (this.checked) {
            return null;
        }
        this.checked = true;
        File file = null;
        String string = this.getProperty(parameter.param);
        if (string == null) {
            int n = this.parents.size();
            int n2 = 0;
            while (n2 < n) {
                file = ((ParameterDatabase)this.parents.elementAt(n2))._fileFor(parameter);
                if (file != null) {
                    return file;
                }
                ++n2;
            }
            return file;
        }
        return new File(this.directory, this.filename);
    }

    public synchronized void remove(Parameter parameter) {
        if (parameter.param.equals(PRINT_PARAMS)) {
            this.printState = -1;
        }
        this.remove(parameter.param);
    }

    public synchronized void removeDeeply(Parameter parameter) {
        this._removeDeeply(parameter);
        this.uncheck();
    }

    synchronized void _removeDeeply(Parameter parameter) {
        if (this.checked) {
            return;
        }
        this.checked = true;
        this.remove(parameter);
        int n = this.parents.size();
        int n2 = 0;
        while (n2 < n) {
            ((ParameterDatabase)this.parents.elementAt(n2)).removeDeeply(parameter);
            ++n2;
        }
    }

    public void addParent(ParameterDatabase parameterDatabase) {
        this.parents.addElement(parameterDatabase);
    }

    public ParameterDatabase() {
        this.gotten = new Hashtable();
        this.directory = new File(new File(UNKNOWN_VALUE).getAbsolutePath());
        this.parents = new Vector();
        this.listeners = new Vector();
    }

    public ParameterDatabase(Dictionary dictionary) throws FileNotFoundException, IOException {
        this();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.set(new Parameter(UNKNOWN_VALUE + k), UNKNOWN_VALUE + dictionary.get(k));
        }
        int n = 0;
        String string;
        while ((string = this.getProperty("parent." + n)) != null) {
            if (!new File(string).isAbsolute()) {
                throw new FileNotFoundException("Attempt to load a relative file, but there's no parent file: " + string);
            }
            this.parents.addElement(new ParameterDatabase(new File(string)));
            ++n;
        }
        return;
    }

    public ParameterDatabase(String string, Class clazz) throws FileNotFoundException, IOException {
        this();
        this.load(clazz.getResourceAsStream(string));
        this.listeners = new Vector();
        int n = 0;
        String string2;
        while ((string2 = this.getProperty("parent." + n)) != null) {
            String string3 = new File(new File(string).getParent(), string2).toString();
            this.parents.addElement(new ParameterDatabase(string3, clazz));
            ++n;
        }
        return;
    }

    public ParameterDatabase(InputStream inputStream) throws FileNotFoundException, IOException {
        this();
        this.load(inputStream);
        this.listeners = new Vector();
        int n = 0;
        String string;
        while ((string = this.getProperty("parent." + n)) != null) {
            if (!new File(string).isAbsolute()) {
                throw new FileNotFoundException("Attempt to load a relative file, but there's no parent file: " + string);
            }
            this.parents.addElement(new ParameterDatabase(new File(string)));
            ++n;
        }
        return;
    }

    public ParameterDatabase(File file) throws FileNotFoundException, IOException {
        this();
        this.filename = file.getName();
        this.directory = new File(file.getParent());
        this.load(new FileInputStream(file));
        this.listeners = new Vector();
        int n = 0;
        String string;
        while ((string = this.getProperty("parent." + n)) != null) {
            if (new File(string).isAbsolute()) {
                this.parents.addElement(new ParameterDatabase(new File(string)));
            } else {
                this.parents.addElement(new ParameterDatabase(new File(file.getParent(), string)));
            }
            ++n;
        }
        return;
    }

    public ParameterDatabase(File file, String[] stringArray) throws FileNotFoundException, IOException {
        this();
        this.filename = file.getName();
        this.directory = new File(file.getParent());
        ParameterDatabase parameterDatabase = new ParameterDatabase(file);
        ParameterDatabase parameterDatabase2 = new ParameterDatabase();
        parameterDatabase2.parents.addElement(parameterDatabase);
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].equals("-p")) {
                parameterDatabase2.parseParameter(stringArray[n + 1]);
            }
            ++n;
        }
        this.parents.addElement(parameterDatabase2);
        this.listeners = new Vector();
    }

    boolean parseParameter(String string) {
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        if (string.charAt(0) == '#') {
            return false;
        }
        int n = string.indexOf(61);
        if (n < 0) {
            return false;
        }
        this.put(string.substring(0, n), string.substring(n + 1));
        return true;
    }

    public void list(PrintStream printStream, boolean bl) {
        this.list(new PrintWriter(printStream), bl);
    }

    public void list(PrintStream printStream) {
        this.list(new PrintWriter(printStream), false);
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, false);
    }

    public void list(PrintWriter printWriter, boolean bl) {
        if (bl) {
            this._list(printWriter, bl, "root", null);
        } else {
            Hashtable hashtable = new Hashtable();
            this._list(null, bl, "root", hashtable);
            Vector vector = new Vector();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            Collections.sort(vector);
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.get(n);
                String string2 = null;
                if (string != null) {
                    string2 = (String)hashtable.get(string);
                }
                if (string2 == null) {
                    string2 = UNKNOWN_VALUE;
                }
                if (printWriter != null) {
                    printWriter.println(String.valueOf(string) + " = " + string2);
                }
                ++n;
            }
        }
        if (printWriter != null) {
            printWriter.flush();
        }
    }

    void _list(PrintWriter printWriter, boolean bl, String string, Hashtable hashtable) {
        if (bl) {
            if (printWriter != null) {
                printWriter.println("\n########" + string);
            }
            super.list(printWriter);
            int n = this.parents.size();
            int n2 = 0;
            while (n2 < n) {
                ((ParameterDatabase)this.parents.elementAt(n2))._list(printWriter, bl, String.valueOf(string) + "." + n2, hashtable);
                ++n2;
            }
        } else {
            int n = this.parents.size();
            int n3 = n - 1;
            while (n3 >= 0) {
                ((ParameterDatabase)this.parents.elementAt(n3))._list(printWriter, bl, string, hashtable);
                --n3;
            }
            Enumeration<Object> enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                hashtable.put(string2, this.get(string2));
            }
        }
        if (printWriter != null) {
            printWriter.flush();
        }
    }

    public String toString() {
        String string = super.toString();
        if (this.parents.size() > 0) {
            string = String.valueOf(string) + " : (";
            int n = 0;
            while (n < this.parents.size()) {
                if (n > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + this.parents.elementAt(n);
                ++n;
            }
            string = String.valueOf(string) + ")";
        }
        return string;
    }

    public TreeModel buildTreeModel() {
        String string = System.getProperty("file.separator");
        ParameterDatabaseTreeNode parameterDatabaseTreeNode = new ParameterDatabaseTreeNode(String.valueOf(this.directory.getAbsolutePath()) + string + this.filename);
        ParameterDatabaseTreeModel parameterDatabaseTreeModel = new ParameterDatabaseTreeModel(parameterDatabaseTreeNode);
        this._buildTreeModel(parameterDatabaseTreeModel, parameterDatabaseTreeNode);
        parameterDatabaseTreeModel.sort(parameterDatabaseTreeNode, new Comparator(){

            public int compare(Object object, Object object2) {
                ParameterDatabaseTreeNode parameterDatabaseTreeNode = (ParameterDatabaseTreeNode)object;
                ParameterDatabaseTreeNode parameterDatabaseTreeNode2 = (ParameterDatabaseTreeNode)object2;
                return ((Comparable)parameterDatabaseTreeNode.getUserObject()).compareTo(parameterDatabaseTreeNode2.getUserObject());
            }
        });
        parameterDatabaseTreeModel.setVisibleLeaves(false);
        return parameterDatabaseTreeModel;
    }

    void _buildTreeModel(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<Object> enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            this._addNodeForParameter(defaultTreeModel, defaultMutableTreeNode, (String)enumeration.nextElement());
        }
        int n = this.parents.size();
        int n2 = 0;
        while (n2 < n) {
            ParameterDatabase parameterDatabase = (ParameterDatabase)this.parents.elementAt(n2);
            parameterDatabase._buildTreeModel(defaultTreeModel, defaultMutableTreeNode);
            ++n2;
        }
    }

    void _addNodeForParameter(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (string.indexOf("parent.") == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3 = defaultTreeModel.getChildCount(defaultMutableTreeNode2);
                if (n3 > 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode3;
                    int n4 = 0;
                    while (n4 < n3) {
                        defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n4);
                        if (defaultMutableTreeNode3.getUserObject().equals(stringArray[n2])) {
                            defaultMutableTreeNode2 = defaultMutableTreeNode3;
                            break;
                        }
                        ++n4;
                    }
                    if (n4 == n3) {
                        defaultMutableTreeNode3 = new ParameterDatabaseTreeNode(stringArray[n2]);
                        defaultTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        defaultMutableTreeNode2 = defaultMutableTreeNode3;
                    }
                } else {
                    ParameterDatabaseTreeNode parameterDatabaseTreeNode = new ParameterDatabaseTreeNode(stringArray[n2]);
                    defaultTreeModel.insertNodeInto(parameterDatabaseTreeNode, defaultMutableTreeNode2, 0);
                    defaultMutableTreeNode2 = parameterDatabaseTreeNode;
                }
                ++n2;
            }
        }
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException {
        ParameterDatabase parameterDatabase = new ParameterDatabase(new File(stringArray[0]), stringArray);
        parameterDatabase.set(new Parameter("Hi there"), "Whatever");
        parameterDatabase.set(new Parameter(new String[]{"1", "2", "3"}), " Whatever ");
        parameterDatabase.set(new Parameter(new String[]{"a", "b", "c"}).pop().push("d"), "Whatever");
        System.err.println("\n\n PRINTING ALL PARAMETERS \n\n");
        parameterDatabase.list(new PrintWriter(System.err, true), true);
        System.err.println("\n\n PRINTING ONLY VALID PARAMETERS \n\n");
        parameterDatabase.list(new PrintWriter(System.err, true), false);
    }
}

