/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.util.RandomChoiceChooser;
import ec.util.RandomChoiceChooserD;

public class RandomChoice {
    public static void organizeDistribution(float[] fArray) {
        RandomChoice.organizeDistribution(fArray, false);
    }

    public static void organizeDistribution(float[] fArray, boolean bl) {
        double d = 0.0;
        if (fArray.length == 0) {
            throw new ArithmeticException("Distribution has no elements");
        }
        int n = 0;
        while (n < fArray.length) {
            if ((double)fArray[n] < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            d += (double)fArray[n];
            ++n;
        }
        if (d == 0.0) {
            if (!bl) {
                throw new ArithmeticException("Distribution has all zero probabilities");
            }
            n = 0;
            while (n < fArray.length) {
                fArray[n] = 1.0f;
                ++n;
            }
            d = fArray.length;
        }
        n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = (float)((double)fArray[n2] / d);
        }
        d = 0.0;
        n = 0;
        while (n < fArray.length) {
            fArray[n] = (float)(d += (double)fArray[n]);
            ++n;
        }
        n = fArray.length - 1;
        while (n > 0) {
            if (fArray[n] != fArray[n - 1]) break;
            fArray[n] = 1.0f;
            --n;
        }
        fArray[n] = 1.0f;
    }

    public static void organizeDistribution(double[] dArray) {
        RandomChoice.organizeDistribution(dArray, false);
    }

    public static void organizeDistribution(double[] dArray, boolean bl) {
        double d = 0.0;
        if (dArray.length == 0) {
            throw new ArithmeticException("Distribution has no elements");
        }
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            d += dArray[n];
            ++n;
        }
        if (d == 0.0) {
            if (!bl) {
                throw new ArithmeticException("Distribution has all zero probabilities");
            }
            n = 0;
            while (n < dArray.length) {
                dArray[n] = 1.0;
                ++n;
            }
            d = dArray.length;
        }
        n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
        d = 0.0;
        n = 0;
        while (n < dArray.length) {
            dArray[n] = d += dArray[n];
            ++n;
        }
        n = dArray.length - 1;
        while (n > 0) {
            if (dArray[n] != dArray[n - 1]) break;
            dArray[n] = 1.0;
            --n;
        }
        dArray[n] = 1.0;
    }

    public static void organizeDistribution(Object[] objectArray, RandomChoiceChooser randomChoiceChooser) {
        RandomChoice.organizeDistribution(objectArray, randomChoiceChooser, false);
    }

    public static void organizeDistribution(Object[] objectArray, RandomChoiceChooser randomChoiceChooser, boolean bl) {
        double d = 0.0;
        if (objectArray.length == 0) {
            throw new ArithmeticException("Distribution has no elements");
        }
        int n = 0;
        while (n < objectArray.length) {
            if ((double)randomChoiceChooser.getProbability(objectArray[n]) < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            d += (double)randomChoiceChooser.getProbability(objectArray[n]);
            ++n;
        }
        if (d == 0.0) {
            if (!bl) {
                throw new ArithmeticException("Distribution has all zero probabilities");
            }
            n = 0;
            while (n < objectArray.length) {
                randomChoiceChooser.setProbability(objectArray[n], 1.0f);
                ++n;
            }
            d = objectArray.length;
        }
        n = 0;
        while (n < objectArray.length) {
            randomChoiceChooser.setProbability(objectArray[n], (float)((double)randomChoiceChooser.getProbability(objectArray[n]) / d));
            ++n;
        }
        d = 0.0;
        n = 0;
        while (n < objectArray.length) {
            randomChoiceChooser.setProbability(objectArray[n], (float)(d += (double)randomChoiceChooser.getProbability(objectArray[n])));
            ++n;
        }
        n = objectArray.length - 1;
        while (n > 0) {
            if (randomChoiceChooser.getProbability(objectArray[n]) != randomChoiceChooser.getProbability(objectArray[n - 1])) break;
            randomChoiceChooser.setProbability(objectArray[n], 1.0f);
            --n;
        }
        randomChoiceChooser.setProbability(objectArray[n], 1.0f);
    }

    public static void organizeDistribution(Object[] objectArray, RandomChoiceChooserD randomChoiceChooserD) {
        RandomChoice.organizeDistribution(objectArray, randomChoiceChooserD, false);
    }

    public static void organizeDistribution(Object[] objectArray, RandomChoiceChooserD randomChoiceChooserD, boolean bl) {
        double d = 0.0;
        if (objectArray.length == 0) {
            throw new ArithmeticException("Distribution has no elements");
        }
        int n = 0;
        while (n < objectArray.length) {
            if (randomChoiceChooserD.getProbability(objectArray[n]) < 0.0) {
                throw new ArithmeticException("Distribution has negative probabilities");
            }
            d += randomChoiceChooserD.getProbability(objectArray[n]);
            ++n;
        }
        if (d == 0.0) {
            if (!bl) {
                throw new ArithmeticException("Distribution has all zero probabilities");
            }
            n = 0;
            while (n < objectArray.length) {
                randomChoiceChooserD.setProbability(objectArray[n], 1.0);
                ++n;
            }
            d = objectArray.length;
        }
        n = 0;
        while (n < objectArray.length) {
            randomChoiceChooserD.setProbability(objectArray[n], randomChoiceChooserD.getProbability(objectArray[n]) / d);
            ++n;
        }
        d = 0.0;
        n = 0;
        while (n < objectArray.length) {
            randomChoiceChooserD.setProbability(objectArray[n], d += randomChoiceChooserD.getProbability(objectArray[n]));
            ++n;
        }
        n = objectArray.length - 1;
        while (n > 0) {
            if (randomChoiceChooserD.getProbability(objectArray[n]) != randomChoiceChooserD.getProbability(objectArray[n - 1])) break;
            randomChoiceChooserD.setProbability(objectArray[n], 1.0);
            --n;
        }
        randomChoiceChooserD.setProbability(objectArray[n], 1.0);
    }

    /*
     * Unable to fully structure code
     */
    private static final int exemptZeroes(float[] var0, int var1_1) {
        block2: {
            if (var0[var1_1] != 0.0f) ** GOTO lbl7
            while (var1_1 < var0.length - 1 && var0[var1_1] == 0.0f) {
                ++var1_1;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                --var1_1;
lbl7:
                // 2 sources

                ** while (var1_1 > 0 && var0[var1_1] == var0[var1_1 - 1])
            }
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private static final int exemptZeroes(double[] var0, int var1_1) {
        block2: {
            if (var0[var1_1] != 0.0) ** GOTO lbl7
            while (var1_1 < var0.length - 1 && var0[var1_1] == 0.0) {
                ++var1_1;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                --var1_1;
lbl7:
                // 2 sources

                ** while (var1_1 > 0 && var0[var1_1] == var0[var1_1 - 1])
            }
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private static final int exemptZeroes(Object[] var0, RandomChoiceChooser var1_1, int var2_2) {
        block2: {
            if (var1_1.getProbability(var0[var2_2]) != 0.0f) ** GOTO lbl7
            while (var2_2 < var0.length - 1 && var1_1.getProbability(var0[var2_2]) == 0.0f) {
                ++var2_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl7:
                // 2 sources

                ** while (var2_2 > 0 && var1_1.getProbability((Object)var0[var2_2]) == var1_1.getProbability((Object)var0[var2_2 - 1]))
            }
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    private static final int exemptZeroes(Object[] var0, RandomChoiceChooserD var1_1, int var2_2) {
        block2: {
            if (var1_1.getProbability(var0[var2_2]) != 0.0) ** GOTO lbl7
            while (var2_2 < var0.length - 1 && var1_1.getProbability(var0[var2_2]) == 0.0) {
                ++var2_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl7:
                // 2 sources

                ** while (var2_2 > 0 && var1_1.getProbability((Object)var0[var2_2]) == var1_1.getProbability((Object)var0[var2_2 - 1]))
            }
        }
        return var2_2;
    }

    public static int pickFromDistribution(float[] fArray, float f, int n) {
        if (f < 0.0f || f > 1.0f) {
            throw new ArithmeticException("Invalid probability for pickFromDistribution (must be 0.0<=x<=1.0)");
        }
        if (fArray.length == 1) {
            return 0;
        }
        if (fArray.length < n) {
            int n2 = 0;
            while (n2 < fArray.length - 1) {
                if (fArray[n2] > f) {
                    return RandomChoice.exemptZeroes(fArray, n2);
                }
                ++n2;
            }
            return RandomChoice.exemptZeroes(fArray, fArray.length - 1);
        }
        int n3 = fArray.length - 1;
        int n4 = 0;
        while (n3 != n4) {
            int n5 = (n3 + n4) / 2;
            if (fArray[n5] > f) {
                if (n5 == 0 || fArray[n5 - 1] <= f) {
                    return RandomChoice.exemptZeroes(fArray, n5);
                }
                n3 = n5;
                continue;
            }
            if (n5 == fArray.length - 1) {
                return RandomChoice.exemptZeroes(fArray, n5);
            }
            if (n4 == n5) {
                ++n4;
                continue;
            }
            n4 = n5;
        }
        return RandomChoice.exemptZeroes(fArray, n4);
    }

    public static int pickFromDistribution(double[] dArray, double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new ArithmeticException("Invalid probability for pickFromDistribution (must be 0.0<=x<=1.0)");
        }
        if (dArray.length == 1) {
            return 0;
        }
        if (dArray.length < n) {
            int n2 = 0;
            while (n2 < dArray.length - 1) {
                if (dArray[n2] > d) {
                    return RandomChoice.exemptZeroes(dArray, n2);
                }
                ++n2;
            }
            return RandomChoice.exemptZeroes(dArray, dArray.length - 1);
        }
        int n3 = dArray.length - 1;
        int n4 = 0;
        while (n3 != n4) {
            int n5 = (n3 + n4) / 2;
            if (dArray[n5] > d) {
                if (n5 == 0 || dArray[n5 - 1] <= d) {
                    return RandomChoice.exemptZeroes(dArray, n5);
                }
                n3 = n5;
                continue;
            }
            if (n5 == dArray.length - 1) {
                return RandomChoice.exemptZeroes(dArray, n5);
            }
            if (n4 == n5) {
                ++n4;
                continue;
            }
            n4 = n5;
        }
        return RandomChoice.exemptZeroes(dArray, n4);
    }

    public static int pickFromDistribution(Object[] objectArray, RandomChoiceChooser randomChoiceChooser, float f, int n) {
        if (f < 0.0f || f > 1.0f) {
            throw new ArithmeticException("Invalid probability for pickFromDistribution (must be 0.0<=x<=1.0)");
        }
        if (objectArray.length == 1) {
            return 0;
        }
        if (objectArray.length < n) {
            int n2 = 0;
            while (n2 < objectArray.length - 1) {
                if (randomChoiceChooser.getProbability(objectArray[n2]) > f) {
                    return RandomChoice.exemptZeroes(objectArray, randomChoiceChooser, n2);
                }
                ++n2;
            }
            return RandomChoice.exemptZeroes(objectArray, randomChoiceChooser, objectArray.length - 1);
        }
        int n3 = objectArray.length - 1;
        int n4 = 0;
        while (n3 != n4) {
            int n5 = (n3 + n4) / 2;
            if (randomChoiceChooser.getProbability(objectArray[n5]) > f) {
                if (n5 == 0 || randomChoiceChooser.getProbability(objectArray[n5 - 1]) <= f) {
                    return RandomChoice.exemptZeroes(objectArray, randomChoiceChooser, n5);
                }
                n3 = n5;
                continue;
            }
            if (n5 == objectArray.length - 1) {
                return RandomChoice.exemptZeroes(objectArray, randomChoiceChooser, n5);
            }
            if (n4 == n5) {
                ++n4;
                continue;
            }
            n4 = n5;
        }
        return RandomChoice.exemptZeroes(objectArray, randomChoiceChooser, n4);
    }

    public static int pickFromDistribution(Object[] objectArray, RandomChoiceChooserD randomChoiceChooserD, double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new ArithmeticException("Invalid probability for pickFromDistribution (must be 0.0<=x<=1.0)");
        }
        if (objectArray.length == 1) {
            return 0;
        }
        if (objectArray.length < n) {
            int n2 = 0;
            while (n2 < objectArray.length - 1) {
                if (randomChoiceChooserD.getProbability(objectArray[n2]) > d) {
                    return RandomChoice.exemptZeroes(objectArray, randomChoiceChooserD, n2);
                }
                ++n2;
            }
            return RandomChoice.exemptZeroes(objectArray, randomChoiceChooserD, objectArray.length - 1);
        }
        int n3 = objectArray.length - 1;
        int n4 = 0;
        while (n3 != n4) {
            int n5 = (n3 + n4) / 2;
            if (randomChoiceChooserD.getProbability(objectArray[n5]) > d) {
                if (n5 == 0 || randomChoiceChooserD.getProbability(objectArray[n5 - 1]) <= d) {
                    return RandomChoice.exemptZeroes(objectArray, randomChoiceChooserD, n5);
                }
                n3 = n5;
                continue;
            }
            if (n5 == objectArray.length - 1) {
                return RandomChoice.exemptZeroes(objectArray, randomChoiceChooserD, n5);
            }
            if (n4 == n5) {
                ++n4;
                continue;
            }
            n4 = n5;
        }
        return RandomChoice.exemptZeroes(objectArray, randomChoiceChooserD, n4);
    }
}

