package ec.coevolve;

import ec.simple.SimpleEvaluator;
import ec.simple.SimpleFitness;
import ec.*;
import ec.util.*;

/** 
 * MultiPopCompetitiveEvaluator.java
 *

<p>MultiPopCompetitiveEvaluator is an Evaluator which performs <i>coevolution evaluations</i>
with multiple subpopulations (the fitness of an individual depends on competitions with
individuals from other subpopulations).

 *
 * @author Liviu Panait
 * @version 1.0 
*/

public class MultiPopCompetitiveEvaluator extends Evaluator
    {
    public static final int STYLE_COMPETE_WITH_BEST=1;
    public static final String competeStyle = "style";
    public int style;

    Individual best_of_subpops[];

    /**
       How many times to repeat the play against one opponent.
       Default value: 1
       To be adjusted in noisy problems!
     */
    public static final String P_N_GAMES = "repeat-play";
    public int nGames;

    public void setup( final EvolutionState state, final Parameter base )
	{
	super.setup( state, base );
	String temp;
	temp = state.parameters.getStringWithDefault( base.push( competeStyle ), null, "" );
	if( temp.equalsIgnoreCase( "compete-with-best" ) )
	    {
	    style = STYLE_COMPETE_WITH_BEST;
	    }
	else
	    {
	    state.output.fatal( "Incorrect value for parameter. Acceptable values: " +
				"compete-with-best", base.push( competeStyle ) );
	    }

	nGames = state.parameters.getInt( base.push( P_N_GAMES ), null, 1 );
	if( nGames < 1 )
	    {
		state.output.message( "Incorrect value for parameter " +
				      base.push( P_N_GAMES ).toString() +
				      ", using default value 1." );
		nGames = 1;
	    }

	}

    public boolean runComplete( final EvolutionState state )
	{
	return false;
	}

    public void evaluatePopulation(final EvolutionState state)
        {

        GroupedProblemForm prob = (GroupedProblemForm)(p_problem.protoCloneSimple());
        for( int i = 0 ; i < state.population.subpops.length ; i++ )
	    prob.preprocessPopulation(state,state.population);

        switch(style)
            {
            case STYLE_COMPETE_WITH_BEST:
		evalCompeteWithBest( state, state.population, prob);
		break;
            }

	prob.postprocessPopulation(state, state.population);

	// now, if we need the best players from each subpopulation, collect them!
	if( style == STYLE_COMPETE_WITH_BEST )
	    {
	    for( int i = 0 ; i < state.population.subpops.length ; i++ )
		{
		best_of_subpops[i] = state.population.subpops[i].individuals[0];
		for( int j = 1 ; j < state.population.subpops[i].individuals.length ; j++ )
		    {
		    if( state.population.subpops[i].individuals[j].fitness.betterThan( best_of_subpops[i].fitness ) )
			best_of_subpops[i] = state.population.subpops[i].individuals[j];
		    }
		best_of_subpops[i] = best_of_subpops[i].deepClone();
		}
	    }

        }

    public void evalCompeteWithBest( final EvolutionState state,
				     final Population population,
				     final GroupedProblemForm prob )
        {

	if( state.generation == 0 )
	    {
	    // allocate the array
	    best_of_subpops = new Individual[state.population.subpops.length];
	    // copy the first individual in each subpopulation (they are already randomly generated)
	    for( int i = 0 ; i < best_of_subpops.length ; i++ )
		best_of_subpops[i] = state.population.subpops[i].individuals[0].deepClone();
	    }

	Individual[] players = new Individual[best_of_subpops.length];
	for( int i = 0 ; i < players.length ; i++ )
	    players[i] = best_of_subpops[i];

        boolean[] updates = new boolean[players.length];
	for( int i = 0 ; i < updates.length ; i++ )
	    updates[i] = false;

	for( int i = 0 ; i < population.subpops.length ; i++ )
	    {
	    updates[i] = true;
	    for( int j = 0 ; j < population.subpops[i].individuals.length ; j++ )
		{
		players[i] = population.subpops[i].individuals[j];
		for( int z = 0 ; z < nGames ; z++ )
		    {
			prob.evaluate(state,players,updates,0);
		    }		
		}
	    updates[i] = false;
	    players[i] = best_of_subpops[i];
	    }

	}

}
