/*
 * Created on Apr 16, 2005 12:25:57 PM
 * 
 * By: spaus
 */
package ec.display.chart;

import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import ec.EvolutionState;
import ec.Statistics;
import ec.util.Parameter;

/**
 * @author spaus
 */
public class ChartableStatistics
    extends Statistics {
    
    public static final String P_TITLE = "title";
    public static final String P_XAXIS = "x-axis-label";
    public static final String P_YAXIS = "y-axis-label";
    
    public XYSeriesCollection seriesCollection;
    public String title;
    public String xlabel;
    public String ylabel;
    
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        seriesCollection = new XYSeriesCollection();
        
        title = state.parameters.getStringWithDefault(base.push(P_TITLE),"Title");
        xlabel = state.parameters.getStringWithDefault(base.push(P_XAXIS),"x");
        ylabel = state.parameters.getStringWithDefault(base.push(P_YAXIS),"y");
    }
    
    public int addSeries(String name) {
        seriesCollection.addSeries(new XYSeries(name));
        return seriesCollection.getSeriesCount()-1;
    }

    public void addDataPoint(int seriesID, double x, double y) {
        seriesCollection.getSeries(seriesID).add(x,y);
    }
    }
