/*
 * Decompiled with CFR 0.152.
 */
package ec.app.ant;

import ec.EvolutionState;
import ec.Individual;
import ec.app.ant.func.EvalPrint;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class Ant
extends GPProblem
implements SimpleProblemForm {
    public static final String P_FILE = "file";
    public static final String P_MOVES = "moves";
    public static final int ERROR = 0;
    public static final int FOOD = -1;
    public static final int EMPTY = 1;
    public static final int TRAIL = 2;
    public static final int ATE = 3;
    public static final int O_UP = 0;
    public static final int O_LEFT = 1;
    public static final int O_DOWN = 2;
    public static final int O_RIGHT = 3;
    public int maxMoves;
    public int food;
    public int[][] map;
    public int[] foodx;
    public int[] foody;
    public int maxx;
    public int maxy;
    public int posx;
    public int posy;
    public int sum;
    public int orientation;
    public int moves;
    public int pmod;

    public Object clone() {
        Ant myobj = (Ant)super.clone();
        myobj.map = new int[this.map.length][];
        for (int x = 0; x < this.map.length; ++x) {
            myobj.map[x] = (int[])this.map[x].clone();
        }
        return myobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(EvolutionState state, Parameter base) {
        InputStream str;
        super.setup(state, base);
        this.maxMoves = state.parameters.getInt(base.push(P_MOVES), null, 1);
        if (this.maxMoves == 0) {
            state.output.error("The number of moves an ant has to make must be >0");
        }
        if ((str = state.parameters.getResource(base.push(P_FILE), null)) == null) {
            state.output.fatal("Error loading file or resource", base.push(P_FILE), null);
        }
        this.food = 0;
        BufferedReader lnr = null;
        try {
            int x;
            lnr = new LineNumberReader(new InputStreamReader(str));
            StringTokenizer st = new StringTokenizer(((LineNumberReader)lnr).readLine());
            this.maxx = Integer.parseInt(st.nextToken());
            this.maxy = Integer.parseInt(st.nextToken());
            this.map = new int[this.maxx][this.maxy];
            for (int y = 0; y < this.maxy; ++y) {
                String s = ((LineNumberReader)lnr).readLine();
                if (s == null) {
                    state.output.warning("Ant trail file ended prematurely");
                    break;
                }
                for (x = 0; x < s.length(); ++x) {
                    if (s.charAt(x) == ' ') {
                        this.map[x][y] = 1;
                        continue;
                    }
                    if (s.charAt(x) == '#') {
                        this.map[x][y] = -1;
                        ++this.food;
                        continue;
                    }
                    if (s.charAt(x) == '.') {
                        this.map[x][y] = 2;
                        continue;
                    }
                    state.output.error("Bad character '" + s.charAt(x) + "' on line number " + ((LineNumberReader)lnr).getLineNumber() + " of the Ant trail file.");
                }
                for (int z = x; z < this.maxx; ++z) {
                    this.map[z][y] = 1;
                }
            }
            for (int z = y; z < this.maxy; ++z) {
                for (x = 0; x < this.maxx; ++x) {
                    this.map[x][z] = 1;
                }
            }
        }
        catch (NumberFormatException e) {
            state.output.fatal("The Ant trail file does not begin with x and y integer values.");
        }
        catch (IOException e) {
            state.output.fatal("The Ant trail file could not be read due to an IOException:\n" + e);
        }
        finally {
            try {
                if (lnr != null) {
                    lnr.close();
                }
            }
            catch (IOException e) {}
        }
        state.output.exitIfErrors();
        this.foodx = new int[this.food];
        this.foody = new int[this.food];
        int tmpf = 0;
        for (int x = 0; x < this.map.length; ++x) {
            for (int y = 0; y < this.map[0].length; ++y) {
                if (this.map[x][y] != -1) continue;
                this.foodx[tmpf] = x;
                this.foody[tmpf] = y;
                ++tmpf;
            }
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            this.sum = 0;
            this.posx = 0;
            this.posy = 0;
            this.orientation = 3;
            this.moves = 0;
            while (this.moves < this.maxMoves && this.sum < this.food) {
                ((GPIndividual)ind).trees[0].child.eval(state, threadnum, this.input, this.stack, (GPIndividual)ind, this);
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, this.food - this.sum);
            f.hits = this.sum;
            ind.evaluated = true;
            for (int y = 0; y < this.food; ++y) {
                this.map[this.foodx[y]][this.foody[y]] = -1;
            }
        }
    }

    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        state.output.println("\n\nBest Individual's Map\n=====================", log);
        this.sum = 0;
        this.pmod = 97;
        this.posx = 0;
        this.posy = 0;
        this.orientation = 3;
        int[][] map2 = new int[this.map.length][];
        for (int x = 0; x < this.map.length; ++x) {
            map2[x] = (int[])this.map[x].clone();
        }
        map2[this.posx][this.posy] = this.pmod++;
        this.moves = 0;
        while (this.moves < this.maxMoves && this.sum < this.food) {
            ((EvalPrint)((Object)((GPIndividual)ind).trees[0].child)).evalPrint(state, threadnum, this.input, this.stack, (GPIndividual)ind, this, map2);
        }
        for (int y = 0; y < map2.length; ++y) {
            block9: for (int x = 0; x < map2.length; ++x) {
                switch (map2[x][y]) {
                    case -1: {
                        state.output.print("#", log);
                        continue block9;
                    }
                    case 1: {
                        state.output.print(".", log);
                        continue block9;
                    }
                    case 2: {
                        state.output.print("+", log);
                        continue block9;
                    }
                    case 3: {
                        state.output.print("?", log);
                        continue block9;
                    }
                    default: {
                        state.output.print("" + (char)map2[x][y], log);
                    }
                }
            }
            state.output.println("", log);
        }
    }
}

