/*
 * Decompiled with CFR 0.152.
 */
package ec.app.mona;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class Picture
implements Cloneable,
Serializable {
    public BufferedImage original;
    public BufferedImage image;
    public Graphics graphics;
    int[] xpoints = new int[0];
    int[] ypoints = new int[0];
    static JFrame f = new JFrame();
    static boolean first = true;
    static JLabel left = new JLabel();
    static JLabel right = new JLabel();
    int count = 0;

    double extend(double value) {
        return value * 1.05 - 0.025;
    }

    int discretize(double value, int max) {
        int v = (int)(value * (double)(max + 1));
        if (v > max) {
            v = max;
        }
        return v;
    }

    public void disposeGraphics() {
        if (this.graphics != null) {
            this.graphics.dispose();
        }
        this.graphics = null;
    }

    public void addPolygon(double[] vals, int offset, int numVertices) {
        double c1 = vals[offset];
        double c2 = vals[offset + 1];
        double c3 = vals[offset + 2];
        double c4 = vals[offset + 3];
        int r = this.discretize(c1, 255);
        int b = this.discretize(c2, 255);
        int g = this.discretize(c3, 255);
        int a = this.discretize(c4, 255);
        Color color = new Color(r, b, g, a);
        if (this.graphics == null) {
            this.graphics = this.image.getGraphics();
        }
        this.graphics.setColor(color);
        if (this.xpoints.length != numVertices) {
            this.xpoints = new int[numVertices];
            this.ypoints = new int[numVertices];
        }
        int[] xpoints = this.xpoints;
        int[] ypoints = this.ypoints;
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        for (int i = 0; i < numVertices; ++i) {
            xpoints[i] = this.discretize(this.extend(vals[offset + i * 2 + 4]), width - 1);
            ypoints[i] = this.discretize(this.extend(vals[offset + i * 2 + 5]), height - 1);
        }
        this.graphics.fillPolygon(xpoints, ypoints, numVertices);
    }

    public void clear() {
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        int[] data = new int[width * height];
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            data[i] = -16777216;
        }
        this.image.getRaster().setDataElements(0, 0, width, height, data);
    }

    double maxError() {
        return Math.sqrt((double)(this.image.getWidth(null) * this.image.getHeight(null)) * 65025.0 * 3.0);
    }

    public double error() {
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        int[] originalData = (int[])this.original.getRaster().getDataElements(0, 0, width, height, null);
        int[] imageData = (int[])this.image.getRaster().getDataElements(0, 0, width, height, null);
        int len = originalData.length;
        double error = 0.0;
        for (int i = 0; i < len; ++i) {
            int a = originalData[i];
            int b = imageData[i];
            int error1 = (a & 0xFF) - (b & 0xFF);
            int error2 = (a >> 8 & 0xFF) - (b >> 8 & 0xFF);
            int error3 = (a >> 16 & 0xFF) - (b >> 16 & 0xFF);
            error += (double)(error1 * error1 + error2 * error2 + error3 * error3);
        }
        return Math.sqrt(error) / this.maxError();
    }

    public void load(File file) {
        BufferedImage i = null;
        try {
            i = ImageIO.read(file);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load image file " + file + " because of error:\n\n" + e);
        }
        int width = i.getWidth(null);
        int height = i.getHeight(null);
        int type = 2;
        this.original = new BufferedImage(width, height, type);
        this.image = new BufferedImage(width, height, type);
        this.original.flush();
        this.image.flush();
        this.clear();
        Graphics2D g = (Graphics2D)this.original.getGraphics();
        g.drawImage((Image)i, 0, 0, null);
        g.dispose();
    }

    public void display(String title) {
        left.setIcon(new ImageIcon(this.copyImage(this.original)));
        right.setIcon(new ImageIcon(this.copyImage(this.image)));
        if (first) {
            first = false;
            f.getContentPane().setLayout(new GridLayout(1, 2));
            f.getContentPane().add(left);
            f.getContentPane().add(right);
            f.pack();
            f.setVisible(true);
        }
        f.setTitle(title);
        f.repaint();
    }

    public void save(File file) {
        try {
            ImageIO.write((RenderedImage)this.image, "png", file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        int type = this.image.getType();
        out.writeInt(type);
        out.writeInt(width);
        out.writeInt(height);
        out.writeObject(this.image.getRGB(0, 0, width, height, null, 0, width));
        out.writeObject(this.original.getRGB(0, 0, width, height, null, 0, width));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int type = in.readInt();
        int width = in.readInt();
        int height = in.readInt();
        this.original = new BufferedImage(width, height, type);
        this.image = new BufferedImage(width, height, type);
        this.image.getRGB(0, 0, width, height, (int[])in.readObject(), 0, width);
        this.original.getRGB(0, 0, width, height, (int[])in.readObject(), 0, width);
        this.xpoints = new int[0];
        this.ypoints = new int[0];
    }

    public Object clone() {
        Picture p = null;
        try {
            p = (Picture)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        p.original = this.copyImage(this.original);
        p.image = this.copyImage(this.image);
        p.xpoints = new int[0];
        p.ypoints = new int[0];
        return p;
    }

    public BufferedImage copyImage(BufferedImage image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage i = new BufferedImage(width, height, image.getType());
        i.setRGB(0, 0, width, height, image.getRGB(0, 0, width, height, null, 0, width), 0, width);
        return i;
    }
}

