/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tutorial2;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.util.Parameter;
import ec.vector.IntegerVectorIndividual;
import ec.vector.IntegerVectorSpecies;
import ec.vector.VectorDefaults;

public class OurMutatorPipeline
extends BreedingPipeline {
    public static final String P_OURMUTATION = "our-mutation";
    public static final int NUM_SOURCES = 1;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_OURMUTATION);
    }

    public int numSources() {
        return 1;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            for (int q = start; q < n + start; ++q) {
                inds[q] = (Individual)inds[q].clone();
            }
        }
        if (!(inds[start] instanceof IntegerVectorIndividual)) {
            state.output.fatal("OurMutatorPipeline didn't get an IntegerVectorIndividual.The offending individual is in subpopulation " + subpopulation + " and it's:" + inds[start]);
        }
        IntegerVectorSpecies species = (IntegerVectorSpecies)inds[start].species;
        for (int q = start; q < n + start; ++q) {
            IntegerVectorIndividual i = (IntegerVectorIndividual)inds[q];
            for (int x = 0; x < i.genome.length; ++x) {
                if (!state.random[thread].nextBoolean(species.mutationProbability(x))) continue;
                i.genome[x] = -i.genome[x];
            }
            i.evaluated = false;
        }
        return n;
    }
}

