/*
 * Decompiled with CFR 0.152.
 */
package ec.exchange;

import ec.EvolutionState;
import ec.util.Parameter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;

class IslandExchangeServer
implements Runnable {
    public static final String P_SERVER_PORT = "server-port";
    public static final String P_NUM_ISLANDS = "num-islands";
    public static final String P_ISLAND = "island";
    public static final String P_ID = "id";
    public static final String P_NUM_INCOMING_MIGRATING_COUNTRIES = "num-incoming-mig";
    public static final String P_NUM_MIGRATING_COUNTRIES = "num-mig";
    public static final String P_MIGRATING_ISLAND = "mig";
    public static final String P_MAILBOX_CAPACITY = "mailbox-capacity";
    public static final String P_MODULO = "mod";
    public static final String P_SIZE = "size";
    public static final String P_OFFSET = "start";
    public static final String P_SYNCHRONOUS = "sync";
    public static final String RUN = "run";
    public static final int FOUND_TIMEOUT = 100;
    public static final int SLEEP_TIME = 100;
    public static final String GOODBYE = "bye-bye";
    public static final String FOUND = "found";
    public static final String OKAY = "okay";
    public static final String SYNC = "sync";
    int numIslands;
    int serverPort;
    ServerSocket serverSocket;
    Hashtable info;
    Hashtable info_immigrants;
    EvolutionState state;
    String[] island_ids;
    String[] connected_island_ids;
    boolean synchronous;
    boolean[] who_is_synchronized;
    public static final int ISLAND_INDEX_LOOKUP_FAILED = -1;
    public static final Parameter islandIndexBase = new Parameter("exch.island");
    public static final Parameter islandIndexNumIslands = new Parameter("exch.num-islands");

    IslandExchangeServer() {
    }

    public void setupServerFromDatabase(EvolutionState state_p, Parameter base) {
        Parameter localBase;
        IslandExchangeIslandInfo ieii;
        int x;
        this.state = state_p;
        Parameter p = base.push(P_NUM_ISLANDS);
        this.numIslands = this.state.parameters.getInt(p, null, 1);
        if (this.numIslands == 0) {
            this.state.output.fatal("The number of islands must be >0.", p);
        }
        p = base.push(P_SERVER_PORT);
        this.serverPort = this.state.parameters.getInt(p, null, 1);
        if (this.serverPort == 0) {
            this.state.output.fatal("The server port must be >0.", p);
        }
        this.info = new Hashtable(this.numIslands);
        this.info_immigrants = new Hashtable(this.numIslands);
        this.island_ids = new String[this.numIslands];
        this.connected_island_ids = new String[this.numIslands];
        p = base.push("sync");
        this.synchronous = this.state.parameters.getBoolean(p, null, false);
        if (this.synchronous) {
            this.state.output.message("The communication will be synchronous.");
        } else {
            this.state.output.message("The communication will be asynchronous.");
        }
        Parameter islandBase = base.push(P_ISLAND);
        for (x = 0; x < this.numIslands; ++x) {
            ieii = new IslandExchangeIslandInfo();
            localBase = islandBase.push("" + x);
            p = localBase.push(P_ID);
            this.island_ids[x] = this.state.parameters.getStringWithDefault(p, null, "");
            if (this.island_ids[x].equals("")) {
                this.state.output.fatal("Parameter not found.", p);
            }
            p = localBase.push(P_MAILBOX_CAPACITY);
            ieii.mailbox_capacity = this.state.parameters.getInt(p, base.push(P_MAILBOX_CAPACITY), 0);
            if (ieii.mailbox_capacity == -1) {
                this.state.output.fatal("Parameter not found, or it has an incorrect value.", p, base.push(P_MAILBOX_CAPACITY));
            }
            p = localBase.push(P_SIZE);
            ieii.size = this.state.parameters.getInt(p, base.push(P_SIZE), 0);
            if (ieii.size == -1) {
                this.state.output.fatal("Parameter not found, or it has an incorrect value.", p, base.push(P_SIZE));
            }
            p = localBase.push(P_MODULO);
            ieii.modulo = this.state.parameters.getInt(p, base.push(P_MODULO), 1);
            if (ieii.modulo == 0) {
                this.state.output.fatal("Parameter not found, or it has an incorrect value.", p, base.push(P_MODULO));
            }
            p = localBase.push(P_OFFSET);
            ieii.offset = this.state.parameters.getInt(p, base.push(P_OFFSET), 0);
            if (ieii.offset == -1) {
                this.state.output.fatal("Parameter not found, or it has an incorrect value.", p, base.push(P_OFFSET));
            }
            ieii.port = -1;
            this.info.put(this.island_ids[x], ieii);
        }
        for (x = 0; x < this.numIslands; ++x) {
            ieii = (IslandExchangeIslandInfo)this.info.get(this.island_ids[x]);
            if (ieii == null) {
                this.state.output.error("Inexistent information for island " + this.island_ids[x] + " stored in the server's information database.");
                continue;
            }
            localBase = islandBase.push("" + x);
            p = localBase.push(P_NUM_MIGRATING_COUNTRIES);
            ieii.num_mig = this.state.parameters.getInt(p, null, 0);
            if (ieii.num_mig == -1) {
                this.state.output.fatal("Parameter not found, or it has an incorrect value.", p);
            }
            if (ieii.num_mig <= 0) continue;
            ieii.migrating_island_ids = new String[ieii.num_mig];
            Parameter ll = localBase.push(P_MIGRATING_ISLAND);
            for (int y = 0; y < ieii.num_mig; ++y) {
                ieii.migrating_island_ids[y] = this.state.parameters.getStringWithDefault(ll.push("" + y), null, null);
                if (ieii.migrating_island_ids[y] == null) {
                    this.state.output.fatal("Parameter not found.", ll.push("" + y));
                    continue;
                }
                if (!this.info.containsKey(ieii.migrating_island_ids[y])) {
                    this.state.output.fatal("Unknown island.", ll.push("" + y));
                    continue;
                }
                Integer integer = (Integer)this.info_immigrants.get(ieii.migrating_island_ids[y]);
                if (integer == null) {
                    this.info_immigrants.put(ieii.migrating_island_ids[y], 1);
                    continue;
                }
                this.info_immigrants.put(ieii.migrating_island_ids[y], integer + 1);
            }
        }
        for (x = 0; x < this.numIslands; ++x) {
            Integer integer;
            ieii = (IslandExchangeIslandInfo)this.info.get(this.island_ids[x]);
            if (ieii == null) {
                this.state.output.fatal("Inexistent information for island " + this.island_ids[x] + " stored in the server's information database.");
            }
            ieii.num_incoming = (integer = (Integer)this.info_immigrants.get(this.island_ids[x])) == null ? 0 : integer;
        }
        this.who_is_synchronized = new boolean[this.numIslands];
        for (x = 0; x < this.numIslands; ++x) {
            this.who_is_synchronized[x] = false;
        }
    }

    public void run() {
        IslandExchangeIslandInfo ieii;
        int x;
        Socket[] con = new Socket[this.numIslands];
        DataInputStream[] dataIn = new DataInputStream[this.numIslands];
        DataOutputStream[] dataOut = new DataOutputStream[this.numIslands];
        boolean[] clientRunning = new boolean[this.numIslands];
        for (int x2 = 0; x2 < this.numIslands; ++x2) {
            clientRunning[x2] = true;
        }
        try {
            this.serverSocket = new ServerSocket(this.serverPort, this.numIslands);
        }
        catch (IOException e) {
            this.state.output.fatal("Error creating a socket on port " + this.serverPort);
        }
        for (x = 0; x < this.numIslands; ++x) {
            try {
                con[x] = this.serverSocket.accept();
                dataIn[x] = new DataInputStream(con[x].getInputStream());
                dataOut[x] = new DataOutputStream(con[x].getOutputStream());
                this.connected_island_ids[x] = dataIn[x].readUTF().trim();
                this.state.output.message("Island " + this.connected_island_ids[x] + " logged in");
                if (!this.info.containsKey(this.connected_island_ids[x])) {
                    this.state.output.error("Incorrect ID (" + this.connected_island_ids[x] + ")");
                    clientRunning[x] = false;
                    continue;
                }
                ieii = (IslandExchangeIslandInfo)this.info.get(this.connected_island_ids[x]);
                if (ieii == null) {
                    this.state.output.error("Can't get IslandExchangeInfo for " + this.connected_island_ids[x]);
                    clientRunning[x] = false;
                    continue;
                }
                if (ieii.port >= 0) {
                    this.state.output.error("Multiple islands are claiming the same ID (" + this.connected_island_ids[x] + ")");
                    clientRunning[x] = false;
                    continue;
                }
                dataOut[x].writeInt(ieii.num_incoming);
                dataOut[x].writeInt(ieii.mailbox_capacity);
                dataOut[x].flush();
                ieii.address = dataIn[x].readUTF().trim();
                ieii.port = dataIn[x].readInt();
                this.state.output.message("" + x + ": Island " + this.connected_island_ids[x] + " has address " + ieii.address + " : " + ieii.port);
                continue;
            }
            catch (IOException e) {
                this.state.output.error("Could not open connection #" + x);
                clientRunning[x] = false;
            }
        }
        this.state.output.exitIfErrors();
        for (x = 0; x < this.numIslands; ++x) {
            if (!clientRunning[x]) continue;
            ieii = (IslandExchangeIslandInfo)this.info.get(this.connected_island_ids[x]);
            if (ieii == null) {
                this.state.output.warning("There is no information about island " + this.connected_island_ids[x]);
                clientRunning[x] = false;
                continue;
            }
            try {
                if (this.synchronous) {
                    dataOut[x].writeInt(1);
                } else {
                    dataOut[x].writeInt(0);
                }
                dataOut[x].writeInt(ieii.modulo);
                dataOut[x].writeInt(ieii.offset);
                dataOut[x].writeInt(ieii.size);
                dataOut[x].writeInt(ieii.num_mig);
                for (int y = 0; y < ieii.num_mig; ++y) {
                    IslandExchangeIslandInfo temp = (IslandExchangeIslandInfo)this.info.get(ieii.migrating_island_ids[y]);
                    if (temp == null) {
                        this.state.output.warning("There is incorrect information on the island " + this.connected_island_ids[x]);
                        dataOut[x].writeUTF(" ");
                        dataOut[x].writeInt(-1);
                        continue;
                    }
                    this.state.output.message("Island " + this.connected_island_ids[x] + " should connect to island " + ieii.migrating_island_ids[y] + " at " + temp.address + " : " + temp.port);
                    dataOut[x].writeUTF(temp.address);
                    dataOut[x].writeInt(temp.port);
                }
                dataOut[x].flush();
                continue;
            }
            catch (IOException e) {
                this.state.output.message("Server: Island " + this.island_ids[x] + " dropped connection");
                clientRunning[x] = false;
                continue;
            }
            catch (NullPointerException e) {
                this.state.output.message("Server: Island " + this.island_ids[x] + " dropped connection");
                clientRunning[x] = false;
                try {
                    dataIn[x].close();
                    dataOut[x].close();
                    con[x].close();
                    continue;
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
        }
        try {
            for (x = 0; x < dataIn.length; ++x) {
                dataIn[x].readUTF();
            }
            for (x = 0; x < dataOut.length; ++x) {
                dataOut[x].writeUTF(RUN);
                dataOut[x].flush();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int x3 = 0; x3 < con.length; ++x3) {
            try {
                con[x3].setSoTimeout(100);
                continue;
            }
            catch (SocketException e) {
                this.state.output.error("Could not set the connect with island " + x3 + " to non-blocking.");
            }
        }
        boolean shouldExit = false;
        block32: while (!shouldExit) {
            shouldExit = true;
            for (int x4 = 0; x4 < dataOut.length; ++x4) {
                if (!clientRunning[x4]) continue;
                shouldExit = false;
                break;
            }
            if (shouldExit) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (int x5 = 0; x5 < dataOut.length; ++x5) {
                int y;
                if (!clientRunning[x5]) continue;
                String ww = "";
                try {
                    ww = dataIn[x5].readUTF().trim();
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                catch (IOException e) {
                    this.state.output.message("Server: Island " + this.island_ids[x5] + " dropped connection");
                    clientRunning[x5] = false;
                    continue;
                }
                catch (NullPointerException e) {
                    this.state.output.message("Server: Island " + this.island_ids[x5] + " dropped connection");
                    clientRunning[x5] = false;
                    try {
                        dataIn[x5].close();
                        dataOut[x5].close();
                        con[x5].close();
                    }
                    catch (IOException f) {}
                    continue;
                }
                if (ww.equals(FOUND)) {
                    for (int y2 = 0; y2 < dataOut.length; ++y2) {
                        if (!clientRunning[y2]) continue;
                        try {
                            dataOut[y2].writeUTF(GOODBYE);
                            dataOut[y2].close();
                            dataIn[y2].close();
                            con[y2].close();
                            continue;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    shouldExit = true;
                    continue block32;
                }
                if (!ww.equals("sync")) continue;
                this.who_is_synchronized[x5] = true;
                boolean complete_synchronization = true;
                for (y = 0; y < this.numIslands; ++y) {
                    complete_synchronization = complete_synchronization && (!clientRunning[y] || this.who_is_synchronized[y]);
                }
                if (!complete_synchronization) continue;
                for (y = 0; y < this.numIslands; ++y) {
                    if (clientRunning[y]) {
                        try {
                            dataOut[y].writeUTF(OKAY);
                            dataOut[y].flush();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    this.who_is_synchronized[y] = false;
                }
            }
        }
        this.state.output.message("Server Exiting");
    }

    public Thread spawnThread() {
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }

    public int getIslandIndex(EvolutionState state, String id) {
        int num = state.parameters.getInt(islandIndexNumIslands, null, 0);
        if (num < 0) {
            state.output.warnOnce("IslandExchange.islandIndex could not find the number of islands", islandIndexNumIslands, null);
            return -1;
        }
        for (int i = 0; i < num; ++i) {
            Parameter b = islandIndexBase.push("" + i).push(P_ID);
            String island = state.parameters.getString(b, null);
            if (island == null) {
                state.output.warnOnce("IslandExchange.islandIndex could not find island number " + i, b, null);
                continue;
            }
            if (!island.equals(id)) continue;
            return i;
        }
        state.output.warnOnce("IslandExchange.islandIndex could not find any island called " + id);
        return -1;
    }

    public static class IslandExchangeIslandInfo {
        public int modulo;
        public int mailbox_capacity;
        public int offset;
        public int size;
        public int num_mig;
        public String[] migrating_island_ids;
        public int num_incoming;
        public String address;
        public int port;
    }
}

