/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.Prototype;
import ec.gp.GPDefaults;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeParent;
import ec.gp.GPTreeConstraints;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class GPTree
implements GPNodeParent,
Prototype {
    public static final String P_TREE = "tree";
    public static final String P_TREECONSTRAINTS = "tc";
    public static final String P_USEGRAPHVIZ = "graphviz";
    public static final String P_USELATEX = "latex";
    public static final String P_USEC = "c";
    public static final String P_USEOPS = "c-operators";
    public static final String P_USEVARS = "c-variables";
    public static final int NO_TREENUM = -1;
    public static final String P_PRINT_STYLE = "print-style";
    public static final String V_LISP = "lisp";
    public static final String V_DOT = "dot";
    public static final String V_LATEX = "latex";
    public static final String V_C = "c";
    public static final int PRINT_STYLE_LISP = 0;
    public static final int PRINT_STYLE_DOT = 1;
    public static final int PRINT_STYLE_LATEX = 2;
    public static final int PRINT_STYLE_C = 3;
    public GPNode child;
    public GPIndividual owner;
    public byte constraints;
    public int printStyle;
    public boolean printTerminalsAsVariablesInC;
    public boolean printTwoArgumentNonterminalsAsOperatorsInC;

    public final GPTreeConstraints constraints(GPInitializer initializer) {
        return initializer.treeConstraints[this.constraints];
    }

    public Parameter defaultBase() {
        return GPDefaults.base().push(P_TREE);
    }

    public boolean treeEquals(GPTree tree) {
        return this.child.rootedTreeEquals(tree.child);
    }

    public int treeHashCode() {
        return this.child.rootedTreeHashCode();
    }

    public GPTree lightClone() {
        try {
            return (GPTree)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object clone() {
        GPTree newtree = this.lightClone();
        newtree.child = (GPNode)this.child.clone();
        newtree.child.parent = newtree;
        newtree.child.argposition = 0;
        return newtree;
    }

    public int treeNumber() {
        if (this.owner == null) {
            return -1;
        }
        if (this.owner.trees == null) {
            return -1;
        }
        for (int x = 0; x < this.owner.trees.length; ++x) {
            if (this.owner.trees[x] != this) continue;
            return x;
        }
        return -1;
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        if (state.parameters.exists(base.push(P_USEGRAPHVIZ), def.push(P_USEGRAPHVIZ))) {
            state.output.error("Parameter no longer used.  See GPTree.java for details.", base.push(P_USEGRAPHVIZ), def.push(P_USEGRAPHVIZ));
        }
        if (state.parameters.exists(base.push("latex"), def.push("latex"))) {
            state.output.error("Parameter no longer used.  See GPTree.java for details.", base.push("latex"), def.push("latex"));
        }
        if (state.parameters.exists(base.push("c"), def.push("c"))) {
            state.output.error("Parameter no longer used.  See GPTree.java for details.", base.push("c"), def.push("c"));
        }
        state.output.exitIfErrors();
        String style = state.parameters.getString(base.push(P_PRINT_STYLE), def.push(P_PRINT_STYLE));
        if (style == null) {
            this.printStyle = 0;
        } else if (style.equals("c")) {
            this.printStyle = 3;
        } else if (style.equals(V_DOT)) {
            this.printStyle = 1;
        } else if (style.equals("latex")) {
            this.printStyle = 2;
        }
        this.printTerminalsAsVariablesInC = state.parameters.getBoolean(base.push(P_USEVARS), def.push(P_USEVARS), true);
        this.printTwoArgumentNonterminalsAsOperatorsInC = state.parameters.getBoolean(base.push(P_USEOPS), def.push(P_USEOPS), true);
        String s = state.parameters.getString(base.push(P_TREECONSTRAINTS), def.push(P_TREECONSTRAINTS));
        if (s == null) {
            state.output.fatal("No tree constraints are defined for the GPTree " + base + ".");
        } else {
            this.constraints = GPTreeConstraints.constraintsFor((String)s, (EvolutionState)state).constraintNumber;
        }
        state.output.exitIfErrors();
    }

    public final void verify(EvolutionState state) {
        if (!(state.initializer instanceof GPInitializer)) {
            state.output.error("Initializer is not a GPInitializer");
            return;
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        if (this.child == null) {
            state.output.error("Null root child of GPTree.");
            return;
        }
        if (this.owner == null) {
            state.output.error("Null owner of GPTree.");
            return;
        }
        if (this.owner.trees == null) {
            state.output.error("Owner has null trees.");
            return;
        }
        if (this.treeNumber() == -1) {
            state.output.error("No Tree Number! I appear to be an orphan GPTree.");
            return;
        }
        if (this.constraints < 0 || this.constraints >= initializer.numTreeConstraints) {
            state.output.error("Preposterous tree constraints (" + this.constraints + ")");
            return;
        }
        this.child.verify(state, this.constraints((GPInitializer)initializer).functionset, 0);
        state.output.exitIfErrors();
    }

    public void printTree(EvolutionState state, int log) {
        this.printTree(state, log, 0);
    }

    public void printTree(EvolutionState state, int log, int verbosity) {
        this.child.printRootedTree(state, log, 0);
        state.output.println("", log);
    }

    public void printTree(EvolutionState state, PrintWriter writer) {
        this.child.printRootedTree(state, writer, 0);
        writer.println();
    }

    public void readTree(EvolutionState state, LineNumberReader reader) throws IOException {
        int linenumber = reader.getLineNumber();
        String s = reader.readLine();
        if (s == null) {
            state.output.fatal("Reading Line " + linenumber + ": " + "No Tree found.");
        } else {
            GPInitializer initializer = (GPInitializer)state.initializer;
            this.child = GPNode.readRootedTree(linenumber, new DecodeReturn(s), this.constraints((GPInitializer)initializer).treetype, this.constraints((GPInitializer)initializer).functionset, this, 0, state);
        }
    }

    public void writeTree(EvolutionState state, DataOutput dataOutput) throws IOException {
        GPInitializer initializer = (GPInitializer)state.initializer;
        this.child.writeRootedTree(state, this.constraints((GPInitializer)initializer).treetype, this.constraints((GPInitializer)initializer).functionset, dataOutput);
    }

    public void readTree(EvolutionState state, DataInput dataInput) throws IOException {
        GPInitializer initializer = (GPInitializer)state.initializer;
        this.child = GPNode.readRootedTree(state, dataInput, this.constraints((GPInitializer)initializer).treetype, this.constraints((GPInitializer)initializer).functionset, this, 0);
    }

    public void printTreeForHumans(EvolutionState state, int log) {
        this.printTreeForHumans(state, log, 0);
    }

    public void printTreeForHumans(EvolutionState state, int log, int verbosity) {
        if (this.printStyle == 3) {
            state.output.print(this.child.makeCTree(true, this.printTerminalsAsVariablesInC, this.printTwoArgumentNonterminalsAsOperatorsInC), log);
        } else if (this.printStyle == 2) {
            state.output.print(this.child.makeLatexTree(), log);
        } else if (this.printStyle == 1) {
            state.output.print(this.child.makeGraphvizTree(), log);
        } else {
            this.child.printRootedTreeForHumans(state, log, 0, 0);
        }
        state.output.println("", log);
    }

    public void buildTree(EvolutionState state, int thread) {
        GPInitializer initializer = (GPInitializer)state.initializer;
        this.child = this.constraints((GPInitializer)initializer).init.newRootedTree(state, this.constraints((GPInitializer)initializer).treetype, thread, this, this.constraints((GPInitializer)initializer).functionset, 0, -1);
    }
}

