/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.ge.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.gp.ge.GEDefaults;
import ec.gp.ge.GEIndividual;
import ec.gp.ge.GESpecies;
import ec.util.Parameter;

public class GETruncationPipeline
extends BreedingPipeline {
    public static final String P_TRUNCATION = "truncation";
    public static final int NUM_SOURCES = 1;

    public int numSources() {
        return 1;
    }

    public Parameter defaultBase() {
        return GEDefaults.base().push(P_TRUNCATION);
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        for (int q = start; q < n + start; ++q) {
            GEIndividual ind;
            GESpecies species;
            int consumed;
            if (this.sources[0] instanceof SelectionMethod) {
                inds[q] = (Individual)inds[q].clone();
            }
            if ((consumed = (species = (GESpecies)ind.species).consumed(state, ind = (GEIndividual)inds[q], thread)) <= 1) continue;
            Object[] pieces = new Object[2];
            ind.split(new int[]{consumed}, pieces);
            ind.join(new Object[]{pieces[0]});
        }
        return n;
    }
}

