/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective;

import ec.EvolutionState;
import ec.Fitness;
import ec.Individual;
import ec.multiobjective.MultiObjectiveDefaults;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;

public class MultiObjectiveFitness
extends Fitness {
    public static final String MULTI_FITNESS_POSTAMBLE = "[";
    public static final String FITNESS_POSTAMBLE = "]";
    public static final String P_NUMOBJECTIVES = "num-objectives";
    public static final String P_MAXOBJECTIVES = "max";
    public static final String P_MINOBJECTIVES = "min";
    public static final String P_MAXIMIZE = "maximize";
    public double[] maxObjective;
    public double[] minObjective;
    public boolean[] maximize;
    protected double[] objectives;

    public String[] getAuxilliaryFitnessNames() {
        return new String[0];
    }

    public double[] getAuxilliaryFitnessValues() {
        return new double[0];
    }

    public boolean isMaximizing() {
        return this.maximize[0];
    }

    public boolean isMaximizing(int objective) {
        return this.maximize[objective];
    }

    public int getNumObjectives() {
        return this.objectives.length;
    }

    public double[] getObjectives() {
        return this.objectives;
    }

    public double getObjective(int i) {
        return this.objectives[i];
    }

    public void setObjectives(EvolutionState state, double[] newObjectives) {
        if (newObjectives == null) {
            state.output.fatal("Null objective array provided to MultiObjectiveFitness.");
        }
        if (newObjectives.length != this.objectives.length) {
            state.output.fatal("New objective array length does not match current length.");
        }
        for (int i = 0; i < newObjectives.length; ++i) {
            double _f = newObjectives[i];
            if (!(_f >= Double.POSITIVE_INFINITY) && !(_f <= Double.NEGATIVE_INFINITY) && !Double.isNaN(_f)) continue;
            state.output.warning("Bad objective #" + i + ": " + _f + ", setting to worst value for that objective.");
            newObjectives[i] = this.maximize[i] ? this.minObjective[i] : this.maxObjective[i];
        }
        this.objectives = newObjectives;
    }

    public Parameter defaultBase() {
        return MultiObjectiveDefaults.base().push("fitness");
    }

    public Object clone() {
        MultiObjectiveFitness f = (MultiObjectiveFitness)super.clone();
        f.objectives = (double[])this.objectives.clone();
        return f;
    }

    public double fitness() {
        double fit = this.objectives[0];
        for (int x = 1; x < this.objectives.length; ++x) {
            if (!(fit < this.objectives[x])) continue;
            fit = this.objectives[x];
        }
        return fit;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        int numFitnesses = state.parameters.getInt(base.push(P_NUMOBJECTIVES), def.push(P_NUMOBJECTIVES), 0);
        if (numFitnesses <= 0) {
            state.output.fatal("The number of objectives must be an integer >= 1.", base.push(P_NUMOBJECTIVES), def.push(P_NUMOBJECTIVES));
        }
        this.objectives = new double[numFitnesses];
        this.maxObjective = new double[numFitnesses];
        this.minObjective = new double[numFitnesses];
        this.maximize = new boolean[numFitnesses];
        for (int i = 0; i < numFitnesses; ++i) {
            this.minObjective[i] = state.parameters.getDoubleWithDefault(base.push(P_MINOBJECTIVES), def.push(P_MINOBJECTIVES), 0.0);
            this.maxObjective[i] = state.parameters.getDoubleWithDefault(base.push(P_MAXOBJECTIVES), def.push(P_MAXOBJECTIVES), 1.0);
            this.maximize[i] = state.parameters.getBoolean(base.push(P_MAXIMIZE), def.push(P_MAXIMIZE), true);
            this.minObjective[i] = state.parameters.getDoubleWithDefault(base.push(P_MINOBJECTIVES).push("" + i), def.push(P_MINOBJECTIVES).push("" + i), this.minObjective[i]);
            this.maxObjective[i] = state.parameters.getDoubleWithDefault(base.push(P_MAXOBJECTIVES).push("" + i), def.push(P_MAXOBJECTIVES).push("" + i), this.maxObjective[i]);
            this.maximize[i] = state.parameters.getBoolean(base.push(P_MAXIMIZE).push("" + i), def.push(P_MAXIMIZE).push("" + i), this.maximize[i]);
            if (!(this.minObjective[i] >= this.maxObjective[i])) continue;
            state.output.error("For objective " + i + "the min fitness must be strictly less than the max fitness.");
        }
        state.output.exitIfErrors();
    }

    public boolean isIdealFitness() {
        return false;
    }

    public boolean equivalentTo(Fitness _fitness) {
        MultiObjectiveFitness other = (MultiObjectiveFitness)_fitness;
        boolean abeatsb = false;
        boolean bbeatsa = false;
        if (this.objectives.length != other.objectives.length) {
            throw new RuntimeException("Attempt made to compare two multiobjective fitnesses; but they have different numbers of objectives.");
        }
        for (int x = 0; x < this.objectives.length; ++x) {
            if (this.maximize[x] != other.maximize[x]) {
                throw new RuntimeException("Attempt made to compare two multiobjective fitnesses; but for objective #" + x + ", one expects higher values to be better and the other expectes lower values to be better.");
            }
            if (this.maximize[x]) {
                if (this.objectives[x] > other.objectives[x]) {
                    abeatsb = true;
                }
                if (this.objectives[x] < other.objectives[x]) {
                    bbeatsa = true;
                }
                if (!abeatsb || !bbeatsa) continue;
                return true;
            }
            if (this.objectives[x] < other.objectives[x]) {
                abeatsb = true;
            }
            if (this.objectives[x] > other.objectives[x]) {
                bbeatsa = true;
            }
            if (!abeatsb || !bbeatsa) continue;
            return true;
        }
        return !abeatsb && !bbeatsa;
    }

    public boolean betterThan(Fitness fitness) {
        return this.paretoDominates((MultiObjectiveFitness)fitness);
    }

    public boolean paretoDominates(MultiObjectiveFitness other) {
        boolean abeatsb = false;
        if (this.objectives.length != other.objectives.length) {
            throw new RuntimeException("Attempt made to compare two multiobjective fitnesses; but they have different numbers of objectives.");
        }
        for (int x = 0; x < this.objectives.length; ++x) {
            if (this.maximize[x] != other.maximize[x]) {
                throw new RuntimeException("Attempt made to compare two multiobjective fitnesses; but for objective #" + x + ", one expects higher values to be better and the other expectes lower values to be better.");
            }
            if (this.maximize[x]) {
                if (this.objectives[x] > other.objectives[x]) {
                    abeatsb = true;
                    continue;
                }
                if (!(this.objectives[x] < other.objectives[x])) continue;
                return false;
            }
            if (this.objectives[x] < other.objectives[x]) {
                abeatsb = true;
                continue;
            }
            if (!(this.objectives[x] > other.objectives[x])) continue;
            return false;
        }
        return abeatsb;
    }

    static void yank(int val, ArrayList list) {
        int size = list.size();
        list.set(val, list.get(size - 1));
        list.remove(size - 1);
    }

    public static ArrayList partitionIntoParetoFront(Individual[] inds, ArrayList front, ArrayList nonFront) {
        if (front == null) {
            front = new ArrayList<Individual>();
        }
        front.add(inds[0]);
        for (int i = 1; i < inds.length; ++i) {
            Individual ind = inds[i];
            boolean noOneWasBetter = true;
            int frontSize = front.size();
            for (int j = 0; j < frontSize; ++j) {
                Individual frontmember = (Individual)front.get(j);
                if (((MultiObjectiveFitness)frontmember.fitness).paretoDominates((MultiObjectiveFitness)ind.fitness)) {
                    if (nonFront != null) {
                        nonFront.add(ind);
                    }
                    noOneWasBetter = false;
                    break;
                }
                if (!((MultiObjectiveFitness)ind.fitness).paretoDominates((MultiObjectiveFitness)frontmember.fitness)) continue;
                MultiObjectiveFitness.yank(j, front);
                --frontSize;
                --j;
                if (nonFront == null) continue;
                nonFront.add(frontmember);
            }
            if (!noOneWasBetter) continue;
            front.add(ind);
        }
        return front;
    }

    public static ArrayList partitionIntoRanks(Individual[] inds) {
        Individual[] dummy = new Individual[]{};
        ArrayList frontsByRank = new ArrayList();
        while (inds.length > 0) {
            ArrayList front = new ArrayList();
            ArrayList nonFront = new ArrayList();
            MultiObjectiveFitness.partitionIntoParetoFront(inds, front, nonFront);
            inds = nonFront.toArray(dummy);
            frontsByRank.add(front);
        }
        return frontsByRank;
    }

    public static int[] getRankings(Individual[] inds) {
        int[] r = new int[inds.length];
        ArrayList ranks = MultiObjectiveFitness.partitionIntoRanks(inds);
        HashMap<Individual, Integer> m = new HashMap<Individual, Integer>();
        for (int i = 0; i < inds.length; ++i) {
            m.put(inds[i], i);
        }
        int numRanks = ranks.size();
        for (int rank = 0; rank < numRanks; ++rank) {
            ArrayList front = (ArrayList)ranks.get(rank);
            int numInds = front.size();
            for (int ind = 0; ind < numInds; ++ind) {
                int i = (Integer)m.get(front.get(ind));
                r[i] = rank;
            }
        }
        return r;
    }

    public double sumSquaredObjectiveDistance(MultiObjectiveFitness other) {
        double s = 0.0;
        for (int i = 0; i < this.objectives.length; ++i) {
            double a = this.objectives[i] - other.objectives[i];
            s += a * a;
        }
        return s;
    }

    public double manhattanObjectiveDistance(MultiObjectiveFitness other) {
        double s = 0.0;
        for (int i = 0; i < this.objectives.length; ++i) {
            s += Math.abs(this.objectives[i] - other.objectives[i]);
        }
        return s;
    }

    public String fitnessToString() {
        String s = "Fitness: [";
        for (int x = 0; x < this.objectives.length; ++x) {
            if (x > 0) {
                s = s + " ";
            }
            s = s + Code.encode(this.objectives[x]);
        }
        return s + FITNESS_POSTAMBLE;
    }

    public String fitnessToStringForHumans() {
        String s = "Fitness: [";
        for (int x = 0; x < this.objectives.length; ++x) {
            if (x > 0) {
                s = s + " ";
            }
            s = s + this.objectives[x];
        }
        return s + FITNESS_POSTAMBLE;
    }

    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        DecodeReturn d = Code.checkPreamble("Fitness: [", state, reader);
        for (int x = 0; x < this.objectives.length; ++x) {
            Code.decode(d);
            if (d.type != 7) {
                state.output.fatal("Reading Line " + d.lineNumber + ": " + "Bad Fitness (objectives value #" + x + ").");
            }
            this.objectives[x] = d.d;
        }
    }

    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.objectives.length);
        for (int x = 0; x < this.objectives.length; ++x) {
            dataOutput.writeDouble(this.objectives[x]);
        }
        this.writeTrials(state, dataOutput);
    }

    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.objectives == null || this.objectives.length != len) {
            this.objectives = new double[len];
        }
        for (int x = 0; x < this.objectives.length; ++x) {
            this.objectives[x] = dataInput.readDouble();
        }
        this.readTrials(state, dataInput);
    }

    public void setToBestOf(EvolutionState state, Fitness[] fitnesses) {
        state.output.fatal("setToBestOf(EvolutionState, Fitness[]) not implemented in " + this.getClass());
    }

    public void setToMeanOf(EvolutionState state, Fitness[] fitnesses) {
        double sum = 0.0;
        for (int i = 0; i < this.objectives.length; ++i) {
            for (int k = 0; k < fitnesses.length; ++k) {
                MultiObjectiveFitness f = (MultiObjectiveFitness)fitnesses[k];
                sum += f.objectives[i];
            }
            this.objectives[i] = sum / (double)fitnesses.length;
        }
    }

    public void setToMedianOf(EvolutionState state, Fitness[] fitnesses) {
        state.output.fatal("setToMedianOf(EvolutionState, Fitness[]) not implemented in " + this.getClass());
    }
}

