/*
 * Decompiled with CFR 0.152.
 */
package ec.rule.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.rule.RuleDefaults;
import ec.rule.RuleIndividual;
import ec.util.Parameter;

public class RuleMutationPipeline
extends BreedingPipeline {
    public static final String P_MUTATION = "mutate";
    public static final int INDS_PRODUCED = 1;
    public static final int NUM_SOURCES = 1;

    public Parameter defaultBase() {
        return RuleDefaults.base().push(P_MUTATION);
    }

    public int numSources() {
        return 1;
    }

    public int typicalIndsProduced() {
        return 1;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int q;
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        if (!(this.sources[0] instanceof BreedingPipeline)) {
            for (q = start; q < n + start; ++q) {
                inds[q] = (Individual)inds[q].clone();
            }
        }
        for (q = start; q < n + start; ++q) {
            ((RuleIndividual)inds[q]).preprocessIndividual(state, thread);
            ((RuleIndividual)inds[q]).mutate(state, thread);
            ((RuleIndividual)inds[q]).postprocessIndividual(state, thread);
            ((RuleIndividual)inds[q]).evaluated = false;
        }
        return n;
    }
}

