/*
 * Decompiled with CFR 0.152.
 */
package ec.util;

import ec.EvolutionState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Checkpoint {
    public static void setCheckpoint(EvolutionState state) {
        try {
            File file = new File("" + state.checkpointPrefix + "." + state.generation + ".gz");
            if (state.checkpointDirectory != null) {
                file = new File(state.checkpointDirectory, "" + state.checkpointPrefix + "." + state.generation + ".gz");
            }
            ObjectOutputStream s = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
            s.writeObject(state);
            s.close();
            state.output.message("Wrote out checkpoint file " + state.checkpointPrefix + "." + state.generation + ".gz");
        }
        catch (IOException e) {
            state.output.warning("Unable to create the checkpoint file " + state.checkpointPrefix + "." + state.generation + ".gz" + "because of an IOException:\n--EXCEPTION--\n" + e + "\n--EXCEPTION-END--\n");
        }
    }

    public static EvolutionState restoreFromCheckpoint(String checkpoint) throws IOException, ClassNotFoundException, OptionalDataException {
        ObjectInputStream s = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(checkpoint))));
        EvolutionState e = (EvolutionState)s.readObject();
        s.close();
        e.resetFromCheckpoint();
        return e;
    }
}

