/*
 * Decompiled with CFR 0.152.
 */
package ec.vector.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;

public class GeneDuplicationPipeline
extends BreedingPipeline {
    public static final String P_DUPLICATION = "duplicate";
    public static final int NUM_SOURCES = 1;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_DUPLICATION);
    }

    public int numSources() {
        return 1;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        for (int q = start; q < n + start; ++q) {
            VectorIndividual ind;
            int len;
            if (this.sources[0] instanceof SelectionMethod) {
                inds[q] = (Individual)inds[q].clone();
            }
            if ((len = (ind = (VectorIndividual)inds[q]).genomeLength()) == 0) {
                return n;
            }
            int end = 0;
            int begin = state.random[thread].nextInt(len + 1);
            while (begin == (end = state.random[thread].nextInt(len + 1))) {
            }
            if (end < begin) {
                int temp = end;
                end = begin;
                begin = temp;
            }
            Object[] original = new Object[2];
            ind.split(new int[]{0, len}, original);
            Object[] splice = new Object[3];
            ind.split(new int[]{begin, end}, splice);
            ind.cloneGenes(splice[1]);
            ind.join(new Object[]{original[1], splice[1]});
        }
        return n;
    }
}

