/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Prototype;
import ec.util.Parameter;
import ec.util.RandomChoice;
import ec.util.RandomChoiceChooserD;

public abstract class BreedingSource
implements Prototype,
RandomChoiceChooserD {
    public static final String P_PROB = "prob";
    public static final double NO_PROBABILITY = -1.0;
    public double probability;

    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        if (!state.parameters.exists(base.push(P_PROB), def.push(P_PROB))) {
            this.probability = -1.0;
        } else {
            this.probability = state.parameters.getDouble(base.push(P_PROB), def.push(P_PROB), 0.0);
            if (this.probability < 0.0) {
                state.output.error("Breeding Source's probability must be a double floating point value >= 0.0, or empty, which represents NO_PROBABILITY.", base.push(P_PROB), def.push(P_PROB));
            }
        }
    }

    public final double getProbability(Object obj) {
        return ((BreedingSource)obj).probability;
    }

    public final void setProbability(Object obj, double prob) {
        ((BreedingSource)obj).probability = prob;
    }

    public static int pickRandom(BreedingSource[] sources, double prob) {
        return RandomChoice.pickFromDistribution((Object[])sources, sources[0], prob);
    }

    public static void setupProbabilities(BreedingSource[] sources) {
        RandomChoice.organizeDistribution((Object[])sources, sources[0], true);
    }

    public abstract int typicalIndsProduced();

    public abstract boolean produces(EvolutionState var1, Population var2, int var3, int var4);

    public abstract void prepareToProduce(EvolutionState var1, int var2, int var3);

    public abstract void finishProducing(EvolutionState var1, int var2, int var3);

    public abstract int produce(int var1, int var2, int var3, int var4, Individual[] var5, EvolutionState var6, int var7);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void preparePipeline(Object hook) {
    }
}

